/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.typeHierarchy;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.operations.typeHierarchy.TypeHierarchyContentProvider;
import org.eclipse.lsp4e.operations.typeHierarchy.TypeHierarchyItemLabelProvider;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.TypeHierarchyItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.navigator.CommonViewerSorter;

public class TypeHierarchyDialog
extends PopupDialog {
    private final LanguageServersRegistry.LanguageServerDefinition lsDefinition;
    private final @NonNull IDocument document;
    private final ITextSelection textSelection;

    public TypeHierarchyDialog(@NonNull Shell parentShell, ITextSelection textSelection, @NonNull IDocument document,  @NonNull LanguageServersRegistry.LanguageServerDefinition ls) {
        super(parentShell, 16, true, true, true, false, false, null, null);
        this.lsDefinition = ls;
        this.document = document;
        this.textSelection = textSelection;
        this.create();
    }

    protected Control createDialogArea(Composite parent) {
        FilteredTree filteredTree = new FilteredTree(parent, 2048, new PatternFilter(), true, false);
        TreeViewer viewer = filteredTree.getViewer();
        viewer.setContentProvider((IContentProvider)new TypeHierarchyContentProvider(this.lsDefinition, this.document));
        viewer.setLabelProvider((IBaseLabelProvider)new TypeHierarchyItemLabelProvider());
        viewer.addDoubleClickListener(event -> {
            TypeHierarchyItem item = (TypeHierarchyItem)((IStructuredSelection)event.getSelection()).getFirstElement();
            LSPEclipseUtils.open(item.getUri(), item.getSelectionRange());
        });
        CommonViewerSorter sorter = new CommonViewerSorter();
        viewer.setComparator((ViewerComparator)sorter);
        viewer.setUseHashlookup(true);
        viewer.setInput((Object)this.textSelection);
        return filteredTree;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.typeHierarchy);
        shell.setSize(280, 300);
    }
}

