/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceBaseColumnAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourceJoinTableAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableJoinColumnAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

public final class SourceJoinColumnAnnotation
extends SourceBaseColumnAnnotation
implements NestableJoinColumnAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.JoinColumn");
    private final DeclarationAnnotationElementAdapter<String> referencedColumnNameDeclarationAdapter = this.buildStringElementAdapter("referencedColumnName");
    private final AnnotationElementAdapter<String> referencedColumnNameAdapter = this.buildShortCircuitElementAdapter(this.referencedColumnNameDeclarationAdapter);
    private String referencedColumnName;

    public SourceJoinColumnAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
    }

    public SourceJoinColumnAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa) {
        this(parent, member, daa, (AnnotationAdapter)new MemberAnnotationAdapter(member, daa));
    }

    public SourceJoinColumnAnnotation(JavaResourceNode parent, Member member, IndexedDeclarationAnnotationAdapter idaa) {
        this(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new MemberIndexedAnnotationAdapter(member, idaa));
    }

    public String getAnnotationName() {
        return "javax.persistence.JoinColumn";
    }

    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.referencedColumnName = this.buildReferencedColumnName(astRoot);
    }

    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setReferencedColumnName(this.buildReferencedColumnName(astRoot));
    }

    String getNameElementName() {
        return "name";
    }

    String getColumnDefinitionElementName() {
        return "columnDefinition";
    }

    String getTableElementName() {
        return "table";
    }

    String getUniqueElementName() {
        return "unique";
    }

    String getNullableElementName() {
        return "nullable";
    }

    String getInsertableElementName() {
        return "insertable";
    }

    String getUpdatableElementName() {
        return "updatable";
    }

    public String getReferencedColumnName() {
        return this.referencedColumnName;
    }

    public void setReferencedColumnName(String referencedColumnName) {
        if (this.attributeValueHasNotChanged(this.referencedColumnName, referencedColumnName)) {
            return;
        }
        String old = this.referencedColumnName;
        this.referencedColumnName = referencedColumnName;
        this.referencedColumnNameAdapter.setValue(referencedColumnName);
        this.firePropertyChanged("referencedColumnName", old, referencedColumnName);
    }

    private String buildReferencedColumnName(CompilationUnit astRoot) {
        return this.referencedColumnNameAdapter.getValue(astRoot);
    }

    public TextRange getReferencedColumnNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.referencedColumnNameDeclarationAdapter, astRoot);
    }

    public boolean referencedColumnNameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.referencedColumnNameDeclarationAdapter, pos, astRoot);
    }

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        super.initializeFrom(oldAnnotation);
        JoinColumnAnnotation oldJoinColumn = (JoinColumnAnnotation)((Object)oldAnnotation);
        this.setReferencedColumnName(oldJoinColumn.getReferencedColumnName());
    }

    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    protected IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    public static SourceJoinColumnAnnotation createJoinColumn(JavaResourceNode parent, Member member) {
        return new SourceJoinColumnAnnotation(parent, member, DECLARATION_ANNOTATION_ADAPTER);
    }

    static SourceJoinColumnAnnotation createNestedJoinColumn(JavaResourceNode parent, Member member, int index, DeclarationAnnotationAdapter joinColumnsAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = SourceJoinColumnAnnotation.buildNestedDeclarationAnnotationAdapter(index, joinColumnsAdapter);
        MemberIndexedAnnotationAdapter annotationAdapter = new MemberIndexedAnnotationAdapter(member, idaa);
        return new SourceJoinColumnAnnotation(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }

    private static IndexedDeclarationAnnotationAdapter buildNestedDeclarationAnnotationAdapter(int index, DeclarationAnnotationAdapter joinColumnsAdapter) {
        return new NestedIndexedDeclarationAnnotationAdapter(joinColumnsAdapter, index, "javax.persistence.JoinColumn");
    }

    static NestableJoinColumnAnnotation createJoinTableJoinColumn(JavaResourceNode parent, Member member, int index) {
        return new SourceJoinColumnAnnotation(parent, member, SourceJoinColumnAnnotation.buildJoinTableAnnotationAdapter(index));
    }

    private static IndexedDeclarationAnnotationAdapter buildJoinTableAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(SourceJoinTableAnnotation.DECLARATION_ANNOTATION_ADAPTER, "joinColumns", index, "javax.persistence.JoinColumn");
    }

    static NestableJoinColumnAnnotation createJoinTableInverseJoinColumn(JavaResourceNode parent, Member member, int index) {
        return new SourceJoinColumnAnnotation(parent, member, SourceJoinColumnAnnotation.buildJoinTableInverseAnnotationAdapter(index));
    }

    private static IndexedDeclarationAnnotationAdapter buildJoinTableInverseAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(SourceJoinTableAnnotation.DECLARATION_ANNOTATION_ADAPTER, "inverseJoinColumns", index, "javax.persistence.JoinColumn");
    }

    static NestableJoinColumnAnnotation createAssociationOverrideJoinColumn(DeclarationAnnotationAdapter associationOverrideAdapter, JavaResourceNode parent, Member member, int index) {
        return new SourceJoinColumnAnnotation(parent, member, SourceJoinColumnAnnotation.buildAssociationOverrideAnnotationAdapter(associationOverrideAdapter, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildAssociationOverrideAnnotationAdapter(DeclarationAnnotationAdapter associationOverrideAdapter, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(associationOverrideAdapter, "joinColumns", index, "javax.persistence.JoinColumn");
    }
}

