/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceNamedColumnAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.DiscriminatorColumnAnnotation;
import org.eclipse.jpt.core.resource.java.DiscriminatorType;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceDiscriminatorColumnAnnotation
extends SourceNamedColumnAnnotation
implements DiscriminatorColumnAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.DiscriminatorColumn");
    private static final DeclarationAnnotationElementAdapter<String> DISCRIMINATOR_TYPE_ADAPTER = SourceDiscriminatorColumnAnnotation.buildDiscriminatorTypeAdapter();
    private final AnnotationElementAdapter<String> discriminatorTypeAdapter;
    private DiscriminatorType discriminatorType;
    private final DeclarationAnnotationElementAdapter<Integer> lengthDeclarationAdapter;
    private final AnnotationElementAdapter<Integer> lengthAdapter;
    private Integer length;

    public SourceDiscriminatorColumnAnnotation(JavaResourcePersistentType parent, Member member, DeclarationAnnotationAdapter daa) {
        super((JavaResourceNode)parent, member, daa);
        this.discriminatorTypeAdapter = new ShortCircuitAnnotationElementAdapter<String>(member, DISCRIMINATOR_TYPE_ADAPTER);
        this.lengthDeclarationAdapter = this.buildIntegerElementAdapter("length");
        this.lengthAdapter = this.buildShortCircuitIntegerElementAdapter(this.lengthDeclarationAdapter);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.DiscriminatorColumn";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.discriminatorType = this.buildDiscriminatorType(astRoot);
        this.length = this.buildLength(astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setLength(this.buildLength(astRoot));
        this.setDiscriminatorType(this.buildDiscriminatorType(astRoot));
    }

    @Override
    String getNameElementName() {
        return "name";
    }

    @Override
    String getColumnDefinitionElementName() {
        return "columnDefinition";
    }

    @Override
    public DiscriminatorType getDiscriminatorType() {
        return this.discriminatorType;
    }

    @Override
    public void setDiscriminatorType(DiscriminatorType discriminatorType) {
        if (this.attributeValueHasNotChanged((Object)this.discriminatorType, (Object)discriminatorType)) {
            return;
        }
        DiscriminatorType old = this.discriminatorType;
        this.discriminatorType = discriminatorType;
        this.discriminatorTypeAdapter.setValue(DiscriminatorType.toJavaAnnotationValue(discriminatorType));
        this.firePropertyChanged("discriminatorType", (Object)old, (Object)discriminatorType);
    }

    private DiscriminatorType buildDiscriminatorType(CompilationUnit astRoot) {
        return DiscriminatorType.fromJavaAnnotationValue(this.discriminatorTypeAdapter.getValue(astRoot));
    }

    @Override
    public Integer getLength() {
        return this.length;
    }

    @Override
    public void setLength(Integer length) {
        if (this.attributeValueHasNotChanged(this.length, length)) {
            return;
        }
        Integer old = this.length;
        this.length = length;
        this.lengthAdapter.setValue(length);
        this.firePropertyChanged("length", old, length);
    }

    private Integer buildLength(CompilationUnit astRoot) {
        return this.lengthAdapter.getValue(astRoot);
    }

    @Override
    public void initializeFrom(NestableAnnotation oldAnnotation) {
        super.initializeFrom(oldAnnotation);
        DiscriminatorColumnAnnotation oldColumn = (DiscriminatorColumnAnnotation)((Object)oldAnnotation);
        this.setLength(oldColumn.getLength());
        this.setDiscriminatorType(oldColumn.getDiscriminatorType());
    }

    private static DeclarationAnnotationElementAdapter<String> buildDiscriminatorTypeAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "discriminatorType");
    }
}

