/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmBaseEmbeddedMapping;
import org.eclipse.jpt.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.core.context.orm.OrmEmbeddedIdMapping;
import org.eclipse.jpt.core.context.orm.OrmEmbeddedMapping;
import org.eclipse.jpt.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.core.context.orm.OrmManyToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmManyToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmMultiRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmOneToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmOneToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmSingleRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmTransientMapping;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.context.orm.OrmVersionMapping;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmAttributeMapping<T extends XmlAttributeMapping>
extends AbstractXmlContextNode
implements OrmAttributeMapping {
    protected String name;
    protected final T resourceAttributeMapping;

    protected AbstractOrmAttributeMapping(OrmPersistentAttribute parent, T resourceAttributeMapping) {
        super(parent);
        this.resourceAttributeMapping = resourceAttributeMapping;
        this.name = this.getResourceMappingName();
    }

    protected JavaPersistentAttribute getJavaPersistentAttribute() {
        return this.getPersistentAttribute().getJavaPersistentAttribute();
    }

    protected JavaResourcePersistentAttribute getJavaResourcePersistentAttribute() {
        return this.getJavaPersistentAttribute().getResourcePersistentAttribute();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.resourceAttributeMapping.setName(name);
        this.firePropertyChanged("name", old, name);
        this.getPersistentAttribute().nameChanged(old, name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
        this.getPersistentAttribute().nameChanged(old, name);
    }

    @Override
    public OrmPersistentAttribute getPersistentAttribute() {
        return (OrmPersistentAttribute)this.getParent();
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public void initializeFromOrmAttributeMapping(OrmAttributeMapping oldMapping) {
        this.setName(oldMapping.getName());
    }

    public void initializeFromOrmColumnMapping(OrmColumnMapping oldMapping) {
        this.initializeFromOrmAttributeMapping((OrmAttributeMapping)((Object)oldMapping));
    }

    @Override
    public void initializeFromOrmBasicMapping(OrmBasicMapping oldMapping) {
        this.initializeFromOrmColumnMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmIdMapping(OrmIdMapping oldMapping) {
        this.initializeFromOrmColumnMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmTransientMapping(OrmTransientMapping oldMapping) {
        this.initializeFromOrmAttributeMapping(oldMapping);
    }

    public void initializeFromOrmBaseEmbeddedMapping(OrmBaseEmbeddedMapping oldMapping) {
        this.initializeFromOrmAttributeMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmEmbeddedMapping(OrmEmbeddedMapping oldMapping) {
        this.initializeFromOrmBaseEmbeddedMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmEmbeddedIdMapping(OrmEmbeddedIdMapping oldMapping) {
        this.initializeFromOrmBaseEmbeddedMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmVersionMapping(OrmVersionMapping oldMapping) {
        this.initializeFromOrmColumnMapping(oldMapping);
    }

    public void initializeFromOrmRelationshipMapping(OrmRelationshipMapping oldMapping) {
        this.initializeFromOrmAttributeMapping(oldMapping);
    }

    public void initializeFromOrmMultiRelationshipMapping(OrmMultiRelationshipMapping oldMapping) {
        this.initializeFromOrmRelationshipMapping(oldMapping);
    }

    public void initializeFromOrmSingleRelationshipMapping(OrmSingleRelationshipMapping oldMapping) {
        this.initializeFromOrmRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmOneToManyMapping(OrmOneToManyMapping oldMapping) {
        this.initializeFromOrmMultiRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmManyToOneMapping(OrmManyToOneMapping oldMapping) {
        this.initializeFromOrmSingleRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmOneToOneMapping(OrmOneToOneMapping oldMapping) {
        this.initializeFromOrmSingleRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmManyToManyMapping(OrmManyToManyMapping oldMapping) {
        this.initializeFromOrmMultiRelationshipMapping(oldMapping);
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return null;
    }

    @Override
    public OrmTypeMapping getTypeMapping() {
        return this.getPersistentAttribute().getTypeMapping();
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return false;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return false;
    }

    @Override
    public boolean isIdMapping() {
        return false;
    }

    @Override
    public boolean isOwnedBy(RelationshipMapping mapping) {
        return false;
    }

    public T getResourceAttributeMapping() {
        return this.resourceAttributeMapping;
    }

    @Override
    public void update() {
        this.setName_(this.getResourceMappingName());
    }

    protected String getResourceMappingName() {
        return this.resourceAttributeMapping.getName();
    }

    @Override
    public boolean shouldValidateAgainstDatabase() {
        return this.getTypeMapping().shouldValidateAgainstDatabase();
    }

    @Override
    public boolean contains(int textOffset) {
        return this.resourceAttributeMapping.containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.resourceAttributeMapping.getSelectionTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getPersistentAttribute().isVirtual() ? this.getTypeMapping().getAttributesTextRange() : this.resourceAttributeMapping.getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.resourceAttributeMapping.getNameTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateAttribute(messages);
        this.validateMapping(messages);
    }

    protected void validateAttribute(List<IMessage> messages) {
        if (StringTools.stringIsEmpty((String)this.name)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_UNSPECIFIED_NAME", this, this.getValidationTextRange()));
            return;
        }
    }

    protected void validateMapping(List<IMessage> messages) {
        if (!this.getTypeMapping().attributeMappingKeyAllowed(this.getKey())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_INVALID_MAPPING", new String[]{this.name}, this, this.getValidationTextRange()));
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }
}

