/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaTable;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaTable;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.TableAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaTable
extends AbstractJavaTable
implements JavaTable {
    protected JavaResourcePersistentMember resourcePersistentMember;

    public GenericJavaTable(JavaEntity parent) {
        super(parent);
    }

    @Override
    public void initialize(JavaResourcePersistentMember pr) {
        this.resourcePersistentMember = pr;
        this.initialize(this.getResourceTable());
    }

    @Override
    protected TableAnnotation getResourceTable() {
        return (TableAnnotation)this.resourcePersistentMember.getNonNullSupportingAnnotation(this.getAnnotationName());
    }

    protected TableAnnotation getResourceTableOrNull() {
        return (TableAnnotation)this.resourcePersistentMember.getSupportingAnnotation(this.getAnnotationName());
    }

    @Override
    public boolean isResourceSpecified() {
        return this.getResourceTableOrNull() != null;
    }

    @Override
    protected String getAnnotationName() {
        return "javax.persistence.Table";
    }

    @Override
    public JavaEntity getParent() {
        return (JavaEntity)super.getParent();
    }

    protected JavaEntity getJavaEntity() {
        return this.getParent();
    }

    @Override
    protected String buildDefaultName() {
        return this.getJavaEntity().getDefaultTableName();
    }

    @Override
    protected String buildDefaultSchema() {
        return this.getJavaEntity().getDefaultSchema();
    }

    @Override
    protected String buildDefaultCatalog() {
        return this.getJavaEntity().getDefaultCatalog();
    }

    @Override
    public void update(JavaResourcePersistentMember jrpm) {
        this.resourcePersistentMember = jrpm;
        this.update(this.getResourceTable());
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.connectionProfileIsActive()) {
            this.validateAgainstDatabase(messages, astRoot);
        }
    }

    protected void validateAgainstDatabase(List<IMessage> messages, CompilationUnit astRoot) {
        if (!this.hasResolvedCatalog()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TABLE_UNRESOLVED_CATALOG", new String[]{this.getCatalog(), this.getName()}, this, this.getCatalogTextRange(astRoot)));
            return;
        }
        if (!this.hasResolvedSchema()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TABLE_UNRESOLVED_SCHEMA", new String[]{this.getSchema(), this.getName()}, this, this.getSchemaTextRange(astRoot)));
            return;
        }
        if (!this.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "TABLE_UNRESOLVED_NAME", new String[]{this.getName()}, this, this.getNameTextRange(astRoot)));
        }
    }
}

