/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaConverter;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.core.internal.context.java.GenericJavaNullConverter;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.BasicAnnotation;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaBasicMapping
extends AbstractJavaAttributeMapping<BasicAnnotation>
implements JavaBasicMapping {
    protected FetchType specifiedFetch;
    protected Boolean specifiedOptional;
    protected final JavaColumn column = this.createJavaColumn();
    protected final JavaConverter defaultConverter = new GenericJavaNullConverter(this);
    protected JavaConverter specifiedConverter;

    protected AbstractJavaBasicMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    protected JavaColumn createJavaColumn() {
        return this.getJpaFactory().buildJavaColumn(this, this);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.column.initialize(this.getResourceColumn());
        this.specifiedConverter = this.buildSpecifiedConverter(this.getResourceConverterType());
        this.specifiedFetch = this.getResourceFetch();
        this.specifiedOptional = this.getResourceOptional();
    }

    @Override
    public ColumnAnnotation getResourceColumn() {
        return (ColumnAnnotation)this.getResourcePersistentAttribute().getNonNullSupportingAnnotation("javax.persistence.Column");
    }

    @Override
    public String getKey() {
        return "basic";
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Basic";
    }

    @Override
    public Iterator<String> supportingAnnotationNames() {
        return new ArrayIterator((Object[])new String[]{"javax.persistence.Column", "javax.persistence.Lob", "javax.persistence.Temporal", "javax.persistence.Enumerated"});
    }

    @Override
    public String getDefaultColumnName() {
        return this.getName();
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public JavaColumn getColumn() {
        return this.column;
    }

    @Override
    public FetchType getFetch() {
        return this.getSpecifiedFetch() == null ? this.getDefaultFetch() : this.getSpecifiedFetch();
    }

    @Override
    public FetchType getDefaultFetch() {
        return BasicMapping.DEFAULT_FETCH_TYPE;
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        ((BasicAnnotation)this.mappingAnnotation).setFetch(FetchType.toJavaResourceModel(newSpecifiedFetch));
        this.firePropertyChanged("specifiedFetch", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    protected void setSpecifiedFetch_(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        this.firePropertyChanged("specifiedFetch", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    @Override
    public boolean isOptional() {
        return this.getSpecifiedOptional() == null ? this.isDefaultOptional() : this.getSpecifiedOptional().booleanValue();
    }

    @Override
    public boolean isDefaultOptional() {
        return true;
    }

    @Override
    public Boolean getSpecifiedOptional() {
        return this.specifiedOptional;
    }

    @Override
    public void setSpecifiedOptional(Boolean newSpecifiedOptional) {
        Boolean oldOptional = this.specifiedOptional;
        this.specifiedOptional = newSpecifiedOptional;
        ((BasicAnnotation)this.mappingAnnotation).setOptional(newSpecifiedOptional);
        this.firePropertyChanged("specifiedOptional", oldOptional, newSpecifiedOptional);
    }

    protected void setSpecifiedOptional_(Boolean newSpecifiedOptional) {
        Boolean oldOptional = this.specifiedOptional;
        this.specifiedOptional = newSpecifiedOptional;
        this.firePropertyChanged("specifiedOptional", oldOptional, newSpecifiedOptional);
    }

    @Override
    public JavaConverter getConverter() {
        return this.getSpecifiedConverter() == null ? this.getDefaultConverter() : this.getSpecifiedConverter();
    }

    @Override
    public JavaConverter getDefaultConverter() {
        return this.defaultConverter;
    }

    @Override
    public JavaConverter getSpecifiedConverter() {
        return this.specifiedConverter;
    }

    protected String getSpecifedConverterType() {
        if (this.specifiedConverter == null) {
            return "noConverter";
        }
        return this.specifiedConverter.getType();
    }

    @Override
    public void setSpecifiedConverter(String converterType) {
        if (this.getSpecifedConverterType() == converterType) {
            return;
        }
        JavaConverter oldConverter = this.specifiedConverter;
        JavaConverter newConverter = this.buildSpecifiedConverter(converterType);
        this.specifiedConverter = null;
        if (oldConverter != null) {
            oldConverter.removeFromResourceModel();
        }
        this.specifiedConverter = newConverter;
        if (newConverter != null) {
            newConverter.addToResourceModel();
        }
        this.firePropertyChanged("specifiedConverter", oldConverter, newConverter);
    }

    protected void setSpecifiedConverter(JavaConverter newConverter) {
        JavaConverter oldConverter = this.specifiedConverter;
        this.specifiedConverter = newConverter;
        this.firePropertyChanged("specifiedConverter", oldConverter, newConverter);
    }

    @Override
    protected void update() {
        super.update();
        this.column.update(this.getResourceColumn());
        if (this.getResourceConverterType() == this.getSpecifedConverterType()) {
            this.getSpecifiedConverter().update(this.resourcePersistentAttribute);
        } else {
            JavaConverter javaConverter = this.buildSpecifiedConverter(this.getResourceConverterType());
            this.setSpecifiedConverter(javaConverter);
        }
        this.setSpecifiedFetch_(this.getResourceFetch());
        this.setSpecifiedOptional_(this.getResourceOptional());
    }

    protected FetchType getResourceFetch() {
        return FetchType.fromJavaResourceModel(((BasicAnnotation)this.mappingAnnotation).getFetch());
    }

    protected Boolean getResourceOptional() {
        return ((BasicAnnotation)this.mappingAnnotation).getOptional();
    }

    protected JavaConverter buildSpecifiedConverter(String converterType) {
        if (converterType == "enumeratedConverter") {
            return this.getJpaFactory().buildJavaEnumeratedConverter(this, this.resourcePersistentAttribute);
        }
        if (converterType == "temporalConverter") {
            return this.getJpaFactory().buildJavaTemporalConverter(this, this.resourcePersistentAttribute);
        }
        if (converterType == "lobConverter") {
            return this.getJpaFactory().buildJavaLobConverter(this, this.resourcePersistentAttribute);
        }
        return null;
    }

    protected String getResourceConverterType() {
        if (this.resourcePersistentAttribute.getSupportingAnnotation("javax.persistence.Enumerated") != null) {
            return "enumeratedConverter";
        }
        if (this.resourcePersistentAttribute.getSupportingAnnotation("javax.persistence.Temporal") != null) {
            return "temporalConverter";
        }
        if (this.resourcePersistentAttribute.getSupportingAnnotation("javax.persistence.Lob") != null) {
            return "lobConverter";
        }
        return null;
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getColumn().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.shouldValidateAgainstDatabase()) {
            this.validateColumn(messages, astRoot);
        }
        if (this.specifiedConverter != null) {
            this.specifiedConverter.validate(messages, reporter, astRoot);
        }
    }

    protected void validateColumn(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getTypeMapping().tableNameIsInvalid(this.column.getTable())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{this.column.getTable(), this.column.getName()}, this.column, this.column.getTableTextRange(astRoot)));
            return;
        }
        if (!this.column.isResolved() && this.column.getDbTable() != null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{this.column.getName()}, this.column, this.column.getNameTextRange(astRoot)));
        }
    }
}

