/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.deployables;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.deployables.BinaryFileModuleDelegate;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.flat.IChildModuleReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Module;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ProjectModuleFactoryDelegate;
import org.eclipse.wst.web.internal.deployables.FlatComponentDeployable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2EEDeployableFactory
extends ProjectModuleFactoryDelegate
implements IResourceChangeListener {
    protected Map<IModule, FlatComponentDeployable> moduleDelegates = new HashMap<IModule, FlatComponentDeployable>(5);
    public static final String J2EE_ID = "org.eclipse.jst.j2ee.server";
    public static final String BINARY_PREFIX = "/binary:";
    public static J2EEDeployableFactory J2EE_INSTANCE;

    public static J2EEDeployableFactory j2eeInstance() {
        if (J2EE_INSTANCE == null) {
            J2EEDeployableFactory.ensureFactoryLoaded(J2EE_ID);
        }
        return J2EE_INSTANCE;
    }

    public static void ensureFactoryLoaded(String factoryId) {
        ModuleFactory[] factories = ServerPlugin.getModuleFactories();
        int i = 0;
        while (i < factories.length) {
            if (factories[i].getId().equals(factoryId)) {
                factories[i].getDelegate((IProgressMonitor)new NullProgressMonitor());
            }
            ++i;
        }
    }

    public void initialize() {
        super.initialize();
        if (this.getId().equals(J2EE_ID)) {
            J2EE_INSTANCE = this;
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected IModule[] createModules(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            return this.createModuleDelegates(component);
        }
        return null;
    }

    public ModuleDelegate getModuleDelegate(IModule module) {
        if (module == null) {
            return null;
        }
        ModuleDelegate md = (ModuleDelegate)this.moduleDelegates.get(module);
        if (md == null && ((Module)module).getInternalId().startsWith(BINARY_PREFIX)) {
            return this.createDelegate(module);
        }
        if (md == null) {
            this.createModules(module.getProject());
            md = (ModuleDelegate)this.moduleDelegates.get(module);
        }
        return md;
    }

    protected boolean canHandleProject(IProject p) {
        IVirtualComponent comp = ComponentCore.createComponent((IProject)p);
        return JavaEEProjectUtilities.usesJavaEEComponent(comp) && J2EEProjectUtilities.isLegacyJ2EEProject(p);
    }

    protected IModule[] createModuleDelegates(IVirtualComponent component) {
        ArrayList<IModule> projectModules;
        block6: {
            if (component == null) {
                return null;
            }
            projectModules = new ArrayList<IModule>();
            try {
                if (this.canHandleProject(component.getProject())) {
                    String type = JavaEEProjectUtilities.getJ2EEProjectType(component.getProject());
                    String version = J2EEProjectUtilities.getJ2EEProjectVersion(component.getProject());
                    HashMap<String, String> props = new HashMap<String, String>();
                    String componentName = component.getName();
                    String deployedName = component.getDeployedName();
                    props.put("org.eclipse.wst.server.core.deployName", component.getDeployedName());
                    if (componentName != null && deployedName != null && !componentName.equals(deployedName)) {
                        props.put("org.eclipse.wst.server.core.displayName", String.valueOf(componentName) + "(" + deployedName + ")");
                    }
                    IModule module = this.createModule(component.getName(), component.getName(), type, version, component.getProject(), props);
                    FlatComponentDeployable moduleDelegate = this.createModuleDelegate(component.getProject(), component);
                    this.moduleDelegates.put(module, moduleDelegate);
                    projectModules.add(module);
                    if ("jst.ear".equals(type)) {
                        projectModules.addAll(this.LEGACY_createBinaryModules(component));
                    }
                    break block6;
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                J2EEPlugin.logError(e);
            }
        }
        return projectModules.toArray(new IModule[projectModules.size()]);
    }

    protected FlatComponentDeployable createModuleDelegate(IProject project, IVirtualComponent component) {
        return new J2EEFlexProjDeployable(project, component);
    }

    protected List<IModule> LEGACY_createBinaryModules(IVirtualComponent component) {
        ArrayList<IModule> projectModules = new ArrayList<IModule>();
        IVirtualReference[] references = component.getReferences();
        int i = 0;
        while (i < references.length) {
            JavaEEQuickPeek quickPeek;
            IModule nestedModule;
            IVirtualComponent moduleComponent = references[i].getReferencedComponent();
            if (moduleComponent.isBinary() && (nestedModule = this.createModule(quickPeek = JavaEEBinaryComponentHelper.getJavaEEQuickPeek(moduleComponent), moduleComponent.getName(), moduleComponent.getDeployedName(), moduleComponent.getProject())) != null) {
                FlatComponentDeployable moduleDelegate = this.getNestedDelegate(moduleComponent);
                this.moduleDelegates.put(nestedModule, moduleDelegate);
                projectModules.add(nestedModule);
            }
            ++i;
        }
        return projectModules;
    }

    protected FlatComponentDeployable getNestedDelegate(IVirtualComponent component) {
        return new J2EEFlexProjDeployable(component.getProject(), component);
    }

    protected IModule createModule(JavaEEQuickPeek quickPeek, String id, String name, IProject project) {
        if (quickPeek.getType() == -1) {
            return null;
        }
        String moduleType = null;
        String moduleVersion = null;
        switch (quickPeek.getType()) {
            case 3: {
                moduleType = "jst.appclient";
                break;
            }
            case 4: {
                moduleType = "jst.web";
                break;
            }
            case 0: {
                moduleType = "jst.ejb";
                break;
            }
            case 2: {
                moduleType = "jst.connector";
                break;
            }
            case 1: {
                moduleType = "jst.ear";
                break;
            }
            case 6: {
                moduleType = "jst.webfragment";
                break;
            }
            default: {
                moduleType = "jst.utility";
                moduleVersion = "1.0";
            }
        }
        int version = quickPeek.getVersion();
        moduleVersion = J2EEVersionUtil.convertVersionIntToString(version);
        IModule nestedModule = this.createModule(id, name, moduleType, moduleVersion, project);
        return nestedModule;
    }

    protected IPath[] getListenerPaths() {
        return new IPath[]{new Path(".project"), new Path(StructureEdit.MODULE_META_FILE_NAME), new Path(".settings/org.eclipse.wst.common.project.facet.core.xml")};
    }

    protected void clearCache(IProject project) {
        super.clearCache(project);
        ArrayList<IModule> modulesToRemove = null;
        for (IModule module : this.moduleDelegates.keySet()) {
            if (module.getProject() == null || !module.getProject().equals((Object)project)) continue;
            if (modulesToRemove == null) {
                modulesToRemove = new ArrayList<IModule>();
            }
            modulesToRemove.add(module);
        }
        if (modulesToRemove != null) {
            for (IModule module : modulesToRemove) {
                this.moduleDelegates.remove(module);
            }
        }
    }

    public IModule createChildModule(FlatComponentDeployable parent, IChildModuleReference child) {
        File file = child.getFile();
        if (file != null) {
            Path p = new Path(file.getAbsolutePath());
            JavaEEQuickPeek qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek((IPath)p);
            IModule module = this.createModule(qp, BINARY_PREFIX + file.getAbsolutePath(), file.getName(), parent.getProject());
            FlatComponentDeployable moduleDelegate = this.getNestedDelegate(child.getComponent());
            this.moduleDelegates.put(module, moduleDelegate);
            return module;
        }
        return null;
    }

    public ModuleDelegate createDelegate(IModule module) {
        String internalId = ((Module)module).getInternalId();
        String path = internalId.substring(BINARY_PREFIX.length());
        File f = new File(path);
        return new BinaryFileModuleDelegate(f);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.cleanAllDelegates();
    }

    protected void cleanAllDelegates() {
        Iterator<FlatComponentDeployable> i = this.moduleDelegates.values().iterator();
        while (i.hasNext()) {
            i.next().clearCache();
        }
        this.modulesChanged();
    }
}

