/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.platform;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.JpaPlatformUiFactory;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaPlatformUiRegistry {
    private static final JpaPlatformUiRegistry INSTANCE = new JpaPlatformUiRegistry();
    private static final String EXTENSION_ID = "jpaPlatformUis";
    private static final String EL_PLATFORM_UI = "jpaPlatformUi";
    private static final String AT_ID = "id";
    private static final String AT_JPA_PLATFORM = "jpaPlatform";
    private static final String AT_FACTORY_CLASS = "factoryClass";
    private Map<String, IConfigurationElement> jpaPlatformUiConfigElements;
    private Map<String, JpaPlatformUi> jpaPlatformUis;

    public static JpaPlatformUiRegistry instance() {
        return INSTANCE;
    }

    private JpaPlatformUiRegistry() {
        this.buildJpaPlatformUiConfigElements();
        this.jpaPlatformUis = new HashMap<String, JpaPlatformUi>();
    }

    private void buildJpaPlatformUiConfigElements() {
        this.jpaPlatformUiConfigElements = new HashMap<String, IConfigurationElement>();
        Iterator<IConfigurationElement> stream = this.allConfigElements();
        while (stream.hasNext()) {
            this.buildJpaPlatformUi(stream.next());
        }
    }

    private void buildJpaPlatformUi(IConfigurationElement configElement) {
        if (!configElement.getName().equals(EL_PLATFORM_UI)) {
            return;
        }
        String platformUiId = configElement.getAttribute(AT_ID);
        String platform = configElement.getAttribute(AT_JPA_PLATFORM);
        String platformUiFactoryClass = configElement.getAttribute(AT_FACTORY_CLASS);
        if (platformUiId == null || platformUiFactoryClass == null) {
            if (platformUiId == null) {
                this.reportMissingAttribute(configElement, AT_ID);
            }
            if (platform == null) {
                this.reportMissingAttribute(configElement, AT_JPA_PLATFORM);
            }
            if (platformUiFactoryClass == null) {
                this.reportMissingAttribute(configElement, AT_FACTORY_CLASS);
            }
            return;
        }
        if (this.jpaPlatformUiConfigElements.containsKey(platformUiId)) {
            IConfigurationElement otherConfigElement = this.jpaPlatformUiConfigElements.get(platform);
            this.reportDuplicatePlatformUi(configElement, otherConfigElement);
        }
        this.jpaPlatformUiConfigElements.put(platformUiId, configElement);
    }

    public JpaPlatformUi getJpaPlatformUi(String platformId) {
        JpaPlatformUiFactory jpaPlatformUiFactory;
        if (this.jpaPlatformUis.containsKey(platformId)) {
            return this.jpaPlatformUis.get(platformId);
        }
        IConfigurationElement registeredConfigElement = null;
        for (IConfigurationElement configurationElement : this.jpaPlatformUiConfigElements.values()) {
            if (!configurationElement.getAttribute(AT_JPA_PLATFORM).equals(platformId)) continue;
            registeredConfigElement = configurationElement;
            break;
        }
        if (registeredConfigElement == null) {
            return null;
        }
        try {
            jpaPlatformUiFactory = (JpaPlatformUiFactory)registeredConfigElement.createExecutableExtension(AT_FACTORY_CLASS);
        }
        catch (CoreException coreException) {
            this.reportFailedInstantiation(registeredConfigElement);
            throw new IllegalArgumentException(platformId);
        }
        JpaPlatformUi platformUi = jpaPlatformUiFactory.buildJpaPlatformUi();
        this.jpaPlatformUis.put(platformId, platformUi);
        return platformUi;
    }

    private Iterator<IConfigurationElement> allConfigElements() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.jpt.ui", EXTENSION_ID);
        Object[] extensions = extensionPoint.getExtensions();
        return new CompositeIterator((Iterator)new TransformationIterator<IExtension, Iterator<IConfigurationElement>>(CollectionTools.iterator((Object[])extensions)){

            protected Iterator<IConfigurationElement> transform(IExtension extension) {
                return CollectionTools.iterator((Object[])extension.getConfigurationElements());
            }
        });
    }

    private void reportMissingAttribute(IConfigurationElement configElement, String attributeName) {
        String message = "An extension element \"" + configElement.getName() + "\" in plugin \"" + configElement.getContributor().getName() + "\" is missing a required attribute \"" + attributeName + "\".";
        JptUiPlugin.log(message);
    }

    private void reportDuplicatePlatformUi(IConfigurationElement oneConfigElement, IConfigurationElement otherConfigElement) {
        String message = "The plugins \"" + oneConfigElement.getContributor().getName() + "\" and \"" + otherConfigElement.getContributor().getName() + "\" have registered a duplicate attribute \"id\" " + "for the extension element \"jpaPlatformUi\".";
        JptUiPlugin.log(message);
    }

    private void reportFailedInstantiation(IConfigurationElement configElement) {
        String message = "Could not instantiate the class \"" + configElement.getAttribute(AT_FACTORY_CLASS) + "\" for the extension element \"" + configElement.getName() + "\" in the plugin \"" + configElement.getContributor().getName() + "\".";
        JptUiPlugin.log(message);
    }
}

