/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ejb.ui.internal.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.ui.dialogs.OpenTypeSelectionDialog;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jst.ejb.ui.internal.util.EJBUIMessages;
import org.eclipse.jst.j2ee.ejb.internal.operations.BusinessInterface;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class BusinessInterfaceSelectionDialog
extends OpenTypeSelectionDialog {
    private Button remoteRadio;
    private Button localRadio;
    private List<BusinessInterface> resultToReturn;

    public BusinessInterfaceSelectionDialog(Shell parent, boolean multi, IRunnableContext context, IJavaSearchScope scope, int elementKinds) {
        this(parent, multi, context, scope, elementKinds, null);
    }

    public BusinessInterfaceSelectionDialog(Shell parent, boolean multi, IRunnableContext context, IJavaSearchScope scope, int elementKinds, TypeSelectionExtension extension) {
        super(parent, false, context, scope, elementKinds, extension);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Label label = new Label(area, 0);
        label.setText(EJBUIMessages.addAs);
        label.setLayoutData((Object)new GridData(768));
        this.remoteRadio = new Button(area, 16);
        this.remoteRadio.setText(EJBUIMessages.REMOTE_BUSINESS_INTERFACE);
        this.remoteRadio.setSelection(false);
        this.remoteRadio.setLayoutData((Object)new GridData(768));
        this.localRadio = new Button(area, 16);
        this.localRadio.setText(EJBUIMessages.LOCAL_BUSINESS_INTERFACE);
        this.localRadio.setSelection(true);
        this.localRadio.setLayoutData((Object)new GridData(768));
        return area;
    }

    public void setResult(List newResult) {
        this.resultToReturn = new ArrayList<BusinessInterface>();
        for (TypeNameMatch typeNameMatch : newResult) {
            IType javaType = typeNameMatch.getType();
            BusinessInterface.BusinessInterfaceType type = this.localRadio.getSelection() ? BusinessInterface.BusinessInterfaceType.LOCAL : BusinessInterface.BusinessInterfaceType.REMOTE;
            this.resultToReturn.add(new BusinessInterface(javaType, type));
        }
    }

    public BusinessInterface[] getResult() {
        return this.resultToReturn.toArray(new BusinessInterface[0]);
    }
}

