/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.transport;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFPacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.JSON;
import org.eclipse.wst.jsdt.debug.transport.packet.Event;

public class CFEventPacket
extends CFPacket
implements Event {
    public static final String EVENT = "event";
    public static final String CLOSED = "closed";
    public static final String ON_SCRIPT = "onScript";
    public static final String ON_BREAK = "onBreak";
    public static final String ON_CONSOLE_DEBUG = "onConsoleDebug";
    public static final String ON_CONSOLE_ERROR = "onConsoleError";
    public static final String ON_CONSOLE_INFO = "onConsoleInfo";
    public static final String ON_CONSOLE_LOG = "onConsoleLog";
    public static final String ON_CONSOLE_WARN = "onConsoleWarn";
    public static final String ON_ERROR = "onError";
    public static final String ON_INSPECT_NODE = "onInspectNode";
    public static final String ON_RESUME = "onResume";
    public static final String ON_TOGGLE_BREAKPOINT = "onToggleBreakpoint";
    public static final String ON_CONTEXT_SELECTED = "onContextSelected";
    public static final String ON_CONTEXT_DESTROYED = "onContextDestroyed";
    public static final String ON_CONTEXT_CREATED = "onContextCreated";
    public static final String ON_CONTEXT_LOADED = "onContextLoaded";
    private final String event;
    private final Map body = Collections.synchronizedMap(new HashMap());

    public CFEventPacket(String event) {
        super(EVENT, null);
        this.event = event.intern();
    }

    public CFEventPacket(Map json) {
        super(json);
        String packetEvent = (String)json.get(EVENT);
        this.event = packetEvent.intern();
        Object data = json.get("body");
        if (data instanceof Map) {
            this.body.putAll((Map)data);
        } else if (data instanceof String || data instanceof List) {
            this.body.put("body", data);
        }
    }

    public String getContextId() {
        String id = super.getContextId();
        if (id == null) {
            id = (String)this.body.get("contextId");
        }
        return id;
    }

    public String getEvent() {
        return this.event;
    }

    public Map getBody() {
        return this.body;
    }

    public Map toJSON() {
        Map json = super.toJSON();
        json.put(EVENT, this.event);
        if (this.body.size() > 0) {
            json.put("body", this.body);
        }
        return json;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Map json = this.toJSON();
        buffer.append("CFEventPacket: ");
        JSON.writeValue(json, buffer);
        return buffer.toString();
    }
}

