/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ContainerImpl;

public class ReadOnlyDirectoryImpl
extends ContainerImpl
implements ReadOnlyDirectory {
    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.READ_ONLY_DIRECTORY;
    }

    public boolean containsFile(String aUri) {
        this.getFiles();
        return this.getFileIndex().containsKey(aUri);
    }

    public boolean containsFileInSelfOrSubdirectory(String aUri) {
        return this.getLoadStrategy().contains(aUri);
    }

    public File getFileInSelfOrSubdirectory(String aUri) throws FileNotFoundException {
        if (!this.containsFileInSelfOrSubdirectory(aUri)) {
            throw new FileNotFoundException(aUri);
        }
        if (this.containsFile(aUri)) {
            return this.getFile(aUri);
        }
        List subdirs = this.getReadOnlyDirectories();
        int i = 0;
        while (i < subdirs.size()) {
            ReadOnlyDirectory subdir = (ReadOnlyDirectory)subdirs.get(i);
            if (subdir.containsFileInSelfOrSubdirectory(aUri)) {
                return subdir.getFileInSelfOrSubdirectory(aUri);
            }
            ++i;
        }
        throw new FileNotFoundException(aUri);
    }

    public List getFilesRecursive() {
        ArrayList<File> allFiles = new ArrayList<File>();
        EList filesList = this.getFiles();
        int i = 0;
        while (i < filesList.size()) {
            File aFile = (File)filesList.get(i);
            if (aFile.isReadOnlyDirectory()) {
                allFiles.addAll(((ReadOnlyDirectory)aFile).getFilesRecursive());
            } else {
                allFiles.add(aFile);
            }
            ++i;
        }
        return allFiles;
    }

    public List getReadOnlyDirectories() {
        ArrayList<File> filtered = new ArrayList<File>();
        EList filesList = this.getFiles();
        int i = 0;
        while (i < filesList.size()) {
            File aFile = (File)filesList.get(i);
            if (aFile.isReadOnlyDirectory()) {
                filtered.add(aFile);
            }
            ++i;
        }
        return filtered;
    }

    public boolean isReadOnlyDirectory() {
        return true;
    }
}

