/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.util.CoreUtility;
import org.eclipse.wst.jsdt.ui.wizards.ClasspathAttributeConfiguration;

public class ClasspathAttributeConfigurationDescriptors {
    private static final String ATT_EXTENSION = "classpathAttributeConfiguration";
    private HashMap fDescriptors = null;

    private HashMap getDescriptors() {
        if (this.fDescriptors == null) {
            this.fDescriptors = ClasspathAttributeConfigurationDescriptors.readExtensions();
        }
        return this.fDescriptors;
    }

    public boolean containsKey(String attributeKey) {
        return this.getDescriptors().containsKey(attributeKey);
    }

    public ClasspathAttributeConfiguration get(final String attributeKey) {
        final Descriptor desc = (Descriptor)this.getDescriptors().get(attributeKey);
        if (desc == null) {
            return null;
        }
        final ClasspathAttributeConfiguration[] res = new ClasspathAttributeConfiguration[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                JavaScriptPlugin.log(exception);
                ClasspathAttributeConfigurationDescriptors.this.getDescriptors().remove(attributeKey);
            }

            public void run() throws Exception {
                res[0] = desc.getInstance();
            }
        });
        return res[0];
    }

    private static HashMap readExtensions() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wst.jsdt.ui", ATT_EXTENSION);
        HashMap<String, Descriptor> descriptors = new HashMap<String, Descriptor>(elements.length * 2);
        int i = 0;
        while (i < elements.length) {
            try {
                Descriptor curr = new Descriptor(elements[i]);
                descriptors.put(curr.getKey(), curr);
            }
            catch (CoreException e) {
                JavaScriptPlugin.log(e);
            }
            ++i;
        }
        return descriptors;
    }

    private static class Descriptor {
        private IConfigurationElement fConfigElement;
        private ClasspathAttributeConfiguration fInstance;
        private static final String ATT_NAME = "attributeName";
        private static final String ATT_CLASS = "class";

        public Descriptor(IConfigurationElement configElement) throws CoreException {
            this.fConfigElement = configElement;
            this.fInstance = null;
            String name = configElement.getAttribute(ATT_NAME);
            String pageClassName = configElement.getAttribute(ATT_CLASS);
            if (name == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 0, "Invalid extension (missing attributeName)", null));
            }
            if (pageClassName == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 0, "Invalid extension (missing class name): " + name, null));
            }
        }

        public ClasspathAttributeConfiguration getInstance() throws CoreException {
            if (this.fInstance == null) {
                Object elem = CoreUtility.createExtension(this.fConfigElement, ATT_CLASS);
                if (elem instanceof ClasspathAttributeConfiguration) {
                    this.fInstance = (ClasspathAttributeConfiguration)elem;
                } else {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 0, "Invalid extension (page not of type IJsGlobalScopeContainerPage): " + this.getKey(), null));
                }
            }
            return this.fInstance;
        }

        public String getKey() {
            return this.fConfigElement.getAttribute(ATT_NAME);
        }
    }
}

