/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.resource;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.jsf.common.internal.managedobject.IManagedObject;
import org.eclipse.jst.jsf.common.internal.managedobject.ObjectManager;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.LifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceSingletonObjectManager<MANAGEDOBJECT extends IManagedObject, RESOURCE extends IResource>
extends ObjectManager<MANAGEDOBJECT, RESOURCE> {
    private LifecycleListener _lifecycleListener;
    private final Map<RESOURCE, ManagedResourceObject> _perResourceObjects = new HashMap<RESOURCE, ManagedResourceObject>();

    protected ResourceSingletonObjectManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final MANAGEDOBJECT getInstance(RESOURCE key) throws ObjectManager.ManagedObjectException {
        ResourceSingletonObjectManager resourceSingletonObjectManager = this;
        synchronized (resourceSingletonObjectManager) {
            this.runBeforeGetInstance(key);
            ManagedResourceObject managedResObject = this._perResourceObjects.get(key);
            if (managedResObject == null) {
                MANAGEDOBJECT managedObject = this.createNewInstance(key);
                if (managedObject == null) {
                    throw new ObjectManager.ManagedObjectException("No object available for resource");
                }
                managedResObject = this.manageResource(key, managedObject);
            }
            this.runAfterGetInstance(key);
            return managedResObject.getManagedObject();
        }
    }

    protected abstract MANAGEDOBJECT createNewInstance(RESOURCE var1);

    protected void runBeforeGetInstance(RESOURCE resource) {
    }

    protected void runAfterGetInstance(RESOURCE resource) {
    }

    public synchronized boolean isInstance(RESOURCE resource) {
        return this._perResourceObjects.containsKey(resource);
    }

    public synchronized Collection<RESOURCE> getManagedResources() {
        HashSet resources = new HashSet(this._perResourceObjects.keySet());
        return resources;
    }

    private synchronized ManagedResourceObject manageResource(RESOURCE resource, MANAGEDOBJECT managedObject) {
        LifecycleListener listener = this.lazilyGetLifecycleListener();
        listener.addResource((IResource)resource);
        MyLifecycleEventListener eventListener = new MyLifecycleEventListener(this, (IManagedObject)managedObject, (IResource)resource);
        listener.addListener(eventListener);
        ManagedResourceObject managedResourceObject = new ManagedResourceObject(this, (IManagedObject)managedObject, eventListener);
        this._perResourceObjects.put(resource, managedResourceObject);
        return managedResourceObject;
    }

    protected final synchronized void unmanageResource(RESOURCE resource) {
        ManagedResourceObject managedResourceObject = this._perResourceObjects.remove(resource);
        LifecycleListener listener = this.lazilyGetLifecycleListener();
        if (managedResourceObject != null) {
            listener.removeListener(managedResourceObject.getEventListener());
        }
        listener.removeResource((IResource)resource);
    }

    protected final void addLifecycleEventListener(IResourceLifecycleListener listener) {
        LifecycleListener lifecycleListener = this.lazilyGetLifecycleListener();
        lifecycleListener.addListener(listener);
    }

    protected final void removeLifecycleEventListener(IResourceLifecycleListener listener) {
        LifecycleListener lifecycleListener = this.lazilyGetLifecycleListener();
        lifecycleListener.removeListener(listener);
    }

    private synchronized LifecycleListener lazilyGetLifecycleListener() {
        if (this._lifecycleListener == null) {
            this._lifecycleListener = new LifecycleListener();
        }
        return this._lifecycleListener;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ManagedResourceObject {
        private final MANAGEDOBJECT _managedObject;
        private final MyLifecycleEventListener _eventListener;
        final /* synthetic */ ResourceSingletonObjectManager this$0;

        private ManagedResourceObject(MANAGEDOBJECT managedObject, MyLifecycleEventListener eventListener) {
            this.this$0 = var1_1;
            this._managedObject = managedObject;
            this._eventListener = eventListener;
        }

        public MANAGEDOBJECT getManagedObject() {
            return this._managedObject;
        }

        public MyLifecycleEventListener getEventListener() {
            return this._eventListener;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyLifecycleEventListener
    implements IResourceLifecycleListener {
        private final RESOURCE _resource;
        private final MANAGEDOBJECT _managedObject;
        final /* synthetic */ ResourceSingletonObjectManager this$0;

        private MyLifecycleEventListener(MANAGEDOBJECT managedObject, RESOURCE resource) {
            this.this$0 = var1_1;
            this._resource = resource;
            this._managedObject = managedObject;
        }

        @Override
        public IResourceLifecycleListener.EventResult acceptEvent(ResourceLifecycleEvent event) {
            IResourceLifecycleListener.EventResult result = IResourceLifecycleListener.EventResult.getDefaultEventResult();
            if (!this._resource.equals(event.getAffectedResource())) {
                return IResourceLifecycleListener.EventResult.getDefaultEventResult();
            }
            if (event.getEventType() == ResourceLifecycleEvent.EventType.RESOURCE_INACCESSIBLE) {
                try {
                    if (event.getReasonType() == ResourceLifecycleEvent.ReasonType.RESOURCE_DELETED || event.getReasonType() == ResourceLifecycleEvent.ReasonType.RESOURCE_PROJECT_DELETED) {
                        this._managedObject.destroy();
                    } else {
                        this._managedObject.dispose();
                    }
                }
                finally {
                    this.this$0.unmanageResource(this._resource);
                }
            }
            return result;
        }
    }
}

