/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.nano.serviceability.dump.internal;

import java.io.File;
import java.io.IOException;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.virgo.nano.serviceability.dump.internal.StateWriter;
import org.eclipse.virgo.nano.serviceability.dump.internal.SystemStateAccessor;
import org.eclipse.virgo.util.io.PathReference;
import org.eclipse.virgo.util.io.ZipUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResolutionStateDumper {
    private static final String ENTRY_NAME_STATE = "state/";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SystemStateAccessor systemStateAccessor;
    private final StateWriter stateWriter;

    public ResolutionStateDumper(SystemStateAccessor systemStateAccessor, StateWriter stateWriter) {
        this.systemStateAccessor = systemStateAccessor;
        this.stateWriter = stateWriter;
    }

    public void dump(File outputFile) {
        this.dump(outputFile, this.systemStateAccessor.getSystemState());
    }

    public void dump(File outputFile, State state) {
        File outdir = new File(this.getTmpDir(), "resolve-" + System.currentTimeMillis());
        if (outdir.mkdirs()) {
            try {
                this.stateWriter.writeState(state, outdir);
            }
            catch (IOException e) {
                this.logger.error("Unable to write resolver state.", (Throwable)e);
            }
        } else {
            throw new RuntimeException("Unable to create temporary directory '" + outdir.getAbsolutePath() + "'.");
        }
        try {
            try {
                this.zipStateDirectory(outputFile, outdir);
            }
            catch (IOException e) {
                this.logger.error("Unable to create ZIP of state dump", (Throwable)e);
                if (!new PathReference(outdir).delete(true)) {
                    this.logger.warn("Temporary state directory '%s' was not removed after use.", (Object)outdir.getAbsolutePath());
                }
            }
        }
        finally {
            if (!new PathReference(outdir).delete(true)) {
                this.logger.warn("Temporary state directory '%s' was not removed after use.", (Object)outdir.getAbsolutePath());
            }
        }
    }

    private void zipStateDirectory(File outputFile, File dumpDir) throws IOException {
        PathReference output = new PathReference(outputFile);
        PathReference toZip = new PathReference(dumpDir);
        ZipUtils.zipTo((PathReference)toZip, (PathReference)output, (String)ENTRY_NAME_STATE);
    }

    private String getTmpDir() {
        String path = System.getProperty("java.io.tmpdir");
        return path;
    }
}

