/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.env;

public enum JvmVendor {
    SUN("Sun"),
    APPLE("Apple"),
    IBM("IBM"),
    BEA("BEA"),
    UNKNOWN("unknown");

    private static final JvmVendor current;
    private final String identifer;

    static {
        String vmVendor = System.getProperty("java.vm.vendor");
        JvmVendor foundVendor = null;
        JvmVendor[] jvmVendorArray = JvmVendor.values();
        int n = jvmVendorArray.length;
        int n2 = 0;
        while (n2 < n) {
            JvmVendor vendor = jvmVendorArray[n2];
            if (vmVendor.contains(vendor.identifer)) {
                foundVendor = vendor;
                break;
            }
            ++n2;
        }
        current = foundVendor == null ? UNKNOWN : foundVendor;
    }

    private JvmVendor(String identifer) {
        this.identifer = identifer;
    }

    public static JvmVendor current() {
        return current;
    }

    public boolean isOneOf(JvmVendor ... jvmVendors) {
        JvmVendor[] jvmVendorArray = jvmVendors;
        int n = jvmVendors.length;
        int n2 = 0;
        while (n2 < n) {
            JvmVendor jvmVendor = jvmVendorArray[n2];
            if (this.equals((Object)jvmVendor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

