/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.bundlor.support.contributors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.bundlor.support.ManifestTemplateModifier;
import org.eclipse.virgo.bundlor.support.PartialManifestModifier;
import org.eclipse.virgo.bundlor.support.partialmanifest.ReadablePartialManifest;
import org.eclipse.virgo.bundlor.util.SimpleParserLogger;
import org.eclipse.virgo.bundlor.util.StringUtils;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderDeclaration;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParser;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParserFactory;
import org.eclipse.virgo.util.osgi.manifest.parse.ParserLogger;
import org.eclipse.virgo.util.parser.manifest.ManifestContents;

public class ManifestTemplateDirectiveMigrator
implements ManifestTemplateModifier,
PartialManifestModifier {
    private final List<HeaderDeclaration> importPackage = new ArrayList<HeaderDeclaration>();
    private final List<HeaderDeclaration> exportPackage = new ArrayList<HeaderDeclaration>();
    private final Object monitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(ManifestContents manifestTemplate) {
        Object object = this.monitor;
        synchronized (object) {
            String importPackageString = (String)manifestTemplate.getMainAttributes().get("Import-Package");
            this.importPackage.addAll(this.parseTemplate(importPackageString));
            if (importPackageString != null) {
                String importTemplateString = (String)manifestTemplate.getMainAttributes().get("Import-Template");
                if (importTemplateString == null) {
                    manifestTemplate.getMainAttributes().put("Import-Template", importPackageString);
                } else {
                    manifestTemplate.getMainAttributes().put("Import-Template", String.format("%s,%s", importTemplateString, importPackageString));
                }
            }
            String exportPackageString = (String)manifestTemplate.getMainAttributes().get("Export-Package");
            this.exportPackage.addAll(this.parseTemplate(exportPackageString));
            if (exportPackageString != null) {
                String exportTemplateString = (String)manifestTemplate.getMainAttributes().get("Export-Template");
                if (exportTemplateString == null) {
                    manifestTemplate.getMainAttributes().put("Export-Template", exportPackageString);
                } else {
                    manifestTemplate.getMainAttributes().put("Export-Template", String.format("%s,%s", exportTemplateString, exportPackageString));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(ReadablePartialManifest partialManifest) {
        Object object = this.monitor;
        synchronized (object) {
            for (HeaderDeclaration header : this.importPackage) {
                partialManifest.recordReferencedPackage((String)header.getNames().get(0));
            }
            for (HeaderDeclaration header : this.exportPackage) {
                partialManifest.recordExportPackage((String)header.getNames().get(0));
            }
        }
    }

    private List<HeaderDeclaration> parseTemplate(String template) {
        if (StringUtils.hasText(template)) {
            HeaderParser parser = HeaderParserFactory.newHeaderParser((ParserLogger)new SimpleParserLogger());
            return parser.parseHeader(template);
        }
        return new ArrayList<HeaderDeclaration>(0);
    }
}

