/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.core.tests.model.impl;

import java.util.LinkedList;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IDomainInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ISessionInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.SessionInfo;
import org.eclipse.tracecompass.lttng2.control.core.tests.model.impl.ModelImplFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SessionInfoTest {
    private ISessionInfo fSessionInfo1 = null;
    private ISessionInfo fSessionInfo2 = null;
    private IDomainInfo fDomainInfo1 = null;
    private IDomainInfo fDomainInfo2 = null;

    @Before
    public void setUp() {
        ModelImplFactory factory = new ModelImplFactory();
        this.fSessionInfo1 = factory.getSessionInfo1();
        this.fDomainInfo1 = factory.getDomainInfo1();
        this.fSessionInfo2 = factory.getSessionInfo2();
        this.fDomainInfo2 = factory.getDomainInfo2();
    }

    @Test
    public void testSessionInfo() {
        SessionInfo result = new SessionInfo("test");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"test", (Object)result.getName());
        Assert.assertEquals((Object)"", (Object)result.getSessionPath());
        TraceSessionState state = result.getSessionState();
        Assert.assertEquals((Object)"inactive", (Object)state.getInName());
        Assert.assertEquals((Object)"INACTIVE", (Object)state.name());
        Assert.assertEquals((Object)"INACTIVE", (Object)state.toString());
        Assert.assertEquals((long)0L, (long)state.ordinal());
        Assert.assertEquals((long)0L, (long)result.getDomains().length);
        Assert.assertFalse((boolean)result.isSnapshotSession());
        Assert.assertNull((Object)result.getNetworkUrl());
        Assert.assertNull((Object)result.getControlUrl());
        Assert.assertNull((Object)result.getDataUrl());
    }

    @Test
    public void testSessionInfoCopy() {
        SessionInfo sessionInfo = new SessionInfo((SessionInfo)this.fSessionInfo1);
        Assert.assertEquals((Object)sessionInfo.getName(), (Object)this.fSessionInfo1.getName());
        Assert.assertEquals((Object)sessionInfo.getSessionPath(), (Object)this.fSessionInfo1.getSessionPath());
        Assert.assertEquals((Object)sessionInfo.getSessionState(), (Object)this.fSessionInfo1.getSessionState());
        IDomainInfo[] orignalDomains = this.fSessionInfo1.getDomains();
        IDomainInfo[] resultDomains = sessionInfo.getDomains();
        int i = 0;
        while (i < orignalDomains.length) {
            Assert.assertEquals((Object)orignalDomains[i], (Object)resultDomains[i]);
            ++i;
        }
        Assert.assertEquals((Object)sessionInfo.getNetworkUrl(), (Object)this.fSessionInfo1.getNetworkUrl());
        Assert.assertEquals((Object)sessionInfo.getControlUrl(), (Object)this.fSessionInfo1.getControlUrl());
        Assert.assertEquals((Object)sessionInfo.getDataUrl(), (Object)this.fSessionInfo1.getDataUrl());
    }

    @Test
    public void testSessionCopy2() {
        try {
            SessionInfo session = null;
            new SessionInfo(session);
            Assert.fail((String)"null copy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAndSetters() {
        Assert.assertEquals((long)1L, (long)this.fSessionInfo1.getDomains().length);
        Assert.assertNotNull((Object)this.fSessionInfo1.getDomains()[0]);
        Assert.assertEquals((Object)this.fDomainInfo1, (Object)this.fSessionInfo1.getDomains()[0]);
        SessionInfo session = new SessionInfo("session");
        LinkedList<IDomainInfo> list = new LinkedList<IDomainInfo>();
        list.add(this.fDomainInfo1);
        list.add(this.fDomainInfo2);
        session.setDomains(list);
        IDomainInfo[] result = session.getDomains();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((Object)this.fDomainInfo1, (Object)result[0]);
        Assert.assertEquals((Object)this.fDomainInfo2, (Object)result[1]);
        session.setSessionPath("/home/user");
        Assert.assertEquals((Object)"/home/user", (Object)session.getSessionPath());
        session.setSessionState("active");
        TraceSessionState state = session.getSessionState();
        state = session.getSessionState();
        Assert.assertEquals((Object)"active", (Object)state.getInName());
        Assert.assertEquals((Object)"ACTIVE", (Object)state.name());
        Assert.assertEquals((Object)"ACTIVE", (Object)state.toString());
        Assert.assertEquals((long)1L, (long)state.ordinal());
        session.setSessionState("inactive");
        state = session.getSessionState();
        Assert.assertEquals((Object)"inactive", (Object)state.getInName());
        Assert.assertEquals((Object)"INACTIVE", (Object)state.name());
        Assert.assertEquals((Object)"INACTIVE", (Object)state.toString());
        Assert.assertEquals((long)0L, (long)state.ordinal());
        session.setSessionState("test");
        state = session.getSessionState();
        Assert.assertEquals((Object)"inactive", (Object)state.getInName());
        Assert.assertEquals((Object)"INACTIVE", (Object)state.name());
        Assert.assertEquals((Object)"INACTIVE", (Object)state.toString());
        Assert.assertEquals((long)0L, (long)state.ordinal());
        session.setSessionState(TraceSessionState.ACTIVE);
        state = session.getSessionState();
        Assert.assertEquals((Object)"active", (Object)state.getInName());
        Assert.assertEquals((Object)"ACTIVE", (Object)state.name());
        Assert.assertEquals((Object)"ACTIVE", (Object)state.toString());
        Assert.assertEquals((long)1L, (long)state.ordinal());
        session.setSessionState(TraceSessionState.INACTIVE);
        state = session.getSessionState();
        Assert.assertEquals((Object)"inactive", (Object)state.getInName());
        Assert.assertEquals((Object)"INACTIVE", (Object)state.name());
        Assert.assertEquals((Object)"INACTIVE", (Object)state.toString());
        Assert.assertEquals((long)0L, (long)state.ordinal());
    }

    @Test
    public void testToString_1() {
        SessionInfo fixture = new SessionInfo("sessionName");
        String result = fixture.toString();
        Assert.assertEquals((Object)"[SessionInfo([TraceInfo(Name=sessionName)],Path=,State=INACTIVE,isStreamedTrace=false,isSnapshot=false,Domains=,NetworkUrl=null,ControlUrl=null,DataUrl=null)]", (Object)result);
    }

    @Test
    public void testToString_2() {
        String result = this.fSessionInfo1.toString();
        Assert.assertEquals((Object)"[SessionInfo([TraceInfo(Name=session1)],Path=/home/user/lttng-trace/mysession/,State=ACTIVE,isStreamedTrace=false,isSnapshot=false,snapshotInfo=[SnapshotInfo([TraceInfo(Name=snapshot-1)],snapshotPath=/home/user/lttng-trace/mysession/,ID=1,isStreamedSnapshot=false)],Domains=[DomainInfo([TraceInfo(Name=test1)],Channels=[ChannelInfo([TraceInfo(Name=channel1)],State=DISABLED,OverwriteMode=true,SubBuffersSize=13,NumberOfSubBuffers=12,SwitchTimer=10,ReadTimer=11,output=splice(),NumberOfDiscardedEvents=14,NumberOfLostPackets=15,Events=[EventInfo([BaseEventInfo([TraceInfo(Name=event1)],type=TRACEPOINT,level=TRACE_DEBUG)],State=ENABLED,levelType=LOGLEVEL_ONLY)])],Loggers=None,isKernel=false)],NetworkUrl=null,ControlUrl=null,DataUrl=null)]", (Object)result);
    }

    @Test
    public void testToString_3() {
        SessionInfo info = new SessionInfo((SessionInfo)this.fSessionInfo1);
        info.setSnapshot(false);
        info.setSnapshotInfo(null);
        info.setSessionPath("/home/user/lttng-trace/mysession/");
        String result = info.toString();
        Assert.assertEquals((Object)"[SessionInfo([TraceInfo(Name=session1)],Path=/home/user/lttng-trace/mysession/,State=ACTIVE,isStreamedTrace=false,isSnapshot=false,Domains=[DomainInfo([TraceInfo(Name=test1)],Channels=[ChannelInfo([TraceInfo(Name=channel1)],State=DISABLED,OverwriteMode=true,SubBuffersSize=13,NumberOfSubBuffers=12,SwitchTimer=10,ReadTimer=11,output=splice(),NumberOfDiscardedEvents=14,NumberOfLostPackets=15,Events=[EventInfo([BaseEventInfo([TraceInfo(Name=event1)],type=TRACEPOINT,level=TRACE_DEBUG)],State=ENABLED,levelType=LOGLEVEL_ONLY)])],Loggers=None,isKernel=false)],NetworkUrl=null,ControlUrl=null,DataUrl=null)]", (Object)result);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fSessionInfo1.equals(this.fSessionInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fSessionInfo2.equals(this.fSessionInfo2));
        Assert.assertTrue((String)"equals", (!this.fSessionInfo1.equals(this.fSessionInfo2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fSessionInfo2.equals(this.fSessionInfo1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        SessionInfo event1 = new SessionInfo((SessionInfo)this.fSessionInfo1);
        SessionInfo event2 = new SessionInfo((SessionInfo)this.fSessionInfo2);
        Assert.assertTrue((String)"equals", (boolean)event1.equals((Object)this.fSessionInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fSessionInfo1.equals(event1));
        Assert.assertTrue((String)"equals", (boolean)event2.equals((Object)this.fSessionInfo2));
        Assert.assertTrue((String)"equals", (boolean)this.fSessionInfo2.equals(event2));
    }

    @Test
    public void testEqualsTransivity() {
        SessionInfo channel1 = new SessionInfo((SessionInfo)this.fSessionInfo1);
        SessionInfo channel2 = new SessionInfo((SessionInfo)this.fSessionInfo1);
        SessionInfo channel3 = new SessionInfo((SessionInfo)this.fSessionInfo1);
        Assert.assertTrue((String)"equals", (boolean)channel1.equals((Object)channel2));
        Assert.assertTrue((String)"equals", (boolean)channel2.equals((Object)channel3));
        Assert.assertTrue((String)"equals", (boolean)channel1.equals((Object)channel3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.fSessionInfo1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fSessionInfo2.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode() {
        SessionInfo channel1 = new SessionInfo((SessionInfo)this.fSessionInfo1);
        SessionInfo channel2 = new SessionInfo((SessionInfo)this.fSessionInfo2);
        Assert.assertTrue((String)"hashCode", (this.fSessionInfo1.hashCode() == channel1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fSessionInfo2.hashCode() == channel2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fSessionInfo1.hashCode() != channel2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fSessionInfo2.hashCode() != channel1.hashCode() ? 1 : 0) != 0);
    }
}

