/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.perf.synchronization;

import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.TmfTimestampTransformLinear;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.TmfTimestampTransformLinearFast;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.tracecompass.tmf.core.synchronization.TimestampTransformFactory;
import org.junit.Ignore;
import org.junit.Test;

public class TimestampTransformBenchmark {
    private static final String TEST_ID = "org.eclipse.linuxtools#Trace synchronization#";
    private static final String TEST_SUMMARY = "Timestamp Transform: ";
    private static final long NB_TRANSFORMATIONS = 50000000L;

    @Test
    public void testTimestampTransformPerformance() {
        ITmfTimestampTransform transform = TimestampTransformFactory.getDefaultTransform();
        TimestampTransformBenchmark.doTimestampTransformRun("Identity transform", transform, 10L);
        transform = TimestampTransformFactory.createWithOffset((long)123456789L);
        TimestampTransformBenchmark.doTimestampTransformRun("Transform with offset", transform, 10L);
        transform = TimestampTransformFactory.createLinear((double)Math.PI, (long)1234L);
        TimestampTransformBenchmark.doTimestampTransformRun("Linear transform", transform, 5L);
        transform = TimestampTransformFactory.createLinear((double)10000.123454556564, (long)-4312278758437L);
        TimestampTransformBenchmark.doTimestampTransformRun("Linear transform with larger slope and negative offset", transform, 5L);
    }

    @Ignore
    @Test
    public void testCompareTimestampTransformPerformance() {
        TmfTimestampTransformLinear classic = new TmfTimestampTransformLinear(Math.PI, 1234.0);
        TmfTimestampTransformLinearFast fast = new TmfTimestampTransformLinearFast(Math.PI, 1234.0);
        TimestampTransformBenchmark.doTimestampTransformRun("Linear transform classic", (ITmfTimestampTransform)classic, 5L);
        TimestampTransformBenchmark.doTimestampTransformRun("Linear transform fast", (ITmfTimestampTransform)fast, 5L);
    }

    private static void doTimestampTransformRun(String testName, ITmfTimestampTransform xform, long loopCount) {
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter(TEST_ID + testName);
        perf.tagAsSummary(pm, TEST_SUMMARY + testName, Dimension.CPU_TIME);
        int x = 0;
        while ((long)x < loopCount) {
            long time = (long)Math.pow(10.0, 18.0);
            pm.start();
            long i = 0L;
            while (i < 50000000L) {
                xform.transform(time);
                time += 200L;
                ++i;
            }
            pm.stop();
            ++x;
        }
        pm.commit();
    }
}

