/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.ITryStatement;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.Block;
import org.eclipse.wst.jsdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.wst.jsdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FinallyFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.NullInfoRegistry;
import org.eclipse.wst.jsdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class TryStatement
extends SubRoutineStatement
implements ITryStatement {
    public Block tryBlock;
    public Block[] catchBlocks;
    public Argument[] catchArguments;
    public Block finallyBlock;
    BlockScope scope;
    public UnconditionalFlowInfo subRoutineInits;
    ReferenceBinding[] caughtExceptionTypes;
    boolean[] catchExits;
    boolean isSubRoutineStartLabel;
    public LocalVariableBinding anyExceptionVariable;
    public LocalVariableBinding returnAddressVariable;
    public LocalVariableBinding secretReturnValue;
    int mergedInitStateIndex = -1;
    int preTryInitStateIndex = -1;
    int naturalExitMergeInitStateIndex = -1;
    int[] catchExitInitStateIndexes;

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo tryInfo;
        if (this.anyExceptionVariable != null) {
            this.anyExceptionVariable.useFlag = 1;
        }
        if (this.returnAddressVariable != null) {
            this.returnAddressVariable.useFlag = 1;
        }
        if (!this.isSubRoutineStartLabel) {
            FlowInfo tryInfo2;
            ExceptionHandlingFlowContext handlingContext = new ExceptionHandlingFlowContext(flowContext, this, this.caughtExceptionTypes, this.scope, flowInfo.unconditionalInits());
            handlingContext.initsOnFinally = new NullInfoRegistry(flowInfo.unconditionalInits());
            if (this.tryBlock.isEmptyBlock()) {
                tryInfo2 = flowInfo;
            } else {
                tryInfo2 = this.tryBlock.analyseCode(currentScope, handlingContext, flowInfo.copy());
                if ((tryInfo2.tagBits & 1) != 0) {
                    this.bits |= 0x20000000;
                }
            }
            if (this.catchArguments != null) {
                int catchCount = this.catchBlocks.length;
                this.catchExits = new boolean[catchCount];
                this.catchExitInitStateIndexes = new int[catchCount];
                int i = 0;
                while (i < catchCount) {
                    FlowInfo catchInfo = this.caughtExceptionTypes[i].isUncheckedException(true) ? handlingContext.initsOnFinally.mitigateNullInfoOf(flowInfo.unconditionalCopy().addPotentialInitializationsFrom(handlingContext.initsOnException(this.caughtExceptionTypes[i])).addPotentialInitializationsFrom(tryInfo2).addPotentialInitializationsFrom(handlingContext.initsOnReturn)) : flowInfo.unconditionalCopy().addPotentialInitializationsFrom(handlingContext.initsOnException(this.caughtExceptionTypes[i])).addPotentialInitializationsFrom(tryInfo2.nullInfoLessUnconditionalCopy()).addPotentialInitializationsFrom(handlingContext.initsOnReturn.nullInfoLessUnconditionalCopy());
                    LocalVariableBinding catchArg = this.catchArguments[i].binding;
                    catchInfo.markAsDefinitelyAssigned(catchArg);
                    catchInfo.markAsDefinitelyNonNull(catchArg);
                    if (this.tryBlock.statements == null) {
                        catchInfo.setReachMode(1);
                    }
                    catchInfo = this.catchBlocks[i].analyseCode(currentScope, flowContext, catchInfo);
                    this.catchExits[i] = (catchInfo.tagBits & 1) != 0;
                    tryInfo2 = tryInfo2.mergedWith(catchInfo.unconditionalInits());
                    ++i;
                }
            }
            if (flowContext.initsOnFinally != null) {
                flowContext.initsOnFinally.add(handlingContext.initsOnFinally);
            }
            return tryInfo2;
        }
        InsideSubRoutineFlowContext insideSubContext = new InsideSubRoutineFlowContext(flowContext, this);
        FinallyFlowContext finallyContext = new FinallyFlowContext(flowContext, this.finallyBlock);
        UnconditionalFlowInfo subInfo = this.finallyBlock.analyseCode(currentScope, finallyContext, flowInfo.nullInfoLessUnconditionalCopy()).unconditionalInits();
        if (subInfo == FlowInfo.DEAD_END) {
            this.bits |= 0x4000;
            this.scope.problemReporter().finallyMustCompleteNormally(this.finallyBlock);
        }
        this.subRoutineInits = subInfo;
        ExceptionHandlingFlowContext handlingContext = new ExceptionHandlingFlowContext(insideSubContext, this, this.caughtExceptionTypes, this.scope, flowInfo.unconditionalInits());
        handlingContext.initsOnFinally = new NullInfoRegistry(flowInfo.unconditionalInits());
        if (this.tryBlock.isEmptyBlock()) {
            tryInfo = flowInfo;
        } else {
            tryInfo = this.tryBlock.analyseCode(currentScope, handlingContext, flowInfo.copy());
            if ((tryInfo.tagBits & 1) != 0) {
                this.bits |= 0x20000000;
            }
        }
        if (this.catchArguments != null) {
            int catchCount = this.catchBlocks.length;
            this.catchExits = new boolean[catchCount];
            this.catchExitInitStateIndexes = new int[catchCount];
            int i = 0;
            while (i < catchCount) {
                FlowInfo catchInfo = this.caughtExceptionTypes[i].isUncheckedException(true) ? handlingContext.initsOnFinally.mitigateNullInfoOf(flowInfo.unconditionalCopy().addPotentialInitializationsFrom(handlingContext.initsOnException(this.caughtExceptionTypes[i])).addPotentialInitializationsFrom(tryInfo).addPotentialInitializationsFrom(handlingContext.initsOnReturn)) : flowInfo.unconditionalCopy().addPotentialInitializationsFrom(handlingContext.initsOnException(this.caughtExceptionTypes[i])).addPotentialInitializationsFrom(tryInfo.nullInfoLessUnconditionalCopy()).addPotentialInitializationsFrom(handlingContext.initsOnReturn.nullInfoLessUnconditionalCopy());
                LocalVariableBinding catchArg = this.catchArguments[i].binding;
                catchInfo.markAsDefinitelyAssigned(catchArg);
                catchInfo.markAsDefinitelyNonNull(catchArg);
                if (this.tryBlock.statements == null) {
                    catchInfo.setReachMode(1);
                }
                catchInfo = this.catchBlocks[i].analyseCode(currentScope, insideSubContext, catchInfo);
                this.catchExits[i] = (catchInfo.tagBits & 1) != 0;
                tryInfo = tryInfo.mergedWith(catchInfo.unconditionalInits());
                ++i;
            }
        }
        finallyContext.complainOnDeferredChecks(handlingContext.initsOnFinally.mitigateNullInfoOf((tryInfo.tagBits & 1) == 0 ? flowInfo.unconditionalCopy().addPotentialInitializationsFrom(tryInfo).addPotentialInitializationsFrom(insideSubContext.initsOnReturn) : insideSubContext.initsOnReturn), currentScope);
        if (flowContext.initsOnFinally != null) {
            flowContext.initsOnFinally.add(handlingContext.initsOnFinally);
        }
        if (subInfo == FlowInfo.DEAD_END) {
            return subInfo;
        }
        FlowInfo mergedInfo = tryInfo.addInitializationsFrom(subInfo);
        return mergedInfo;
    }

    @Override
    public boolean isSubRoutineEscaping() {
        return (this.bits & 0x4000) != 0;
    }

    @Override
    public StringBuffer printStatement(int indent, StringBuffer output) {
        TryStatement.printIndent(indent, output).append("try \n");
        this.tryBlock.printStatement(indent + 1, output);
        if (this.catchBlocks != null) {
            int i = 0;
            while (i < this.catchBlocks.length) {
                output.append('\n');
                TryStatement.printIndent(indent, output).append("catch (");
                this.catchArguments[i].print(0, output).append(") ");
                this.catchBlocks[i].printStatement(indent + 1, output);
                ++i;
            }
        }
        if (this.finallyBlock != null) {
            output.append('\n');
            TryStatement.printIndent(indent, output).append("finally\n");
            this.finallyBlock.printStatement(indent + 1, output);
        }
        return output;
    }

    @Override
    public void resolve(BlockScope upperScope) {
        this.scope = new BlockScope(upperScope);
        BlockScope tryScope = new BlockScope(this.scope);
        BlockScope finallyScope = null;
        if (this.finallyBlock != null) {
            if (this.finallyBlock.isEmptyBlock()) {
                if ((this.finallyBlock.bits & 8) != 0) {
                    this.scope.problemReporter().undocumentedEmptyBlock(this.finallyBlock.sourceStart, this.finallyBlock.sourceEnd);
                }
            } else {
                MethodBinding methodBinding;
                finallyScope = this.scope;
                MethodScope methodScope = this.scope.methodScope();
                this.isSubRoutineStartLabel = true;
                if (methodScope != null && !methodScope.isInsideInitializer() && (methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) != null) {
                    TypeBinding methodReturnType = methodBinding.returnType;
                    int cfr_ignored_0 = methodReturnType.id;
                }
                this.finallyBlock.resolveUsing(finallyScope);
            }
        }
        this.tryBlock.resolveUsing(tryScope);
        if (this.catchBlocks != null) {
            int length = this.catchArguments.length;
            TypeBinding[] argumentTypes = new TypeBinding[length];
            boolean catchHasError = false;
            int i = 0;
            while (i < length) {
                BlockScope catchScope = new BlockScope(this.scope);
                argumentTypes[i] = this.catchArguments[i].resolveForCatch(catchScope);
                if (argumentTypes[i] == null) {
                    catchHasError = true;
                }
                this.catchBlocks[i].resolveUsing(catchScope);
                ++i;
            }
            if (catchHasError) {
                return;
            }
            this.caughtExceptionTypes = new ReferenceBinding[length];
            i = 0;
            while (i < length) {
                this.caughtExceptionTypes[i] = (ReferenceBinding)argumentTypes[i];
                ++i;
            }
        } else {
            this.caughtExceptionTypes = new ReferenceBinding[0];
        }
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            if (this.scope == null) {
                this.scope = blockScope;
            }
            this.tryBlock.traverse(visitor, this.scope);
            if (this.catchArguments != null) {
                int i = 0;
                int max = this.catchBlocks.length;
                while (i < max) {
                    this.catchArguments[i].traverse(visitor, this.scope);
                    this.catchBlocks[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.finallyBlock != null) {
                this.finallyBlock.traverse(visitor, this.scope);
            }
        }
        visitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 106;
    }
}

