/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.otf2.core.trace;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.tracecompass.incubator.internal.otf2.core.trace.MetricClass;
import org.eclipse.tracecompass.incubator.internal.otf2.core.trace.MetricMember;
import org.eclipse.tracecompass.incubator.otf2.core.trace.Otf2CounterAspect;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class Otf2SystemMetrics {
    private Set<MetricClass> fMetricClasses = new HashSet<MetricClass>();
    private Map<Long, MetricMember> fMetricMembers = new HashMap<Long, MetricMember>();

    public void addMetricMember(ITmfEvent event, Map<Integer, String> stringIds) {
        MetricMember metricMember = new MetricMember(event, stringIds);
        this.fMetricMembers.put(metricMember.getId(), metricMember);
    }

    public void addMetricClass(ITmfEvent event) {
        MetricClass metricClass = new MetricClass(event);
        this.fMetricClasses.add(metricClass);
    }

    public Iterator<Otf2CounterAspect> getCounterAspects() {
        HashMap<MetricMember, Otf2CounterAspect> counterAspects = new HashMap<MetricMember, Otf2CounterAspect>();
        for (MetricClass metricClass : this.fMetricClasses) {
            long metricClassId = metricClass.getId();
            long index = 0L;
            for (Long metricMemberId : metricClass.getMetricMembers()) {
                MetricMember metricMember = this.fMetricMembers.get(metricMemberId);
                if (metricMember != null) {
                    Otf2CounterAspect counterAspect = (Otf2CounterAspect)((Object)counterAspects.get(metricMember));
                    if (counterAspect == null) {
                        counterAspect = new Otf2CounterAspect(metricMember);
                        counterAspects.put(metricMember, counterAspect);
                    }
                    counterAspect.addNewIds((Pair<Long, Long>)new Pair((Object)metricClassId, (Object)index));
                }
                ++index;
            }
        }
        return Objects.requireNonNull(counterAspects.values().iterator());
    }
}

