/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui;

import org.eclipse.ui.editors.text.DefaultEncodingSupport;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;

class EncodingSupport
extends DefaultEncodingSupport {
    private String[] fConfigurationPoints = null;
    private StatusTextEditor fStatusTextEditor;
    IEncodingSupport fSupportDelegate = null;

    EncodingSupport(String[] configurationPoints) {
        this.fConfigurationPoints = configurationPoints;
    }

    public void dispose() {
        super.dispose();
        if (this.fSupportDelegate instanceof DefaultEncodingSupport) {
            ((DefaultEncodingSupport)this.fSupportDelegate).dispose();
        }
        this.fSupportDelegate = null;
        this.fStatusTextEditor = null;
    }

    public String getDefaultEncoding() {
        IEncodingSupport delegate = this.getEncodingSupportDelegate();
        if (delegate != null) {
            return delegate.getDefaultEncoding();
        }
        return super.getDefaultEncoding();
    }

    public String getEncoding() {
        IEncodingSupport delegate = this.getEncodingSupportDelegate();
        if (delegate != null) {
            return delegate.getEncoding();
        }
        return super.getEncoding();
    }

    IEncodingSupport getEncodingSupportDelegate() {
        if (this.fSupportDelegate == null) {
            ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
            int i = 0;
            while (this.fSupportDelegate == null && i < this.fConfigurationPoints.length) {
                this.fSupportDelegate = (IEncodingSupport)builder.getConfiguration(IEncodingSupport.class.getName(), this.fConfigurationPoints[i]);
                ++i;
            }
        }
        return this.fSupportDelegate;
    }

    public void initialize(StatusTextEditor textEditor) {
        super.initialize(textEditor);
        this.fStatusTextEditor = textEditor;
        IEncodingSupport encodingSupportDelegate = this.getEncodingSupportDelegate();
        if (encodingSupportDelegate instanceof DefaultEncodingSupport) {
            ((DefaultEncodingSupport)encodingSupportDelegate).initialize(textEditor);
        }
    }

    void reinitialize(String[] configurationPoints) {
        if (this.fSupportDelegate instanceof DefaultEncodingSupport) {
            ((DefaultEncodingSupport)this.fSupportDelegate).dispose();
        }
        this.fSupportDelegate = null;
        this.fConfigurationPoints = configurationPoints;
        IEncodingSupport encodingSupportDelegate = this.getEncodingSupportDelegate();
        if (encodingSupportDelegate instanceof DefaultEncodingSupport) {
            ((DefaultEncodingSupport)encodingSupportDelegate).initialize(this.fStatusTextEditor);
        }
    }

    protected void setEncoding(String encoding, boolean overwrite) {
        super.setEncoding(encoding, overwrite);
        IEncodingSupport delegate = this.getEncodingSupportDelegate();
        if (delegate != null && overwrite) {
            delegate.setEncoding(encoding);
        }
    }
}

