/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.inandout.core.analysis;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class SegmentSpecifier {
    private static final String ALL = "all";
    private static final ITmfEventAspect<@NonNull Object> CONTENT_ASPECT = TmfBaseAspects.getContentsAspect();
    @Expose
    @SerializedName(value="label")
    private String fLabel;
    @Expose
    @SerializedName(value="inRegex")
    private String fInRegex;
    @Expose
    @SerializedName(value="outRegex")
    private String fOutRegex;
    @Expose
    @SerializedName(value="contextInRegex")
    private String fContextInRegex;
    @Expose
    @SerializedName(value="contextOutRegex")
    private String fContextOutRegex;
    @Expose
    @SerializedName(value="classifier")
    private String fClassifier;
    private transient @Nullable Pattern fInRegexPattern;
    private transient @Nullable Pattern fOutRegexPattern;
    private transient @Nullable Pattern fContextInPattern;
    private transient @Nullable Pattern fContextOutPattern;

    public SegmentSpecifier() {
        this.fLabel = "";
        this.fInRegex = "";
        this.fOutRegex = "";
        this.fContextInRegex = "";
        this.fContextOutRegex = "";
        this.fClassifier = "";
    }

    public SegmentSpecifier(SegmentSpecifier other) {
        this.fLabel = other.fLabel;
        this.fInRegex = other.fInRegex;
        this.fOutRegex = other.fOutRegex;
        this.fContextInRegex = other.fContextInRegex;
        this.fContextOutRegex = other.fContextOutRegex;
        this.fClassifier = other.fClassifier;
    }

    public SegmentSpecifier(String label, String inRegex, String outRegex, String contextInRegex, String contextOutRegex, String classifier) {
        this.fLabel = label;
        this.fInRegex = inRegex;
        this.fOutRegex = outRegex;
        this.fContextInRegex = contextInRegex;
        this.fContextOutRegex = contextOutRegex;
        this.fClassifier = classifier;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public String getInRegex() {
        return this.fInRegex;
    }

    public String getOutRegex() {
        return this.fOutRegex;
    }

    public String getContextInRegex() {
        return this.fContextInRegex;
    }

    public String getContextOutRegex() {
        return this.fContextOutRegex;
    }

    public String getClassifierType() {
        return this.fClassifier;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SegmentSpecifier other = (SegmentSpecifier)obj;
        return Objects.equals(this.fLabel, other.fLabel) && Objects.equals(this.fInRegex, other.fInRegex) && Objects.equals(this.fOutRegex, other.fOutRegex) && Objects.equals(this.fContextInRegex, other.fContextInRegex) && Objects.equals(this.fContextOutRegex, other.fContextOutRegex) && Objects.equals(this.fClassifier, other.fClassifier);
    }

    public int hashCode() {
        return Objects.hash(this.fLabel, this.fInRegex, this.fOutRegex, this.fContextInRegex, this.fContextOutRegex, this.fClassifier);
    }

    public String toString() {
        if (this.fContextInRegex.trim().isEmpty()) {
            return String.format("%s: [InRegex=%s, OutRegex=%s, Classifier=%s]", this.fLabel, this.fInRegex, this.fOutRegex, this.fClassifier);
        }
        return String.format("%s: [InRegex=%s, OutRegex=%s, ContextInRegex=%s, ContextOutRegex=%s, Classifier=%s]", this.fLabel, this.fInRegex, this.fOutRegex, this.fContextInRegex, this.fContextOutRegex, this.fClassifier);
    }

    public @Nullable SegmentContext getSegmentContext(@NonNull ITmfEvent event) {
        if (this.getInPattern().matcher(event.getName()).matches()) {
            Object value;
            SegmentContext segmentContext = new SegmentContext();
            segmentContext.setLabel(this.getLabel(event, null));
            Object resolve = CONTENT_ASPECT.resolve(event);
            if (resolve != null && !this.getContextInRegex().trim().isEmpty()) {
                segmentContext.setContext(SegmentSpecifier.findInFields(event, this.getContextInPattern()));
            }
            if ((value = this.getClassifier(event)) != null) {
                segmentContext.setClassifier(value);
            }
            return segmentContext;
        }
        return null;
    }

    public Object getClassifier(ITmfEvent event) {
        Object value = null;
        String classifier = this.fClassifier;
        if (classifier != null && !classifier.trim().isEmpty()) {
            value = TmfTraceUtils.resolveAspectOfNameForEvent((ITmfTrace)event.getTrace(), (String)classifier, (ITmfEvent)event);
        }
        return value;
    }

    private static String removeAll(String value) {
        return value == null || ALL.equalsIgnoreCase(value) ? "" : value;
    }

    private Pattern getContextInPattern() {
        Pattern p = this.fContextInPattern;
        if (p == null) {
            String input = SegmentSpecifier.removeAll(this.fContextInRegex);
            this.fContextInPattern = p = Pattern.compile(input);
        }
        return p;
    }

    private Pattern getContextOutPattern() {
        Pattern p = this.fContextOutPattern;
        if (p == null) {
            String input = SegmentSpecifier.removeAll(this.fContextOutRegex);
            this.fContextOutPattern = p = Pattern.compile(input);
        }
        return p;
    }

    private Pattern getInPattern() {
        Pattern p = this.fInRegexPattern;
        if (p == null) {
            String input = SegmentSpecifier.removeAll(this.fInRegex);
            this.fInRegexPattern = p = Pattern.compile(input);
        }
        return p;
    }

    public boolean matchesOutName(ITmfEvent event) {
        return this.getOutPattern().matcher(event.getName()).matches();
    }

    private Pattern getOutPattern() {
        Pattern p = this.fOutRegexPattern;
        if (p == null) {
            String input = SegmentSpecifier.removeAll(this.fOutRegex);
            this.fOutRegexPattern = p = Pattern.compile(input);
        }
        return p;
    }

    private String getLabel(@NonNull ITmfEvent event, @Nullable SegmentContext sc) {
        String ret;
        if (sc != null) {
            return sc.fLabel;
        }
        if (this.fLabel.equals("{0}") && (ret = SegmentSpecifier.findInName(event, this.getInPattern())) != null) {
            return ret;
        }
        if (this.fLabel.equals("{1}") && (ret = SegmentSpecifier.findInName(event, this.getOutPattern())) != null) {
            return ret;
        }
        if (this.fLabel.equals("{2}") && (ret = SegmentSpecifier.findInFields(event, this.getContextInPattern())) != null) {
            return ret;
        }
        if (this.fLabel.equals("{3}") && (ret = SegmentSpecifier.findInFields(event, this.getContextOutPattern())) != null) {
            return ret;
        }
        return this.fLabel;
    }

    private static String findInName(@NonNull ITmfEvent event, Pattern p) {
        String resolve = event.getName();
        Matcher matcher = p.matcher(resolve);
        return SegmentSpecifier.findIn(matcher);
    }

    private static String findInFields(@NonNull ITmfEvent event, Pattern p) {
        Object resolve = CONTENT_ASPECT.resolve(event);
        String matched = null;
        if (resolve != null) {
            Matcher matcher = p.matcher(resolve.toString());
            matched = SegmentSpecifier.findIn(matcher);
        }
        return matched;
    }

    private static String findIn(Matcher matcher) {
        if (matcher.find()) {
            if (matcher.groupCount() >= 1) {
                return matcher.group(1);
            }
            return matcher.group(0);
        }
        return null;
    }

    public boolean setIfNotNull(@Nullable String label, @Nullable String inRegex, @Nullable String outRegex, @Nullable String contextInRegex, @Nullable String contextOutRegex, @Nullable String category) {
        boolean[] updated = new boolean[1];
        SegmentSpecifier.setIfNotNull(label, value -> {
            this.fLabel = value;
            blArray[0] = true;
        });
        SegmentSpecifier.setIfNotNull(inRegex, value -> {
            this.fInRegex = value;
            blArray[0] = true;
        });
        SegmentSpecifier.setIfNotNull(outRegex, value -> {
            this.fOutRegex = value;
            blArray[0] = true;
        });
        SegmentSpecifier.setIfNotNull(contextInRegex, value -> {
            this.fContextInRegex = value;
            blArray[0] = true;
        });
        SegmentSpecifier.setIfNotNull(contextOutRegex, value -> {
            this.fContextOutRegex = value;
            blArray[0] = true;
        });
        SegmentSpecifier.setIfNotNull(category, value -> {
            this.fClassifier = category;
            blArray[0] = true;
        });
        return updated[0];
    }

    private static void setIfNotNull(@Nullable String newString, Consumer<String> consumer) {
        if (newString != null) {
            consumer.accept(newString);
        }
    }

    public String getOutContext(@NonNull ITmfEvent event) {
        if (this.getOutRegex() == null || this.getContextOutRegex().trim().isEmpty()) {
            return null;
        }
        return SegmentSpecifier.findInFields(event, this.getContextOutPattern());
    }

    public static class SegmentContext {
        private String fLabel;
        private String fContext;
        private @Nullable Object fClassifier;

        public String getLabel() {
            return this.fLabel;
        }

        public void setLabel(String label) {
            this.fLabel = label;
        }

        public String getContext() {
            return this.fContext;
        }

        public void setContext(String context) {
            this.fContext = context;
        }

        public Object getClassifier() {
            return this.fClassifier;
        }

        public void setClassifier(Object classifier) {
            this.fClassifier = classifier;
        }
    }
}

