/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.executioncomparison.core;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackElement;
import org.eclipse.tracecompass.analysis.profiling.core.base.ICallStackSymbol;
import org.eclipse.tracecompass.analysis.profiling.core.base.IDataPalette;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.AggregatedCallSite;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICallGraphProvider2;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTree;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTree;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTreeSet;
import org.eclipse.tracecompass.incubator.internal.executioncomparison.core.DifferentialFlamePalette;

public class DifferentialCallGraphProvider
extends DifferentialWeightedTreeProvider<ICallStackSymbol> {
    private final ICallGraphProvider2 fOriginalTree;

    public DifferentialCallGraphProvider(IWeightedTreeProvider<ICallStackSymbol, ICallStackElement, AggregatedCallSite> instrumentedCallStackAnalysis, Collection<DifferentialWeightedTree<ICallStackSymbol>> trees) {
        this(instrumentedCallStackAnalysis, (DifferentialWeightedTreeSet<ICallStackSymbol>)DifferentialWeightedTreeSet.create(trees));
    }

    public DifferentialCallGraphProvider(IWeightedTreeProvider<ICallStackSymbol, ICallStackElement, ? extends WeightedTree<ICallStackSymbol>> originalTree, DifferentialWeightedTreeSet<ICallStackSymbol> treeSet) {
        super(originalTree, treeSet);
        this.fOriginalTree = (ICallGraphProvider2)originalTree;
    }

    public IDataPalette getPalette() {
        return DifferentialFlamePalette.getInstance();
    }

    public String toDisplayString(DifferentialWeightedTree<ICallStackSymbol> tree) {
        double difference = tree.getDifference();
        WeightedTree originalTree = tree.getOriginalTree();
        String label = "";
        label = originalTree instanceof AggregatedCallSite ? this.fOriginalTree.toDisplayString((WeightedTree)((AggregatedCallSite)originalTree)) : String.valueOf(((ICallStackSymbol)originalTree.getObject()).resolve(new ArrayList()));
        if (Double.isFinite(difference)) {
            return String.format("(%#+.02f %% ) %s", difference * 100.0, label);
        }
        return label;
    }
}

