/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport.NetworkConnection;
import org.eclipse.tracecompass.tmf.core.event.matching.TcpEventKey;

public class RosMessagesTransportEventKey
extends TcpEventKey {
    private static final HashFunction HF = Objects.requireNonNull(Hashing.goodFastHash((int)32));
    private final NetworkConnection fConnectionInfo;
    private final long fFlags;

    public RosMessagesTransportEventKey(long sequence, long ack, long flags, NetworkConnection connectionInfo) {
        super(sequence, ack, flags);
        this.fConnectionInfo = connectionInfo;
        this.fFlags = flags;
    }

    public long getFlags() {
        return this.fFlags;
    }

    public NetworkConnection getNetworkConnectionInfo() {
        return this.fConnectionInfo;
    }

    public int hashCode() {
        return HF.newHasher().putInt(super.hashCode()).putInt(this.fConnectionInfo.hashCode()).hash().asInt();
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof RosMessagesTransportEventKey) {
            RosMessagesTransportEventKey key = (RosMessagesTransportEventKey)((Object)o);
            return super.equals(o) && key.fConnectionInfo.equals(this.fConnectionInfo);
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RosMessagesTransportEventKey:\n");
        b.append("\t\tflags: " + this.fFlags);
        b.append("\n");
        return b.toString();
    }
}

