/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.mtl.impl;

import java.util.Map;
import org.eclipse.trace4cps.analysis.mtl.impl.IExp;

public class OpIExp
implements IExp {
    private final IExp.Iop op;
    private final IExp left;
    private final IExp right;

    public OpIExp(IExp left, IExp.Iop op, IExp right) {
        this.left = left;
        this.op = op;
        this.right = right;
    }

    @Override
    public double evaluate(Map<String, Long> valuation) {
        double v1 = this.left.evaluate(valuation);
        double v2 = this.right.evaluate(valuation);
        switch (this.op) {
            case PLUS: {
                return v1 + v2;
            }
            case MINUS: {
                return v1 - v2;
            }
            case MULT: {
                return v1 * v2;
            }
            case DIV: {
                return v1 / v2;
            }
            case MOD: {
                return v1 % v2;
            }
        }
        throw new IllegalStateException("Unknown operator: " + (Object)((Object)this.op));
    }

    @Override
    public long evaluateLong(Map<String, Long> valuation) {
        long v1 = this.left.evaluateLong(valuation);
        long v2 = this.right.evaluateLong(valuation);
        switch (this.op) {
            case PLUS: {
                return v1 + v2;
            }
            case MINUS: {
                return v1 - v2;
            }
            case MULT: {
                return v1 * v2;
            }
            case DIV: {
                return v1 / v2;
            }
            case MOD: {
                return v1 % v2;
            }
        }
        throw new IllegalStateException("Unknown operator: " + (Object)((Object)this.op));
    }

    @Override
    public boolean hasVariable() {
        return this.left.hasVariable() || this.right.hasVariable();
    }

    @Override
    public boolean isNaturalNumber() {
        return this.left.isNaturalNumber() && this.right.isNaturalNumber();
    }

    public String toString() {
        return "(" + this.left.toString() + this.op.toString() + this.right.toString() + ")";
    }
}

