/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.preferences;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.text.templates.TemplatePersistenceData;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.registry.ITMScope;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.utils.CodeTemplateContextTypeUtils;
import org.eclipse.tm4e.ui.text.ITMPresentationReconcilerListener;
import org.eclipse.tm4e.ui.text.TMPresentationReconciler;
import org.eclipse.ui.texteditor.templates.TemplatePreferencePage;

public class CustomCodeTemplatePreferencePage
extends TemplatePreferencePage {
    private @Nullable TMPresentationReconciler previewReconsiler;

    public CustomCodeTemplatePreferencePage() {
        TMUIPlugin plugin = TMUIPlugin.getDefault();
        if (plugin == null) {
            return;
        }
        this.setPreferenceStore(plugin.getPreferenceStore());
        this.setTemplateStore(plugin.getTemplateStore());
        this.setContextTypeRegistry(TMUIPlugin.from(plugin.getTemplateContextRegistry()));
    }

    protected boolean isShowFormatterSetting() {
        return false;
    }

    protected @Nullable Template editTemplate(@Nullable Template template, boolean edit, boolean isNameModifiable) {
        if (template == null) {
            return null;
        }
        TMEditTemplateDialog dialog = new TMEditTemplateDialog(this.getShell(), template, edit, isNameModifiable, this.getContextTypeRegistry());
        if (dialog.open() == 0) {
            return dialog.getTemplate();
        }
        return null;
    }

    protected SourceViewer createViewer(@Nullable Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, null, false, 2816);
        SourceViewerConfiguration configuration = new SourceViewerConfiguration(){

            public IPresentationReconciler getPresentationReconciler(@Nullable ISourceViewer sourceViewer) {
                CustomCodeTemplatePreferencePage.this.previewReconsiler = new TMCodeTemplatePresentationReconsiler();
                return CustomCodeTemplatePreferencePage.this.previewReconsiler;
            }
        };
        viewer.configure(configuration);
        Document document = new Document();
        viewer.setDocument((IDocument)document);
        this.getTableViewer().addSelectionChangedListener(e -> this.selectedCodeTemplateChanged());
        return viewer;
    }

    private void selectedCodeTemplateChanged() {
        IGrammar languageGrammar;
        String id;
        ITMScope scope;
        Template selectedTemplate = this.getSelectedTemplate();
        if (selectedTemplate != null && (scope = CodeTemplateContextTypeUtils.findScopeFor(id = selectedTemplate.getContextTypeId())) != null && (languageGrammar = TMEclipseRegistryPlugin.getGrammarRegistryManager().getGrammarForScope(scope)) != null && this.previewReconsiler != null) {
            this.previewReconsiler.setGrammar(languageGrammar);
            return;
        }
        if (this.previewReconsiler != null) {
            this.previewReconsiler.setGrammar(null);
        }
    }

    private @Nullable Template getSelectedTemplate() {
        TemplatePersistenceData data;
        IStructuredSelection selection = this.getTableViewer().getStructuredSelection();
        if (selection != null && selection.size() == 1 && (data = (TemplatePersistenceData)selection.getFirstElement()) != null) {
            return data.getTemplate();
        }
        return null;
    }

    private static class TMCodeTemplatePresentationReconsiler
    extends TMPresentationReconciler {
        private final TMTemplateVariableHighlighter templateVariableDamagerRepairer = new TMTemplateVariableHighlighter();
        private @Nullable ITextViewer viewer;

        private TMCodeTemplatePresentationReconsiler() {
        }

        @Override
        public void install(ITextViewer viewer) {
            super.install(viewer);
            this.viewer = viewer;
        }

        @Override
        public void setGrammar(@Nullable IGrammar newGrammar) {
            IDocument document;
            super.setGrammar(newGrammar);
            this.addListener(new ITMPresentationReconcilerListener(){

                @Override
                public void onUninstalled() {
                }

                @Override
                public void onInstalled(ITextViewer viewer, IDocument document) {
                }

                @Override
                public void onColorized(TextPresentation presentation, @Nullable Throwable error) {
                    ITextViewer viewer = viewer;
                    if (viewer != null && viewer.getDocument() != null) {
                        IDocument document = viewer.getDocument();
                        templateVariableDamagerRepairer.setDocument(document);
                        IRegion region = presentation.getExtent();
                        templateVariableDamagerRepairer.createPresentation(presentation, region);
                        viewer.changeTextPresentation(presentation, false);
                    }
                }
            });
            ITextViewer viewer = this.viewer;
            IDocument iDocument = document = viewer != null ? viewer.getDocument() : null;
            if (newGrammar == null && viewer != null && document != null) {
                this.templateVariableDamagerRepairer.setDocument(document);
                Region region = new Region(0, document.getLength());
                TextPresentation presentation = new TextPresentation((IRegion)region, 100);
                presentation.setDefaultStyleRange(new StyleRange(region.getOffset(), region.getLength(), null, null));
                this.templateVariableDamagerRepairer.createPresentation(presentation, (IRegion)region);
                viewer.changeTextPresentation(presentation, false);
            }
        }
    }

    private static class TMEditTemplateDialog
    extends TemplatePreferencePage.EditTemplateDialog {
        private @Nullable TMPresentationReconciler editTemplatePresentationReconsiler = null;
        private @Nullable Combo contextTypeDropDownList = null;

        public TMEditTemplateDialog(Shell shell, Template template, boolean edit, boolean isNameModifiable, ContextTypeRegistry contextTypeRegistry) {
            super(shell, template, edit, isNameModifiable, contextTypeRegistry);
        }

        protected Control createDialogArea(Composite ancestor) {
            Control result = super.createDialogArea(ancestor);
            this.findContextTypeComboAndSetMinNameFieldWidth(ancestor);
            return result;
        }

        private void findContextTypeComboAndSetMinNameFieldWidth(Composite ancestor) {
            boolean foundNameField = false;
            boolean foundDropDownList = false;
            Control[] controlArray = ancestor.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control childControlLvl1 = controlArray[n2];
                if (childControlLvl1 instanceof Composite) {
                    Composite childL1 = (Composite)childControlLvl1;
                    Control[] controlArray2 = childL1.getChildren();
                    int n3 = controlArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Control childControlLvl2 = controlArray2[n4];
                        if (childControlLvl2 instanceof Composite) {
                            Composite childL2 = (Composite)childControlLvl2;
                            Control[] controlArray3 = childL2.getChildren();
                            int n5 = controlArray3.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                Text nameTextField;
                                Object object;
                                Control childControlLvl3 = controlArray3[n6];
                                if (childControlLvl3 instanceof Text && (object = (nameTextField = (Text)childControlLvl3).getLayoutData()) instanceof GridData) {
                                    GridData gridData = (GridData)object;
                                    gridData.minimumWidth = 50;
                                    foundNameField = true;
                                } else if (childControlLvl3 instanceof Combo) {
                                    Combo dropDownList = (Combo)childControlLvl3;
                                    foundDropDownList = true;
                                    this.contextTypeDropDownList = dropDownList;
                                    this.updateSyntaxHighlighting();
                                    dropDownList.addModifyListener(e -> this.updateSyntaxHighlighting());
                                }
                                if (foundNameField && foundDropDownList) {
                                    return;
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }

        private void updateSyntaxHighlighting() {
            TMPresentationReconciler editTemplatePresentationReconsiler = this.editTemplatePresentationReconsiler;
            Combo contextTypeDropDownList = this.contextTypeDropDownList;
            if (editTemplatePresentationReconsiler == null || contextTypeDropDownList == null || contextTypeDropDownList.isDisposed()) {
                return;
            }
            String activeContextTypeName = contextTypeDropDownList.getText();
            IGrammar grammar = CodeTemplateContextTypeUtils.toGrammar(activeContextTypeName);
            editTemplatePresentationReconsiler.setGrammar(grammar);
        }

        protected SourceViewer createViewer(@Nullable Composite parent) {
            SourceViewer originalViewer = super.createViewer(parent);
            final IContentAssistProcessor templateVariableProcessor = this.getTemplateProcessor();
            originalViewer.unconfigure();
            SourceViewerConfiguration configuration = new SourceViewerConfiguration(){

                public @Nullable IContentAssistant getContentAssistant(@Nullable ISourceViewer sourceViewer) {
                    ContentAssistant assistant = new ContentAssistant();
                    assistant.enableAutoActivation(true);
                    assistant.enableAutoInsert(true);
                    assistant.setContentAssistProcessor(templateVariableProcessor, "__dftl_partition_content_type");
                    return assistant;
                }

                public IPresentationReconciler getPresentationReconciler(@Nullable ISourceViewer sourceViewer) {
                    editTemplatePresentationReconsiler = new TMCodeTemplatePresentationReconsiler();
                    return editTemplatePresentationReconsiler;
                }
            };
            originalViewer.configure(configuration);
            originalViewer.addTextListener(event -> this.updateSyntaxHighlighting());
            return originalViewer;
        }
    }

    private static class TMTemplateVariableHighlighter {
        private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{[^\\r\\n\\}]*\\}");
        private static final Color VAR_COLOR_FOREGROUND = new Color(181, 123, 21);
        private @Nullable IDocument document;

        private TMTemplateVariableHighlighter() {
        }

        public void setDocument(@Nullable IDocument document) {
            this.document = document;
        }

        public void createPresentation(@Nullable TextPresentation presentation, @Nullable IRegion damage) {
            IDocument document = this.document;
            if (presentation == null || damage == null || document == null) {
                return;
            }
            try {
                String code = document.get(damage.getOffset(), damage.getLength());
                Matcher varMatcher = VARIABLE_PATTERN.matcher(code);
                while (varMatcher.find()) {
                    int offset = damage.getOffset() + varMatcher.start();
                    int length = varMatcher.end() - varMatcher.start();
                    presentation.mergeStyleRange(new StyleRange(offset, length, VAR_COLOR_FOREGROUND, null, 2));
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

