/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.text;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.CursorLinePainter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.PaintManager;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.tm4e.core.model.ModelTokensChangedEvent;
import org.eclipse.tm4e.core.model.Range;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.utils.ClassHelper;
import org.eclipse.tm4e.ui.model.ITMDocumentModel;
import org.eclipse.tm4e.ui.text.ITMPresentationReconcilerListener;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.ITokenProvider;

class Colorizer {
    private static final TextAttribute DEFAULT_TEXT_ATTRIBUTE = new TextAttribute(null);
    private final ITokenProvider theme;
    private final ITextViewer viewer;
    private final Set<ITMPresentationReconcilerListener> listeners;
    private boolean isViewerStyleColorsInitialized;
    private boolean isViewerHighlightColorInitialized;

    Colorizer(ITextViewer viewer, ITokenProvider theme, Set<ITMPresentationReconcilerListener> listeners) {
        this.viewer = viewer;
        this.theme = theme;
        this.listeners = listeners;
        this.applyThemeToViewer();
    }

    void colorize(ModelTokensChangedEvent event) {
        IDocument doc = this.viewer.getDocument();
        if (doc == null) {
            return;
        }
        if (event.model instanceof ITMDocumentModel) {
            ITMDocumentModel docModel = (ITMDocumentModel)event.model;
            if (docModel.getDocument() != doc) {
                return;
            }
            for (Range range : event.ranges) {
                try {
                    int length = doc.getLineOffset(range.toLineNumber - 1) + doc.getLineLength(range.toLineNumber - 1) - doc.getLineOffset(range.fromLineNumber - 1);
                    Region region = new Region(doc.getLineOffset(range.fromLineNumber - 1), length);
                    this.colorize((IRegion)region, docModel);
                }
                catch (BadLocationException ex) {
                    if (!TMUIPlugin.isLogTraceEnabled()) continue;
                    TMUIPlugin.logError((Exception)((Object)ex));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void colorize(IRegion damageRegion, ITMDocumentModel tmModel) throws BadLocationException {
        block15: {
            this.applyThemeToViewerIfNeeded();
            doc = tmModel.getDocument();
            fromLineIndex = doc.getLineOfOffset(damageRegion.getOffset());
            toLineIndex = doc.getLineOfOffset(damageRegion.getOffset() + damageRegion.getLength());
            if (TMUIPlugin.isLogTraceEnabled()) {
                TMUIPlugin.logTrace("Colorize lines from " + (fromLineIndex + 1) + " to " + (toLineIndex + 1));
            }
            presentation = new TextPresentation(damageRegion, 1000);
            error = null;
            theme = this.theme;
            try {
                lastStart = presentation.getExtent().getOffset();
                length = 0;
                firstToken = true;
                lastToken = Token.UNDEFINED;
                lastAttribute = this.getTokenTextAttribute(lastToken);
                tokens = null;
                lineIndex = fromLineIndex;
                while (lineIndex <= toLineIndex) {
                    block17: {
                        block16: {
                            tokens = tmModel.getLineTokens(lineIndex);
                            if (tokens != null) break block16;
                            if (TMUIPlugin.isLogTraceEnabled()) {
                                TMUIPlugin.logTrace("TextMate tokens not yet available for line " + lineIndex);
                            }
                            break block17;
                        }
                        startLineOffset = doc.getLineOffset(lineIndex);
                        lineLength = doc.getLineLength(lineIndex);
                        nextTokenIndex = 0;
                        for (TMToken currentToken : tokens) {
                            nextToken = ++nextTokenIndex < tokens.size() ? (TMToken)tokens.get(nextTokenIndex) : null;
                            tokenStartIndex = currentToken.startIndex;
                            if (!this.isTokenBeforeRegion(currentToken, startLineOffset, damageRegion)) ** GOTO lbl43
                            if (nextToken != null) {
                                if (this.isTokenBeforeRegion(nextToken, startLineOffset, damageRegion)) continue;
                                tokenStartIndex = damageRegion.getOffset() - startLineOffset;
                            } else {
                                tokenStartIndex = damageRegion.getOffset() - startLineOffset;
                                token = theme == null ? ITokenProvider.DEFAULT_TOKEN : theme.getToken(currentToken);
                                lastAttribute = this.getTokenTextAttribute(token);
                                length += this.getTokenLength(tokenStartIndex, nextToken, lineLength);
                                firstToken = false;
                                continue;
lbl43:
                                // 1 sources

                                if (this.isTokenAfterRegion(currentToken, startLineOffset, damageRegion)) break;
                            }
                            token = theme == null ? ITokenProvider.DEFAULT_TOKEN : theme.getToken(currentToken);
                            attribute = this.getTokenTextAttribute(token);
                            if (lastAttribute.equals((Object)attribute)) {
                                length += this.getTokenLength(tokenStartIndex, nextToken, lineLength);
                                firstToken = false;
                                continue;
                            }
                            if (!firstToken) {
                                this.addStyleRange(presentation, lastStart, length, lastAttribute);
                            }
                            firstToken = false;
                            lastToken = token;
                            lastAttribute = attribute;
                            lastStart = tokenStartIndex + startLineOffset;
                            length = this.getTokenLength(tokenStartIndex, nextToken, lineLength);
                        }
                    }
                    ++lineIndex;
                }
                length = Math.min(length, damageRegion.getOffset() + damageRegion.getLength() - lastStart);
                this.addStyleRange(presentation, lastStart, length, lastAttribute);
                this.viewer.changeTextPresentation(presentation, false);
            }
            catch (IllegalArgumentException | BadLocationException ex) {
                error = ex;
                if (TMUIPlugin.isLogTraceEnabled()) {
                    TMUIPlugin.logError((Exception)ex);
                }
                err = error;
                this.listeners.forEach((Consumer<ITMPresentationReconcilerListener>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(org.eclipse.jface.text.TextPresentation java.lang.Exception org.eclipse.tm4e.ui.text.ITMPresentationReconcilerListener ), (Lorg/eclipse/tm4e/ui/text/ITMPresentationReconcilerListener;)V)((TextPresentation)presentation, (Exception)err));
                break block15;
            }
            catch (Exception ex) {
                try {
                    error = ex;
                    TMUIPlugin.logError(ex);
                    err = error;
                }
                catch (Throwable var25_31) {
                    err = error;
                    this.listeners.forEach((Consumer<ITMPresentationReconcilerListener>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(org.eclipse.jface.text.TextPresentation java.lang.Exception org.eclipse.tm4e.ui.text.ITMPresentationReconcilerListener ), (Lorg/eclipse/tm4e/ui/text/ITMPresentationReconcilerListener;)V)((TextPresentation)presentation, (Exception)err));
                    throw var25_31;
                }
                this.listeners.forEach((Consumer<ITMPresentationReconcilerListener>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(org.eclipse.jface.text.TextPresentation java.lang.Exception org.eclipse.tm4e.ui.text.ITMPresentationReconcilerListener ), (Lorg/eclipse/tm4e/ui/text/ITMPresentationReconcilerListener;)V)((TextPresentation)presentation, (Exception)err));
                break block15;
            }
            err = error;
            this.listeners.forEach((Consumer<ITMPresentationReconcilerListener>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(org.eclipse.jface.text.TextPresentation java.lang.Exception org.eclipse.tm4e.ui.text.ITMPresentationReconcilerListener ), (Lorg/eclipse/tm4e/ui/text/ITMPresentationReconcilerListener;)V)((TextPresentation)presentation, (Exception)err));
        }
    }

    private void addStyleRange(TextPresentation presentation, int offset, int length, TextAttribute attr) {
        int style = attr.getStyle();
        int fontStyle = style & 3;
        StyleRange styleRange = new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), fontStyle);
        styleRange.strikeout = (style & 0x20000000) != 0;
        styleRange.underline = (style & 0x40000000) != 0;
        styleRange.font = attr.getFont();
        presentation.addStyleRange(styleRange);
    }

    private void applyThemeToViewer() {
        this.isViewerStyleColorsInitialized = false;
        this.isViewerHighlightColorInitialized = false;
        this.applyThemeToViewerIfNeeded();
    }

    private void applyThemeToViewerIfNeeded() {
        ITokenProvider iTokenProvider;
        if (!this.isViewerStyleColorsInitialized && (iTokenProvider = this.theme) instanceof ITheme) {
            ITheme theTheme = (ITheme)iTokenProvider;
            StyledText styledText = this.viewer.getTextWidget();
            theTheme.initializeViewerColors(styledText);
            this.isViewerStyleColorsInitialized = true;
        }
        if (!this.isViewerHighlightColorInitialized) {
            try {
                PaintManager paintManager = (PaintManager)ClassHelper.getFieldValue(this.viewer, "fPaintManager", TextViewer.class);
                if (paintManager == null) {
                    return;
                }
                List painters = (List)ClassHelper.getFieldValue(paintManager, "fPainters", PaintManager.class);
                if (painters == null) {
                    return;
                }
                for (IPainter painter : painters) {
                    if (!(painter instanceof CursorLinePainter)) continue;
                    CursorLinePainter cursorLinePainter = (CursorLinePainter)painter;
                    Color background = this.theme.getEditorCurrentLineHighlight();
                    if (background != null) {
                        cursorLinePainter.setHighlightColor(background);
                    }
                    this.isViewerHighlightColorInitialized = true;
                }
            }
            catch (Exception ex) {
                TMUIPlugin.logError(ex);
            }
        }
    }

    private boolean isTokenAfterRegion(TMToken token, int startLineOffset, IRegion damage) {
        return token.startIndex + startLineOffset >= damage.getOffset() + damage.getLength();
    }

    private boolean isTokenBeforeRegion(TMToken token, int startLineOffset, IRegion damage) {
        return token.startIndex + startLineOffset < damage.getOffset();
    }

    private int getTokenLength(int tokenStartIndex, @Nullable TMToken nextToken, int lineLength) {
        return nextToken == null ? lineLength - tokenStartIndex : nextToken.startIndex - tokenStartIndex;
    }

    private TextAttribute getTokenTextAttribute(IToken token) {
        TextAttribute textAttr;
        Object object = token.getData();
        return object instanceof TextAttribute ? (textAttr = (TextAttribute)object) : DEFAULT_TEXT_ATTRIBUTE;
    }

    ITextViewer getTextViewer() {
        return this.viewer;
    }

    private static /* synthetic */ void lambda$0(TextPresentation textPresentation, Exception exception, ITMPresentationReconcilerListener l) {
        l.onColorized(textPresentation, exception);
    }
}

