/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.templates;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.templates.ContextTypeRegistry;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.ui.TMImages;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.utils.CodeTemplateContextTypeUtils;
import org.eclipse.tm4e.ui.internal.utils.UI;
import org.eclipse.tm4e.ui.model.ITMDocumentModel;

public class TMTemplateCompletionProcessor
extends TemplateCompletionProcessor {
    private static final Template[] NO_TEMPLATES = new Template[0];

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        return UI.runSync(() -> TMTemplateCompletionProcessor.super.computeCompletionProposals(viewer, offset));
    }

    private @Nullable TmTokenRegion retrieveTmTokenFor(IDocument document, int offset) {
        int length;
        String lineDelimiter;
        int lineLength;
        int lineStartOffset;
        int lineIndex;
        ITMDocumentModel model = TMUIPlugin.getTMModelManager().connect(document);
        try {
            lineIndex = document.getLineOfOffset(offset);
            lineStartOffset = document.getLineOffset(lineIndex);
            lineLength = document.getLineLength(lineIndex);
            lineDelimiter = document.getLineDelimiter(lineIndex);
        }
        catch (BadLocationException e) {
            Platform.getLog(((Object)((Object)this)).getClass()).error(e.getMessage(), (Throwable)e);
            return null;
        }
        List lineTokens = model.getLineTokens(lineIndex);
        if (lineTokens == null) {
            return null;
        }
        TMToken tokenAtOffset = null;
        TMToken nextToken = null;
        for (TMToken token : lineTokens) {
            if (token.startIndex <= offset - lineStartOffset) {
                tokenAtOffset = token;
                continue;
            }
            nextToken = token;
            break;
        }
        if (tokenAtOffset == null) {
            return null;
        }
        if (nextToken != null) {
            length = nextToken.startIndex - tokenAtOffset.startIndex;
        } else {
            length = lineLength - tokenAtOffset.startIndex;
            if (lineDelimiter != null) {
                length -= lineDelimiter.length();
            }
        }
        return new TmTokenRegion(tokenAtOffset, offset, length);
    }

    private @Nullable TemplateContextType retrieveTemplateContextType(TMToken textMateToken) {
        TemplateContextType contextType;
        TMUIPlugin plugin = TMUIPlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        ContextTypeRegistry contextTypeRegistry = plugin.getTemplateContextRegistry();
        if (textMateToken.type.contains("comment") && (contextType = textMateToken.type.contains("documentation") ? contextTypeRegistry.getContextType("org.eclipse.tm4e.ui.templates.context.comment.doc") : contextTypeRegistry.getContextType("org.eclipse.tm4e.ui.templates.context.comment")) != null) {
            return contextType;
        }
        contextType = plugin.getTemplateContextRegistry().getContextType(CodeTemplateContextTypeUtils.toContextTypeId(textMateToken));
        if (contextType != null) {
            return contextType;
        }
        return contextTypeRegistry.getContextType("org.eclipse.tm4e.ui.templates.context");
    }

    protected @Nullable TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        TmTokenRegion tokenRegion;
        TMUIPlugin plugin = TMUIPlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        IDocument document = viewer.getDocument();
        if (document != null && (tokenRegion = this.retrieveTmTokenFor(document, region.getOffset())) != null) {
            return this.retrieveTemplateContextType(tokenRegion.getToken());
        }
        return plugin.getTemplateContextRegistry().getContextType("org.eclipse.tm4e.ui.templates.context");
    }

    protected @Nullable Image getImage(Template template) {
        return TMImages.getImage("IMG_TEMPALTE");
    }

    protected Template[] getTemplates(String contextTypeId) {
        TMUIPlugin plugin = TMUIPlugin.getDefault();
        if (plugin == null) {
            return NO_TEMPLATES;
        }
        TemplateStore templateStore = plugin.getTemplateStore();
        Template[] customTemplates = templateStore.getTemplates(contextTypeId);
        if (customTemplates.length == 0) {
            return NO_TEMPLATES;
        }
        return customTemplates;
    }

    private static class TmTokenRegion
    implements IRegion {
        private final TMToken token;
        private final int offset;
        private final int length;

        public TmTokenRegion(TMToken token, int offset, int length) {
            this.token = token;
            this.offset = offset;
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public TMToken getToken() {
            return this.token;
        }
    }
}

