/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.hrm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum IsaType implements Enumerator
{
    RISC(0, "risc", "risc"),
    CISC(1, "cisc", "cisc"),
    VLIW(2, "vliw", "vliw"),
    SIMD(3, "simd", "simd"),
    MIMD(4, "mimd", "mimd"),
    OTHER(5, "other", "other"),
    UNDEF(6, "undef", "undef");

    public static final int RISC_VALUE = 0;
    public static final int CISC_VALUE = 1;
    public static final int VLIW_VALUE = 2;
    public static final int SIMD_VALUE = 3;
    public static final int MIMD_VALUE = 4;
    public static final int OTHER_VALUE = 5;
    public static final int UNDEF_VALUE = 6;
    private static final IsaType[] VALUES_ARRAY;
    public static final List<IsaType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IsaType[]{RISC, CISC, VLIW, SIMD, MIMD, OTHER, UNDEF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IsaType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IsaType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IsaType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IsaType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IsaType get(int value) {
        switch (value) {
            case 0: {
                return RISC;
            }
            case 1: {
                return CISC;
            }
            case 2: {
                return VLIW;
            }
            case 3: {
                return SIMD;
            }
            case 4: {
                return MIMD;
            }
            case 5: {
                return OTHER;
            }
            case 6: {
                return UNDEF;
            }
        }
        return null;
    }

    private IsaType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

