/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.marte.hrm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConditionType implements Enumerator
{
    TEMPERATURE(0, "temperature", "temperature"),
    HUMIDITY(1, "humidity", "humidity"),
    ALTITUDE(2, "altitude", "altitude"),
    VIBRATION(3, "vibration", "vibration"),
    SHOCK(4, "shock", "shock"),
    OTHER(5, "other", "other"),
    UNDEF(6, "undef", "undef");

    public static final int TEMPERATURE_VALUE = 0;
    public static final int HUMIDITY_VALUE = 1;
    public static final int ALTITUDE_VALUE = 2;
    public static final int VIBRATION_VALUE = 3;
    public static final int SHOCK_VALUE = 4;
    public static final int OTHER_VALUE = 5;
    public static final int UNDEF_VALUE = 6;
    private static final ConditionType[] VALUES_ARRAY;
    public static final List<ConditionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConditionType[]{TEMPERATURE, HUMIDITY, ALTITUDE, VIBRATION, SHOCK, OTHER, UNDEF};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConditionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConditionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConditionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConditionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConditionType get(int value) {
        switch (value) {
            case 0: {
                return TEMPERATURE;
            }
            case 1: {
                return HUMIDITY;
            }
            case 2: {
                return ALTITUDE;
            }
            case 3: {
                return VIBRATION;
            }
            case 4: {
                return SHOCK;
            }
            case 5: {
                return OTHER;
            }
            case 6: {
                return UNDEF;
            }
        }
        return null;
    }

    private ConditionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

