/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.eef.section;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.sirius.eef.adapters.EEFAdapterPlugin;
import org.eclipse.ui.views.properties.tabbed.AbstractSectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ISection;

class SectionDescriptor
extends AbstractSectionDescriptor {
    private String targetTab;
    private IConfigurationElement configurationElement;
    private List<String> inputTypes = new ArrayList<String>();
    private String id;
    private IFilter filter;
    private int enablesFor = -1;
    private String afterSection;

    protected SectionDescriptor(IConfigurationElement cfgElement) {
        this.configurationElement = cfgElement;
        this.id = cfgElement.getAttribute("id");
        this.targetTab = cfgElement.getAttribute("tab");
        this.afterSection = cfgElement.getAttribute("afterSection");
        if (this.afterSection == null) {
            this.afterSection = "top";
        }
        if (cfgElement.getAttribute("enablesFor") != null) {
            try {
                this.enablesFor = Integer.parseInt(cfgElement.getAttribute("enablesFor"));
                if (this.enablesFor < 0) {
                    this.enablesFor = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.enablesFor = -1;
            }
        }
        try {
            IConfigurationElement[] elements;
            if (cfgElement.getAttribute("filter") != null) {
                this.filter = (IFilter)cfgElement.createExecutableExtension("filter");
            }
            IConfigurationElement[] iConfigurationElementArray = elements = cfgElement.getChildren("input");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                this.inputTypes.add(element.getAttribute("type"));
                ++n2;
            }
        }
        catch (CoreException e) {
            EEFAdapterPlugin.getPlugin().getLog().log(e.getStatus());
        }
    }

    public String getId() {
        return this.id;
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public List<String> getInputTypes() {
        return this.inputTypes;
    }

    public ISection getSectionClass() {
        ISection section = null;
        try {
            section = (ISection)this.configurationElement.createExecutableExtension("class");
        }
        catch (CoreException exception) {
            EEFAdapterPlugin.getPlugin().getLog().log(exception.getStatus());
        }
        return section;
    }

    public String getTargetTab() {
        return this.targetTab;
    }

    public int getEnablesFor() {
        return this.enablesFor;
    }

    public String getAfterSection() {
        return this.afterSection;
    }
}

