/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core.internal.utils;

import java.net.URI;
import java.net.URISyntaxException;

public class UriUtils {
    private UriUtils() {
    }

    public static URI getUriFromString(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid uri: " + uri, e);
        }
    }

    public static URI getUriWithoutQuery(String uriString) {
        try {
            URI uri = new URI(uriString);
            if (uri.getQuery() == null) {
                return uri;
            }
            return new URI(uri.getScheme(), uri.getHost(), uri.getPath(), null, uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid uri: " + uriString, e);
        }
    }

    public static String getQueryValueByKey(String uriString, String key) {
        try {
            String[] pairs;
            URI uri = new URI(uriString);
            if (uri.getQuery() == null) {
                return "";
            }
            String query = uri.getQuery();
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf("=");
                if (idx <= 0 || !key.equals(pair.substring(0, idx))) continue;
                return pair.substring(idx + 1);
            }
            return "";
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid uri: " + uriString, e);
        }
    }
}

