/*
 * Decompiled with CFR 0.152.
 */
package com.github.badsyntax.gradle.handlers;

import com.github.badsyntax.gradle.ByteBufferOutputStream;
import com.github.badsyntax.gradle.Cancelled;
import com.github.badsyntax.gradle.ErrorMessageBuilder;
import com.github.badsyntax.gradle.GradleBuildRunner;
import com.github.badsyntax.gradle.Output;
import com.github.badsyntax.gradle.Progress;
import com.github.badsyntax.gradle.RunBuildReply;
import com.github.badsyntax.gradle.RunBuildRequest;
import com.github.badsyntax.gradle.RunBuildResult;
import com.github.badsyntax.gradle.exceptions.GradleBuildRunnerException;
import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import io.grpc.stub.StreamObserver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.exceptions.UnsupportedBuildArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunBuildHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)RunBuildHandler.class.getName());
    private RunBuildRequest req;
    private StreamObserver<RunBuildReply> responseObserver;
    private ProgressListener progressListener;
    private ByteBufferOutputStream standardOutputListener;
    private ByteBufferOutputStream standardErrorListener;

    public RunBuildHandler(RunBuildRequest req, StreamObserver<RunBuildReply> responseObserver) {
        this.req = req;
        this.responseObserver = responseObserver;
        this.progressListener = event -> {
            Class<RunBuildHandler> clazz = RunBuildHandler.class;
            synchronized (RunBuildHandler.class) {
                this.replyWithProgress(event);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        };
        this.standardOutputListener = new ByteBufferOutputStream(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFlush(byte[] bytes) {
                Class<RunBuildHandler> clazz = RunBuildHandler.class;
                synchronized (RunBuildHandler.class) {
                    RunBuildHandler.this.replyWithStandardOutput(bytes);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        this.standardErrorListener = new ByteBufferOutputStream(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFlush(byte[] bytes) {
                Class<RunBuildHandler> clazz = RunBuildHandler.class;
                synchronized (RunBuildHandler.class) {
                    RunBuildHandler.this.replyWithStandardError(bytes);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
    }

    public void run() {
        GradleBuildRunner gradleRunner = new GradleBuildRunner(this.req.getProjectDir(), (List<String>)this.req.getArgsList(), this.req.getGradleConfig(), this.req.getCancellationKey(), this.req.getShowOutputColors(), this.req.getJavaDebugPort(), this.req.getJavaDebugCleanOutputCache(), this.req.getAdditionalToolOptions());
        gradleRunner.setProgressListener(this.progressListener).setStandardOutputStream(this.standardOutputListener).setStandardErrorStream(this.standardErrorListener);
        if (!Strings.isNullOrEmpty((String)this.req.getInput())) {
            gradleRunner.setStandardInputStream(new ByteArrayInputStream(this.req.getInput().getBytes()));
        }
        try {
            gradleRunner.run();
            this.replyWithSuccess();
            this.responseObserver.onCompleted();
        }
        catch (BuildCancelledException e) {
            this.replyWithCancelled(e);
            this.responseObserver.onCompleted();
        }
        catch (GradleBuildRunnerException | IOException | IllegalStateException | BuildException | UnsupportedVersionException | UnsupportedBuildArgumentException e) {
            logger.error(e.getMessage());
            this.replyWithError((Exception)e);
        }
    }

    public void replyWithCancelled(BuildCancelledException e) {
        this.responseObserver.onNext((Object)RunBuildReply.newBuilder().setCancelled(Cancelled.newBuilder().setMessage(e.getMessage()).setProjectDir(this.req.getProjectDir())).build());
    }

    public void replyWithError(Exception e) {
        this.responseObserver.onError((Throwable)ErrorMessageBuilder.build(e));
    }

    public void replyWithSuccess() {
        this.responseObserver.onNext((Object)RunBuildReply.newBuilder().setRunBuildResult(RunBuildResult.newBuilder().setMessage("Successfully run build")).build());
    }

    private void replyWithProgress(ProgressEvent progressEvent) {
        this.responseObserver.onNext((Object)RunBuildReply.newBuilder().setProgress(Progress.newBuilder().setMessage(progressEvent.getDisplayName())).build());
    }

    private void replyWithStandardOutput(byte[] bytes) {
        ByteString byteString = ByteString.copyFrom((byte[])bytes);
        this.responseObserver.onNext((Object)RunBuildReply.newBuilder().setOutput(Output.newBuilder().setOutputType(Output.OutputType.STDOUT).setOutputBytes(byteString)).build());
    }

    private void replyWithStandardError(byte[] bytes) {
        ByteString byteString = ByteString.copyFrom((byte[])bytes);
        this.responseObserver.onNext((Object)RunBuildReply.newBuilder().setOutput(Output.newBuilder().setOutputType(Output.OutputType.STDERR).setOutputBytes(byteString)).build());
    }
}

