/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEditGroup;

public class BooleanValueRatherThanComparisonFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit) {
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        BooleanValueRatherThanComparisonFinder finder = new BooleanValueRatherThanComparisonFinder(operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new BooleanValueRatherThanComparisonFixCore(FixMessages.BooleanValueRatherThanComparisonFix_description, compilationUnit, ops);
    }

    protected BooleanValueRatherThanComparisonFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static final class BooleanValueRatherThanComparisonFinder
    extends ASTVisitor {
        private List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> fResult;

        public BooleanValueRatherThanComparisonFinder(List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> ops) {
            this.fResult = ops;
        }

        public boolean visit(MethodInvocation visited) {
            if (ASTNodes.usesGivenSignature(visited, Boolean.class.getCanonicalName(), "equals", Object.class.getCanonicalName())) {
                Boolean isExpressionTrue = ASTNodes.getBooleanLiteral((ASTNode)visited.getExpression());
                Expression argument = (Expression)visited.arguments().get(0);
                if (isExpressionTrue != null && ASTNodes.isPrimitive(argument, Boolean.TYPE.getSimpleName())) {
                    this.fResult.add(new BooleanValueRatherThanComparisonOperation((ASTNode)visited, argument, isExpressionTrue));
                    return false;
                }
                Boolean isArgumentTrue = ASTNodes.getBooleanLiteral((ASTNode)argument);
                if (visited.getExpression() != null && (Boolean.FALSE.equals(isArgumentTrue) || Boolean.TRUE.equals(isArgumentTrue) && visited.getLocationInParent() != MethodInvocation.ARGUMENTS_PROPERTY && ASTNodes.hasType(ASTNodes.getTargetType((Expression)visited), Boolean.TYPE.getSimpleName()))) {
                    this.fResult.add(new BooleanValueRatherThanComparisonOperation((ASTNode)visited, visited.getExpression(), isArgumentTrue));
                    return false;
                }
            }
            return true;
        }

        public boolean visit(ParenthesizedExpression visited) {
            InfixExpression originalCondition = ASTNodes.as((Expression)visited, InfixExpression.class);
            if (originalCondition != null) {
                return this.maybeRefactorInfixExpression((Expression)visited, originalCondition);
            }
            return true;
        }

        public boolean visit(InfixExpression visited) {
            return this.maybeRefactorInfixExpression((Expression)visited, visited);
        }

        private boolean maybeRefactorInfixExpression(Expression visited, InfixExpression originalCondition) {
            if (!originalCondition.hasExtendedOperands() && ASTNodes.hasOperator(originalCondition, InfixExpression.Operator.EQUALS, InfixExpression.Operator.NOT_EQUALS, InfixExpression.Operator.XOR) && (ASTNodes.isPrimitive(originalCondition.getLeftOperand(), Boolean.TYPE.getSimpleName()) || ASTNodes.isPrimitive(originalCondition.getRightOperand(), Boolean.TYPE.getSimpleName()))) {
                boolean isEquals;
                Expression rightExpression;
                Expression leftExpression = originalCondition.getLeftOperand();
                return this.maybeRemoveConstantOperand(visited, leftExpression, rightExpression = originalCondition.getRightOperand(), isEquals = ASTNodes.hasOperator(originalCondition, InfixExpression.Operator.EQUALS, new InfixExpression.Operator[0])) && this.maybeRemoveConstantOperand(visited, rightExpression, leftExpression, isEquals);
            }
            return true;
        }

        private boolean maybeRemoveConstantOperand(Expression visited, Expression dynamicOperand, Expression hardCodedOperand, boolean isEquals) {
            Boolean booleanLiteral = ASTNodes.getBooleanLiteral((ASTNode)hardCodedOperand);
            if (booleanLiteral != null) {
                boolean isTrue;
                boolean bl = isTrue = booleanLiteral == isEquals;
                if (!isTrue || ASTNodes.isPrimitive(dynamicOperand, Boolean.TYPE.getSimpleName()) || visited.getLocationInParent() != MethodInvocation.ARGUMENTS_PROPERTY && ASTNodes.hasType(ASTNodes.getTargetType(visited), Boolean.TYPE.getSimpleName())) {
                    this.fResult.add(new BooleanValueRatherThanComparisonOperation((ASTNode)visited, dynamicOperand, isTrue));
                    return false;
                }
            }
            return true;
        }
    }

    private static class BooleanValueRatherThanComparisonOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final ASTNode visited;
        private final Expression expressionToCopy;
        private final boolean isTrue;

        public BooleanValueRatherThanComparisonOperation(ASTNode visited, Expression expressionToCopy, boolean isTrue) {
            this.visited = visited;
            this.expressionToCopy = expressionToCopy;
            this.isTrue = isTrue;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.BooleanValueRatherThanComparisonCleanUp_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            Expression operand = this.isTrue ? ASTNodes.createMoveTarget(rewrite, this.expressionToCopy) : ASTNodeFactory.negate(ast, rewrite, this.expressionToCopy, true);
            rewrite.replace(this.visited, (ASTNode)ASTNodeFactory.parenthesizeIfNeeded(ast, operand), group);
        }
    }
}

