"use strict";
/*********************************************************************
 * Copyright (c) 2022 Kichwa Coders Canada Inc. and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AmalgamatorClient = void 0;
const debugadapter_testsupport_1 = require("@vscode/debugadapter-testsupport");
const logger_1 = require("@vscode/debugadapter/lib/logger");
class AmalgamatorClient extends debugadapter_testsupport_1.DebugClient {
    constructor() {
        super(...arguments);
        this.clientExited = false;
        // There should not be any error output from a client - any error is probably fatal.
        this.errorOutput = '';
    }
    hasClientExited() {
        return this.clientExited;
    }
    getPendingRequests() {
        // XXX: Access private _adapterProcess with this trick
        return this.pendingRequests;
    }
    clearPendingRequests() {
        const pending = this.getPendingRequests();
        pending.forEach((clb) => {
            const error = {
                message: "Child debug adapter exited. See log for more details. Process' errors: " +
                    this.errorOutput,
            };
            clb(error);
        });
        pending.clear();
    }
    getAdapterProcess() {
        // XXX: Access private _adapterProcess with this trick
        return this._adapterProcess;
    }
    start(port) {
        const _super = Object.create(null, {
            start: { get: () => super.start }
        });
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            yield _super.start.call(this, port);
            if (typeof port !== 'number') {
                this.getAdapterProcess().on('exit', (_code, _signal) => {
                    this.clientExited = true;
                    this.clearPendingRequests();
                });
                (_a = this.getAdapterProcess().stderr) === null || _a === void 0 ? void 0 : _a.on('data', (data) => {
                    logger_1.logger.error(data.toString());
                    this.errorOutput += data.toString();
                });
                this.getAdapterProcess().on('error', (err) => {
                    this.clientExited = true;
                    logger_1.logger.error(err.toString());
                    this.errorOutput += err.toString();
                    this.clearPendingRequests();
                });
            }
        });
    }
}
exports.AmalgamatorClient = AmalgamatorClient;
//# sourceMappingURL=AmalgamatorClient.js.map