"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_test_lib_browser_view_test-run-view-contribution_js"],{

/***/ "../../node_modules/@theia/test/lib/browser/view/test-context-key-service.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/test/lib/browser/view/test-context-key-service.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TestContextKeyService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
let TestContextKeyService = class TestContextKeyService {
    get contextValue() {
        return this._contextValue;
    }
    init() {
        this._contextValue = this.contextKeyService.createKey('testMessage', undefined);
    }
};
exports.TestContextKeyService = TestContextKeyService;
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], TestContextKeyService.prototype, "contextKeyService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TestContextKeyService.prototype, "init", null);
exports.TestContextKeyService = TestContextKeyService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TestContextKeyService);


/***/ }),

/***/ "../../node_modules/@theia/test/lib/browser/view/test-execution-state-manager.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@theia/test/lib/browser/view/test-execution-state-manager.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TestExecutionStateManager = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const test_service_1 = __webpack_require__(/*! ../test-service */ "../../node_modules/@theia/test/lib/browser/test-service.js");
/**
 * This class manages the state of "internal" nodes in the test tree
 */
let TestExecutionStateManager = class TestExecutionStateManager {
    constructor() {
        this.executionStates = new Map();
    }
    init() {
        this.testService.getControllers().forEach(controller => this.addController(controller));
        this.testService.onControllersChanged(controllerDelta => {
            var _a;
            (_a = controllerDelta.added) === null || _a === void 0 ? void 0 : _a.forEach(controller => this.addController(controller));
        });
    }
    addController(controller) {
        controller.testRuns.forEach(run => this.addRun(run));
        controller.onRunsChanged(runDelta => {
            var _a, _b;
            (_a = runDelta.added) === null || _a === void 0 ? void 0 : _a.forEach(run => this.addRun(run));
            (_b = runDelta.removed) === null || _b === void 0 ? void 0 : _b.forEach(run => {
                this.executionStates.delete(run);
            });
        });
    }
    addRun(run) {
        this.executionStates.set(run, new TestExecutionStateMap);
        run.onDidChangeTestState(updates => {
            updates.forEach(update => {
                var _a, _b;
                this.updateState(run, update.test, (_a = update.oldState) === null || _a === void 0 ? void 0 : _a.state, (_b = update.newState) === null || _b === void 0 ? void 0 : _b.state);
            });
        });
    }
    updateState(run, item, oldState, newState) {
        const map = this.executionStates.get(run);
        map.reportState(item, oldState, newState);
    }
    getComputedState(run, item) {
        var _a;
        return (_a = this.executionStates.get(run)) === null || _a === void 0 ? void 0 : _a.getComputedState(item);
    }
};
exports.TestExecutionStateManager = TestExecutionStateManager;
tslib_1.__decorate([
    (0, inversify_1.inject)(test_service_1.TestService),
    tslib_1.__metadata("design:type", Object)
], TestExecutionStateManager.prototype, "testService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TestExecutionStateManager.prototype, "init", null);
exports.TestExecutionStateManager = TestExecutionStateManager = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TestExecutionStateManager);
class TestExecutionStateMap {
    constructor() {
        this.stateCounts = new Map();
    }
    reportState(item, oldState, newState) {
        if (oldState !== newState) {
            if (item.parent) {
                this.reportChildStateChanged(item.parent, oldState, newState);
            }
        }
    }
    reportChildStateChanged(parent, oldState, newState) {
        if (oldState !== newState) {
            const currentParentState = this.getComputedState(parent);
            let counts = this.stateCounts.get(parent);
            if (!counts) {
                counts = [];
                counts[test_service_1.TestExecutionState.Queued] = 0;
                counts[test_service_1.TestExecutionState.Running] = 0;
                counts[test_service_1.TestExecutionState.Passed] = 0;
                counts[test_service_1.TestExecutionState.Failed] = 0;
                counts[test_service_1.TestExecutionState.Skipped] = 0;
                counts[test_service_1.TestExecutionState.Errored] = 0;
                this.stateCounts.set(parent, counts);
            }
            if (oldState) {
                counts[oldState]--;
            }
            if (newState) {
                counts[newState]++;
            }
            const newParentState = this.getComputedState(parent);
            if (parent.parent && currentParentState !== newParentState) {
                this.reportChildStateChanged(parent.parent, currentParentState, newParentState);
            }
        }
    }
    updateState(item, oldState, newState) {
        let parent = item.parent;
        while (parent && 'parent' in parent) { // parent is a test item
            let counts = this.stateCounts.get(parent);
            if (!counts) {
                counts = [];
                counts[test_service_1.TestExecutionState.Queued] = 0;
                counts[test_service_1.TestExecutionState.Running] = 0;
                counts[test_service_1.TestExecutionState.Passed] = 0;
                counts[test_service_1.TestExecutionState.Failed] = 0;
                counts[test_service_1.TestExecutionState.Skipped] = 0;
                counts[test_service_1.TestExecutionState.Errored] = 0;
                this.stateCounts.set(parent, counts);
            }
            if (oldState) {
                counts[oldState]--;
            }
            counts[newState]++;
            parent = parent.parent;
        }
    }
    getComputedState(item) {
        const counts = this.stateCounts.get(item);
        if (counts) {
            if (counts[test_service_1.TestExecutionState.Errored] > 0) {
                return test_service_1.TestExecutionState.Errored;
            }
            else if (counts[test_service_1.TestExecutionState.Failed] > 0) {
                return test_service_1.TestExecutionState.Failed;
            }
            else if (counts[test_service_1.TestExecutionState.Running] > 0) {
                return test_service_1.TestExecutionState.Running;
            }
            else if (counts[test_service_1.TestExecutionState.Queued] > 0) {
                return test_service_1.TestExecutionState.Queued;
            }
            else if (counts[test_service_1.TestExecutionState.Passed] > 0) {
                return test_service_1.TestExecutionState.Passed;
            }
            else if (counts[test_service_1.TestExecutionState.Skipped] > 0) {
                return test_service_1.TestExecutionState.Skipped;
            }
            else {
                return undefined;
            }
        }
        else {
            return undefined;
        }
    }
}


/***/ }),

/***/ "../../node_modules/@theia/test/lib/browser/view/test-output-ui-model.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@theia/test/lib/browser/view/test-output-ui-model.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TestOutputUIModel = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const test_service_1 = __webpack_require__(/*! ../test-service */ "../../node_modules/@theia/test/lib/browser/test-service.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const test_context_key_service_1 = __webpack_require__(/*! ./test-context-key-service */ "../../node_modules/@theia/test/lib/browser/view/test-context-key-service.js");
let TestOutputUIModel = class TestOutputUIModel {
    constructor() {
        this.activeRuns = new Map();
        this.controllerListeners = new Map();
        this.onDidChangeActiveTestRunEmitter = new core_1.Emitter();
        this.onDidChangeActiveTestRun = this.onDidChangeActiveTestRunEmitter.event;
        this.onDidChangeActiveTestStateEmitter = new core_1.Emitter();
        this.onDidChangeActiveTestState = this.onDidChangeActiveTestStateEmitter.event;
        this.onDidChangeSelectedOutputSourceEmitter = new core_1.Emitter();
        this.onDidChangeSelectedOutputSource = this.onDidChangeSelectedOutputSourceEmitter.event;
        this.onDidChangeSelectedTestStateEmitter = new core_1.Emitter();
        this.onDidChangeSelectedTestState = this.onDidChangeSelectedTestStateEmitter.event;
    }
    init() {
        this.testService.getControllers().forEach(controller => this.addController(controller));
        this.testService.onControllersChanged(deltas => {
            var _a, _b;
            (_a = deltas.added) === null || _a === void 0 ? void 0 : _a.forEach(controller => this.addController(controller));
            (_b = deltas.removed) === null || _b === void 0 ? void 0 : _b.forEach(controller => this.removeController(controller));
        });
    }
    removeController(id) {
        var _a;
        (_a = this.controllerListeners.get(id)) === null || _a === void 0 ? void 0 : _a.dispose();
        if (this.activeRuns.has(id)) {
            this.activeRuns.delete(id);
        }
    }
    addController(controller) {
        this.controllerListeners.set(controller.id, controller.onRunsChanged(delta => {
            var _a;
            if (delta.added) {
                const currentRun = controller.testRuns[controller.testRuns.length - 1];
                if (currentRun) {
                    this.setActiveTestRun(currentRun);
                }
            }
            else {
                (_a = delta.removed) === null || _a === void 0 ? void 0 : _a.forEach(run => {
                    if (run === this.getActiveTestRun(controller)) {
                        const currentRun = controller.testRuns[controller.testRuns.length - 1];
                        this.doSetActiveRun(controller, currentRun);
                    }
                });
            }
        }));
    }
    getActiveTestRun(controller) {
        var _a;
        return (_a = this.activeRuns.get(controller.id)) === null || _a === void 0 ? void 0 : _a.run;
    }
    setActiveTestRun(run) {
        this.doSetActiveRun(run.controller, run);
    }
    doSetActiveRun(controller, run) {
        const old = this.activeRuns.get(controller.id);
        if (old !== run) {
            if (old) {
                old.toDispose.dispose();
            }
            if (run) {
                const toDispose = run.onDidChangeTestState(e => {
                    this.onDidChangeActiveTestStateEmitter.fire({
                        controller,
                        testRun: run,
                        statedDelta: e
                    });
                });
                this.activeRuns.set(controller.id, { run, toDispose });
            }
            else {
                this.activeRuns.delete(controller.id);
            }
            this.onDidChangeActiveTestRunEmitter.fire({ activeRun: run, controller: controller });
        }
    }
    get selectedOutputSource() {
        return this._selectedOutputSource;
    }
    set selectedOutputSource(element) {
        if (element !== this._selectedOutputSource) {
            this._selectedOutputSource = element;
            this.onDidChangeSelectedOutputSourceEmitter.fire(element);
        }
    }
    get selectedTestState() {
        return this._selectedTestState;
    }
    set selectedTestState(element) {
        if (element !== this._selectedTestState) {
            this._selectedTestState = element;
            if (this._selectedTestState && test_service_1.TestFailure.is(this._selectedTestState.state)) {
                const message = this._selectedTestState.state.messages[0];
                this.testContextKeys.contextValue.set(message.contextValue);
            }
            else {
                this.testContextKeys.contextValue.reset();
            }
            this.onDidChangeSelectedTestStateEmitter.fire(element);
        }
    }
};
exports.TestOutputUIModel = TestOutputUIModel;
tslib_1.__decorate([
    (0, inversify_1.inject)(test_context_key_service_1.TestContextKeyService),
    tslib_1.__metadata("design:type", test_context_key_service_1.TestContextKeyService)
], TestOutputUIModel.prototype, "testContextKeys", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(test_service_1.TestService),
    tslib_1.__metadata("design:type", Object)
], TestOutputUIModel.prototype, "testService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TestOutputUIModel.prototype, "init", null);
exports.TestOutputUIModel = TestOutputUIModel = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TestOutputUIModel);


/***/ }),

/***/ "../../node_modules/@theia/test/lib/browser/view/test-run-view-contribution.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@theia/test/lib/browser/view/test-run-view-contribution.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TestRunViewContribution = exports.TEST_RUNS_INLINE_MENU = exports.TEST_RUNS_CONTEXT_MENU = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const test_service_1 = __webpack_require__(/*! ../test-service */ "../../node_modules/@theia/test/lib/browser/test-service.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
const test_run_widget_1 = __webpack_require__(/*! ./test-run-widget */ "../../node_modules/@theia/test/lib/browser/view/test-run-widget.js");
const test_view_contribution_1 = __webpack_require__(/*! ./test-view-contribution */ "../../node_modules/@theia/test/lib/browser/view/test-view-contribution.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
exports.TEST_RUNS_CONTEXT_MENU = ['test-runs-context-menu'];
exports.TEST_RUNS_INLINE_MENU = [...exports.TEST_RUNS_CONTEXT_MENU, 'inline'];
let TestRunViewContribution = class TestRunViewContribution extends browser_1.AbstractViewContribution {
    constructor() {
        super({
            viewContainerId: test_view_contribution_1.TEST_VIEW_CONTAINER_ID,
            widgetId: test_run_widget_1.TestRunTreeWidget.ID,
            widgetName: core_1.nls.localize('theia/test/testRuns', 'Test Runs'),
            defaultWidgetOptions: {
                area: 'left',
                rank: 200,
            }
        });
    }
    registerToolbarItems(registry) {
        registry.registerItem({
            id: test_view_contribution_1.TestViewCommands.CLEAR_ALL_RESULTS.id,
            command: test_view_contribution_1.TestViewCommands.CLEAR_ALL_RESULTS.id,
            priority: 1
        });
    }
    registerMenus(menus) {
        super.registerMenus(menus);
        menus.registerMenuAction(exports.TEST_RUNS_CONTEXT_MENU, {
            commandId: test_view_contribution_1.TestViewCommands.CANCEL_RUN.id
        });
    }
    registerCommands(commands) {
        super.registerCommands(commands);
        commands.registerCommand(test_view_contribution_1.TestViewCommands.CANCEL_RUN, {
            isEnabled: t => test_service_1.TestRun.is(t) && t.isRunning,
            isVisible: t => test_service_1.TestRun.is(t),
            execute: t => {
                if (test_service_1.TestRun.is(t)) {
                    t.cancel();
                }
            }
        });
        commands.registerCommand(test_view_contribution_1.TestViewCommands.CLEAR_ALL_RESULTS, {
            isEnabled: w => this.withWidget(w, () => true),
            isVisible: w => this.withWidget(w, () => true),
            execute: () => {
                this.testService.clearResults();
            }
        });
    }
    withWidget(widget = this.tryGetWidget(), cb) {
        if (widget instanceof test_run_widget_1.TestRunTreeWidget && widget.id === test_run_widget_1.TestRunTreeWidget.ID) {
            return cb(widget);
        }
        return false;
    }
};
exports.TestRunViewContribution = TestRunViewContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(test_service_1.TestService),
    tslib_1.__metadata("design:type", Object)
], TestRunViewContribution.prototype, "testService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], TestRunViewContribution.prototype, "contextKeys", void 0);
exports.TestRunViewContribution = TestRunViewContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], TestRunViewContribution);


/***/ }),

/***/ "../../node_modules/@theia/test/lib/browser/view/test-run-widget.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@theia/test/lib/browser/view/test-run-widget.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var TestRunTreeWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TestRunTreeWidget = exports.TestRunTree = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const tree_1 = __webpack_require__(/*! @theia/core/lib/browser/tree */ "../../node_modules/@theia/core/lib/browser/tree/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const icon_theme_service_1 = __webpack_require__(/*! @theia/core/lib/browser/icon-theme-service */ "../../node_modules/@theia/core/lib/browser/icon-theme-service.js");
const theming_1 = __webpack_require__(/*! @theia/core/lib/browser/theming */ "../../node_modules/@theia/core/lib/browser/theming.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
const test_service_1 = __webpack_require__(/*! ../test-service */ "../../node_modules/@theia/test/lib/browser/test-service.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const test_execution_state_manager_1 = __webpack_require__(/*! ./test-execution-state-manager */ "../../node_modules/@theia/test/lib/browser/view/test-execution-state-manager.js");
const test_output_ui_model_1 = __webpack_require__(/*! ./test-output-ui-model */ "../../node_modules/@theia/test/lib/browser/view/test-output-ui-model.js");
class TestRunNode {
    constructor(counter, id, run, parent) {
        this.counter = counter;
        this.id = id;
        this.run = run;
        this.parent = parent;
        this.selected = false;
        this.children = [];
    }
    get name() {
        return this.run.name || core_1.nls.localize('theia/test/testRunDefaultName', '{0} run {1}', this.run.controller.label, this.counter);
    }
    ;
}
class TestItemNode {
    constructor(id, item, parent) {
        this.id = id;
        this.item = item;
        this.parent = parent;
        this.selected = false;
    }
    get name() {
        return this.item.label;
    }
}
let TestRunTree = class TestRunTree extends tree_1.TreeImpl {
    constructor() {
        super(...arguments);
        this.ROOT = {
            id: 'TestResults',
            name: 'Test Results',
            parent: undefined,
            children: [],
            visible: false
        };
        this.controllerListeners = new Map();
        this.runs = new Map();
        this.nextId = 0;
    }
    init() {
        this.root = this.ROOT;
        this.testService.getControllers().forEach(controller => {
            this.addController(controller);
        });
        this.testService.onControllersChanged(controllerDelta => {
            var _a, _b;
            (_a = controllerDelta.removed) === null || _a === void 0 ? void 0 : _a.forEach(controller => {
                var _a;
                (_a = this.controllerListeners.get(controller)) === null || _a === void 0 ? void 0 : _a.dispose();
            });
            (_b = controllerDelta.added) === null || _b === void 0 ? void 0 : _b.forEach(controller => this.addController(controller));
        });
    }
    addController(controller) {
        controller.testRuns.forEach(run => this.addRun(run));
        const listeners = new core_1.DisposableCollection();
        this.controllerListeners.set(controller.id, listeners);
        listeners.push(controller.onRunsChanged(runDelta => {
            var _a, _b;
            (_a = runDelta.removed) === null || _a === void 0 ? void 0 : _a.forEach(run => {
                var _a;
                (_a = this.runs.get(run)) === null || _a === void 0 ? void 0 : _a.disposable.dispose();
                this.runs.delete(run);
                this.refresh(this.ROOT);
            });
            (_b = runDelta.added) === null || _b === void 0 ? void 0 : _b.forEach(run => {
                this.addRun(run);
                this.refresh(this.ROOT);
            });
        }));
    }
    addRun(run) {
        const newNode = this.createRunNode(run);
        const affected = [];
        const disposables = new core_1.DisposableCollection();
        disposables.push(run.onDidChangeTestState(deltas => {
            let needsRefresh = false;
            deltas.forEach(delta => {
                if (delta.newState) {
                    if (delta.newState.state > test_service_1.TestExecutionState.Queued) {
                        const testNode = info.tests.get(delta.test);
                        if (!testNode) {
                            if (info.tests.size === 0) {
                                newNode.expanded = true;
                            }
                            info.tests.set(delta.test, this.createTestItemNode(newNode, delta.test));
                            needsRefresh = true;
                        }
                        else {
                            affected.push(testNode);
                        }
                    }
                }
                else {
                    info.tests.delete(delta.test);
                    needsRefresh = true;
                }
            });
            if (needsRefresh) {
                this.refresh(newNode);
            }
            else {
                this.onDidUpdateEmitter.fire(affected);
            }
        }));
        disposables.push(run.onDidChangeProperty(() => this.onDidUpdateEmitter.fire([])));
        const info = {
            node: newNode,
            disposable: disposables,
            tests: new Map(run.items.filter(item => { var _a; return (((_a = run.getTestState(item)) === null || _a === void 0 ? void 0 : _a.state) || 0) > test_service_1.TestExecutionState.Queued; }).map(item => [item, this.createTestItemNode(newNode, item)]))
        };
        this.runs.set(run, info);
    }
    createRunNode(run) {
        return new TestRunNode(this.nextId, `id-${this.nextId++}`, run, this.ROOT);
    }
    createTestItemNode(parent, item) {
        return new TestItemNode(`testitem-${this.nextId++}`, item, parent);
    }
    async resolveChildren(parent) {
        if (parent === this.ROOT) {
            return Promise.resolve([...this.runs.values()].reverse().map(info => info.node));
        }
        else if (parent instanceof TestRunNode) {
            const runInfo = this.runs.get(parent.run);
            if (runInfo) {
                return Promise.resolve([...runInfo.tests.values()]);
            }
            else {
                return Promise.resolve([]);
            }
        }
        else {
            return Promise.resolve([]);
        }
    }
};
exports.TestRunTree = TestRunTree;
tslib_1.__decorate([
    (0, inversify_1.inject)(test_service_1.TestService),
    tslib_1.__metadata("design:type", Object)
], TestRunTree.prototype, "testService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TestRunTree.prototype, "init", null);
exports.TestRunTree = TestRunTree = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TestRunTree);
let TestRunTreeWidget = TestRunTreeWidget_1 = class TestRunTreeWidget extends tree_1.TreeWidget {
    constructor(props, model, contextMenuRenderer) {
        super(props, model, contextMenuRenderer);
        this.id = TestRunTreeWidget_1.ID;
        this.title.label = core_1.nls.localize('theia/test/testRuns', 'Test Runs');
        this.title.caption = core_1.nls.localize('theia/test/testRuns', 'Test Runs');
        this.title.iconClass = (0, browser_1.codicon)('run');
        this.title.closable = true;
    }
    init() {
        super.init();
        this.addClass('theia-test-run-view');
        this.model.onSelectionChanged(() => {
            const node = this.model.selectedNodes[0];
            if (node instanceof TestRunNode) {
                this.uiModel.selectedOutputSource = {
                    get output() {
                        return node.run.getOutput();
                    },
                    onDidAddTestOutput: core_1.Event.map(node.run.onDidChangeTestOutput, evt => evt.map(item => item[1]))
                };
            }
            else if (node instanceof TestItemNode) {
                this.uiModel.selectedOutputSource = {
                    get output() {
                        return node.parent.run.getOutput(node.item);
                    },
                    onDidAddTestOutput: core_1.Event.map(node.parent.run.onDidChangeTestOutput, evt => evt.filter(item => item[0] === node.item).map(item => item[1]))
                };
                this.uiModel.selectedTestState = node.parent.run.getTestState(node.item);
            }
        });
    }
    renderTree(model) {
        if (tree_1.CompositeTreeNode.is(this.model.root) && this.model.root.children.length > 0) {
            return super.renderTree(model);
        }
        return React.createElement("div", { className: 'theia-widget-noInfo noMarkers' }, core_1.nls.localizeByDefault('No tests have been found in this workspace yet.'));
    }
    getTestStateClass(state) {
        switch (state) {
            case test_service_1.TestExecutionState.Queued: return `${(0, browser_1.codicon)('history')} queued`;
            case test_service_1.TestExecutionState.Running: return `${(0, browser_1.codicon)('sync')} codicon-modifier-spin running`;
            case test_service_1.TestExecutionState.Skipped: return `${(0, browser_1.codicon)('debug-step-over')} skipped`;
            case test_service_1.TestExecutionState.Failed: return `${(0, browser_1.codicon)('error')} failed`;
            case test_service_1.TestExecutionState.Errored: return `${(0, browser_1.codicon)('issues')} errored`;
            case test_service_1.TestExecutionState.Passed: return `${(0, browser_1.codicon)('pass')} passed`;
            default: return (0, browser_1.codicon)('circle');
        }
    }
    renderIcon(node, props) {
        var _a;
        if (node instanceof TestItemNode) {
            const state = (_a = node.parent.run.getTestState(node.item)) === null || _a === void 0 ? void 0 : _a.state;
            return React.createElement("div", { className: this.getTestStateClass(state) });
        }
        else if (node instanceof TestRunNode) {
            const icon = node.run.isRunning ? `${(0, browser_1.codicon)('sync')} codicon-modifier-spin running` : (0, browser_1.codicon)('circle');
            return React.createElement("div", { className: icon });
        }
        else {
            return super.renderIcon(node, props);
        }
    }
    toContextMenuArgs(node) {
        if (node instanceof TestRunNode) {
            return [node.run];
        }
        else if (node instanceof TestItemNode) {
            const item = node.item;
            const executionState = node.parent.run.getTestState(node.item);
            if (test_service_1.TestFailure.is(executionState)) {
                return [item, executionState.messages];
            }
            return [item];
        }
        return [];
    }
    storeState() {
        return {}; // don't store any state for now
    }
};
exports.TestRunTreeWidget = TestRunTreeWidget;
TestRunTreeWidget.ID = 'test-run-widget';
tslib_1.__decorate([
    (0, inversify_1.inject)(icon_theme_service_1.IconThemeService),
    tslib_1.__metadata("design:type", icon_theme_service_1.IconThemeService)
], TestRunTreeWidget.prototype, "iconThemeService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], TestRunTreeWidget.prototype, "contextKeys", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(theming_1.ThemeService),
    tslib_1.__metadata("design:type", theming_1.ThemeService)
], TestRunTreeWidget.prototype, "themeService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(test_execution_state_manager_1.TestExecutionStateManager),
    tslib_1.__metadata("design:type", test_execution_state_manager_1.TestExecutionStateManager)
], TestRunTreeWidget.prototype, "stateManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(test_output_ui_model_1.TestOutputUIModel),
    tslib_1.__metadata("design:type", test_output_ui_model_1.TestOutputUIModel)
], TestRunTreeWidget.prototype, "uiModel", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TestRunTreeWidget.prototype, "init", null);
exports.TestRunTreeWidget = TestRunTreeWidget = TestRunTreeWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__param(0, (0, inversify_1.inject)(tree_1.TreeProps)),
    tslib_1.__param(1, (0, inversify_1.inject)(tree_1.TreeModel)),
    tslib_1.__param(2, (0, inversify_1.inject)(browser_1.ContextMenuRenderer)),
    tslib_1.__metadata("design:paramtypes", [Object, Object, browser_1.ContextMenuRenderer])
], TestRunTreeWidget);


/***/ }),

/***/ "../../node_modules/@theia/test/lib/browser/view/test-tree-widget.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@theia/test/lib/browser/view/test-tree-widget.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var TestTreeWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TestTreeWidget = exports.TestTree = exports.TestItemNode = exports.TestControllerNode = exports.TestRoot = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const tree_1 = __webpack_require__(/*! @theia/core/lib/browser/tree */ "../../node_modules/@theia/core/lib/browser/tree/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const icon_theme_service_1 = __webpack_require__(/*! @theia/core/lib/browser/icon-theme-service */ "../../node_modules/@theia/core/lib/browser/icon-theme-service.js");
const theming_1 = __webpack_require__(/*! @theia/core/lib/browser/theming */ "../../node_modules/@theia/core/lib/browser/theming.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
const test_service_1 = __webpack_require__(/*! ../test-service */ "../../node_modules/@theia/test/lib/browser/test-service.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const tree_delta_1 = __webpack_require__(/*! ../../common/tree-delta */ "../../node_modules/@theia/test/lib/common/tree-delta.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const test_execution_state_manager_1 = __webpack_require__(/*! ./test-execution-state-manager */ "../../node_modules/@theia/test/lib/browser/view/test-execution-state-manager.js");
const test_output_ui_model_1 = __webpack_require__(/*! ./test-output-ui-model */ "../../node_modules/@theia/test/lib/browser/view/test-output-ui-model.js");
const test_view_contribution_1 = __webpack_require__(/*! ./test-view-contribution */ "../../node_modules/@theia/test/lib/browser/view/test-view-contribution.js");
const ROOT_ID = 'TestTree';
var TestRoot;
(function (TestRoot) {
    function is(node) {
        return tree_1.CompositeTreeNode.is(node) && node.id === ROOT_ID;
    }
    TestRoot.is = is;
})(TestRoot || (exports.TestRoot = TestRoot = {}));
var TestControllerNode;
(function (TestControllerNode) {
    function is(node) {
        return tree_1.ExpandableTreeNode.is(node) && 'controller' in node;
    }
    TestControllerNode.is = is;
})(TestControllerNode || (exports.TestControllerNode = TestControllerNode = {}));
var TestItemNode;
(function (TestItemNode) {
    function is(node) {
        return tree_1.TreeNode.is(node) && 'testItem' in node;
    }
    TestItemNode.is = is;
})(TestItemNode || (exports.TestItemNode = TestItemNode = {}));
let TestTree = class TestTree extends tree_1.TreeImpl {
    constructor() {
        super(...arguments);
        this.controllerListeners = new Map();
    }
    init() {
        this.testService.getControllers().forEach(controller => this.addController(controller));
        this.testService.onControllersChanged(e => {
            var _a, _b;
            (_a = e.removed) === null || _a === void 0 ? void 0 : _a.forEach(controller => {
                var _a;
                (_a = this.controllerListeners.get(controller)) === null || _a === void 0 ? void 0 : _a.dispose();
            });
            (_b = e.added) === null || _b === void 0 ? void 0 : _b.forEach(controller => this.addController(controller));
            this.refresh(this.root);
        });
    }
    addController(controller) {
        const listeners = new core_1.DisposableCollection();
        this.controllerListeners.set(controller.id, listeners);
        listeners.push(controller.onItemsChanged(delta => {
            this.processDeltas(controller, controller, delta);
        }));
    }
    async resolveChildren(parent) {
        if (TestItemNode.is(parent)) {
            parent.testItem.resolveChildren();
            return Promise.resolve(parent.testItem.tests.map(test => this.createTestNode(parent.controller, parent, test)));
        }
        else if (TestControllerNode.is(parent)) {
            return Promise.resolve(parent.controller.tests.map(test => this.createTestNode(parent.controller, parent, test)));
        }
        else if (TestRoot.is(parent)) {
            return Promise.resolve(this.testService.getControllers().map(controller => this.createControllerNode(parent, controller)));
        }
        else {
            return Promise.resolve([]);
        }
    }
    createControllerNode(parent, controller) {
        const node = {
            id: controller.id,
            name: controller.label,
            controller: controller,
            expanded: false,
            children: [],
            parent: parent
        };
        return node;
    }
    processDeltas(controller, parent, deltas) {
        deltas.forEach(delta => this.processDelta(controller, parent, delta));
    }
    processDelta(controller, parent, delta) {
        if (delta.type === tree_delta_1.DeltaKind.ADDED || delta.type === tree_delta_1.DeltaKind.REMOVED) {
            let node;
            if (parent === controller && delta.path.length === 1) {
                node = this.getNode(this.computeId([controller.id]));
            }
            else {
                const item = this.findInParent(parent, delta.path.slice(0, delta.path.length - 1), 0);
                if (item) {
                    node = this.getNode(this.computeId(this.computePath(controller, item)));
                }
            }
            if (node) {
                this.refresh(node); // we only have composite tree nodes in this tree
            }
            else {
                console.warn('delta for unknown test item');
            }
        }
        else {
            const item = this.findInParent(parent, delta.path, 0);
            if (item) {
                if (delta.type === tree_delta_1.DeltaKind.CHANGED) {
                    this.fireChanged();
                }
                if (delta.childDeltas) {
                    this.processDeltas(controller, item, delta.childDeltas);
                }
            }
            else {
                console.warn('delta for unknown test item');
            }
        }
    }
    findInParent(root, path, startIndex) {
        if (startIndex >= path.length) {
            return root;
        }
        const child = root.tests.find(candidate => candidate.id === path[startIndex]);
        if (!child) {
            return undefined;
        }
        return this.findInParent(child, path, startIndex + 1);
    }
    computePath(controller, item) {
        const result = [controller.id];
        let current = item;
        while (current) {
            result.unshift(current.id);
            current = current.parent;
        }
        return result;
    }
    computeId(path) {
        return path.map(id => id.replace('/', '//')).join('/');
    }
    createTestNode(controller, parent, test) {
        const previous = this.getNode(test.id);
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        const result = {
            id: this.computeId(this.computePath(controller, test)),
            name: test.label,
            controller: controller,
            testItem: test,
            expanded: tree_1.ExpandableTreeNode.is(previous) ? previous.expanded : undefined,
            selected: false,
            children: [],
            parent: parent
        };
        result.children = test.tests.map(t => this.createTestNode(controller, result, t));
        if (result.children.length === 0 && !test.canResolveChildren) {
            delete result.expanded;
        }
        return result;
    }
};
exports.TestTree = TestTree;
tslib_1.__decorate([
    (0, inversify_1.inject)(test_service_1.TestService),
    tslib_1.__metadata("design:type", Object)
], TestTree.prototype, "testService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TestTree.prototype, "init", null);
exports.TestTree = TestTree = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TestTree);
let TestTreeWidget = TestTreeWidget_1 = class TestTreeWidget extends tree_1.TreeWidget {
    constructor(props, model, contextMenuRenderer) {
        super(props, model, contextMenuRenderer);
        this.id = TestTreeWidget_1.ID;
        this.title.label = core_1.nls.localizeByDefault('Test Explorer');
        this.title.caption = core_1.nls.localizeByDefault('Test Explorer');
        this.title.iconClass = (0, browser_1.codicon)('beaker');
        this.title.closable = true;
    }
    init() {
        super.init();
        this.addClass('theia-test-view');
        this.model.root = {
            id: ROOT_ID,
            parent: undefined,
            visible: false,
            children: []
        };
        this.uiModel.onDidChangeActiveTestRun(e => this.update());
        this.uiModel.onDidChangeActiveTestState(() => this.update());
        this.model.onSelectionChanged(() => {
            const that = this;
            const node = this.model.selectedNodes[0];
            if (TestItemNode.is(node)) {
                const run = that.uiModel.getActiveTestRun(node.controller);
                if (run) {
                    const output = run === null || run === void 0 ? void 0 : run.getOutput(node.testItem);
                    if (output) {
                        this.uiModel.selectedOutputSource = {
                            output: output,
                            onDidAddTestOutput: core_1.Event.map(run.onDidChangeTestOutput, evt => evt.filter(item => item[0] === node.testItem).map(item => item[1]))
                        };
                    }
                    this.uiModel.selectedTestState = run.getTestState(node.testItem);
                }
            }
        });
    }
    renderTree(model) {
        if (TestRoot.is(model.root) && model.root.children.length > 0) {
            return super.renderTree(model);
        }
        return React.createElement("div", { className: 'theia-widget-noInfo noMarkers' }, core_1.nls.localizeByDefault('No tests have been found in this workspace yet.'));
    }
    getTestStateClass(state) {
        switch (state) {
            case test_service_1.TestExecutionState.Queued: return `${(0, browser_1.codicon)('history')} queued`;
            case test_service_1.TestExecutionState.Running: return `${(0, browser_1.codicon)('sync')} codicon-modifier-spin running`;
            case test_service_1.TestExecutionState.Skipped: return `${(0, browser_1.codicon)('debug-step-over')} skipped`;
            case test_service_1.TestExecutionState.Failed: return `${(0, browser_1.codicon)('error')} failed`;
            case test_service_1.TestExecutionState.Errored: return `${(0, browser_1.codicon)('issues')} errored`;
            case test_service_1.TestExecutionState.Passed: return `${(0, browser_1.codicon)('pass')} passed`;
            case test_service_1.TestExecutionState.Running: return `${(0, browser_1.codicon)('sync-spin')} running`;
            default: return (0, browser_1.codicon)('circle');
        }
    }
    renderIcon(node, props) {
        var _a;
        if (TestItemNode.is(node)) {
            const currentRun = this.uiModel.getActiveTestRun(node.controller);
            let state;
            if (currentRun) {
                state = (_a = currentRun.getTestState(node.testItem)) === null || _a === void 0 ? void 0 : _a.state;
                if (!state) {
                    state = this.stateManager.getComputedState(currentRun, node.testItem);
                }
            }
            return React.createElement("div", { className: this.getTestStateClass(state) });
        }
        else {
            return super.renderIcon(node, props);
        }
    }
    renderTailDecorations(node, props) {
        if (TestItemNode.is(node)) {
            const testItem = node.testItem;
            return this.contextKeys.with({ view: this.id, controllerId: node.controller.id, testId: testItem.id, testItemHasUri: !!testItem.uri }, () => {
                const menu = this.menus.getMenu(test_view_contribution_1.TEST_VIEW_INLINE_MENU);
                const args = [node.testItem];
                const inlineCommands = menu.children.filter((item) => item instanceof core_1.ActionMenuNode);
                const tailDecorations = super.renderTailDecorations(node, props);
                return React.createElement(React.Fragment, null,
                    inlineCommands.length > 0 && React.createElement("div", { className: tree_1.TREE_NODE_SEGMENT_CLASS + ' flex' }, inlineCommands.map((item, index) => this.renderInlineCommand(item, index, this.focusService.hasFocus(node), args))),
                    tailDecorations !== undefined && React.createElement("div", { className: tree_1.TREE_NODE_SEGMENT_CLASS + ' flex' }, tailDecorations));
            });
        }
        else {
            return super.renderTailDecorations(node, props);
        }
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    renderInlineCommand(actionMenuNode, index, tabbable, args) {
        if (!actionMenuNode.icon || !this.commands.isVisible(actionMenuNode.command, ...args) || (actionMenuNode.when && !this.contextKeys.match(actionMenuNode.when))) {
            return false;
        }
        const className = [tree_1.TREE_NODE_SEGMENT_CLASS, tree_1.TREE_NODE_TAIL_CLASS, actionMenuNode.icon, browser_1.ACTION_ITEM, 'theia-test-tree-inline-action'].join(' ');
        const tabIndex = tabbable ? 0 : undefined;
        const titleString = actionMenuNode.label + this.resolveKeybindingForCommand(actionMenuNode.command);
        return React.createElement("div", { key: index, className: className, title: titleString, tabIndex: tabIndex, onClick: e => {
                e.stopPropagation();
                this.commands.executeCommand(actionMenuNode.command, ...args);
            } });
    }
    resolveKeybindingForCommand(command) {
        let result = '';
        if (command) {
            const bindings = this.keybindings.getKeybindingsForCommand(command);
            let found = false;
            if (bindings && bindings.length > 0) {
                bindings.forEach(binding => {
                    if (!found && this.keybindings.isEnabledInScope(binding, this.node)) {
                        found = true;
                        result = ` (${this.keybindings.acceleratorFor(binding, '+')})`;
                    }
                });
            }
        }
        return result;
    }
    toContextMenuArgs(node) {
        if (TestItemNode.is(node)) {
            return [node.testItem];
        }
        return [];
    }
    storeState() {
        return {}; // don't store any state for now
    }
};
exports.TestTreeWidget = TestTreeWidget;
TestTreeWidget.ID = 'test-tree-widget';
TestTreeWidget.TEST_CONTEXT_MENU = ['RESOURCE_CONTEXT_MENU'];
tslib_1.__decorate([
    (0, inversify_1.inject)(icon_theme_service_1.IconThemeService),
    tslib_1.__metadata("design:type", icon_theme_service_1.IconThemeService)
], TestTreeWidget.prototype, "iconThemeService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], TestTreeWidget.prototype, "contextKeys", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(theming_1.ThemeService),
    tslib_1.__metadata("design:type", theming_1.ThemeService)
], TestTreeWidget.prototype, "themeService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(test_execution_state_manager_1.TestExecutionStateManager),
    tslib_1.__metadata("design:type", test_execution_state_manager_1.TestExecutionStateManager)
], TestTreeWidget.prototype, "stateManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(test_output_ui_model_1.TestOutputUIModel),
    tslib_1.__metadata("design:type", test_output_ui_model_1.TestOutputUIModel)
], TestTreeWidget.prototype, "uiModel", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.MenuModelRegistry),
    tslib_1.__metadata("design:type", core_1.MenuModelRegistry)
], TestTreeWidget.prototype, "menus", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.CommandRegistry),
    tslib_1.__metadata("design:type", core_1.CommandRegistry)
], TestTreeWidget.prototype, "commands", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.KeybindingRegistry),
    tslib_1.__metadata("design:type", browser_1.KeybindingRegistry)
], TestTreeWidget.prototype, "keybindings", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TestTreeWidget.prototype, "init", null);
exports.TestTreeWidget = TestTreeWidget = TestTreeWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__param(0, (0, inversify_1.inject)(tree_1.TreeProps)),
    tslib_1.__param(1, (0, inversify_1.inject)(tree_1.TreeModel)),
    tslib_1.__param(2, (0, inversify_1.inject)(browser_1.ContextMenuRenderer)),
    tslib_1.__metadata("design:paramtypes", [Object, Object, browser_1.ContextMenuRenderer])
], TestTreeWidget);


/***/ }),

/***/ "../../node_modules/@theia/test/lib/browser/view/test-view-contribution.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@theia/test/lib/browser/view/test-view-contribution.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TestViewContribution = exports.TEST_VIEW_CONTAINER_TITLE_OPTIONS = exports.TEST_VIEW_CONTAINER_ID = exports.TEST_VIEW_INLINE_MENU = exports.TEST_VIEW_CONTEXT_MENU = exports.TestViewCommands = exports.PLUGIN_TEST_VIEW_TITLE_MENU = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const test_service_1 = __webpack_require__(/*! ../test-service */ "../../node_modules/@theia/test/lib/browser/test-service.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
const test_tree_widget_1 = __webpack_require__(/*! ./test-tree-widget */ "../../node_modules/@theia/test/lib/browser/view/test-tree-widget.js");
const navigation_location_service_1 = __webpack_require__(/*! @theia/editor/lib/browser/navigation/navigation-location-service */ "../../node_modules/@theia/editor/lib/browser/navigation/navigation-location-service.js");
const navigation_location_1 = __webpack_require__(/*! @theia/editor/lib/browser/navigation/navigation-location */ "../../node_modules/@theia/editor/lib/browser/navigation/navigation-location.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const file_navigator_commands_1 = __webpack_require__(/*! @theia/navigator/lib/browser/file-navigator-commands */ "../../node_modules/@theia/navigator/lib/browser/file-navigator-commands.js");
exports.PLUGIN_TEST_VIEW_TITLE_MENU = ['plugin_test', 'title'];
var TestViewCommands;
(function (TestViewCommands) {
    /**
     * Command which refreshes all test.
     */
    TestViewCommands.REFRESH = core_1.Command.toDefaultLocalizedCommand({
        id: "testing.refreshTests" /* TestCommandId.RefreshTestsAction */,
        label: 'Refresh Tests',
        category: 'Test',
        iconClass: (0, browser_1.codicon)('refresh')
    });
    /**
     * Command which cancels the refresh
     */
    TestViewCommands.CANCEL_REFRESH = core_1.Command.toDefaultLocalizedCommand({
        id: "testing.cancelTestRefresh" /* TestCommandId.CancelTestRefreshAction */,
        label: 'Cancel Test Refresh',
        category: 'Test',
        iconClass: (0, browser_1.codicon)('stop')
    });
    TestViewCommands.RUN_ALL_TESTS = core_1.Command.toDefaultLocalizedCommand({
        id: "testing.runAll" /* TestCommandId.RunAllAction */,
        label: 'Run All Tests',
        category: 'Test',
        iconClass: (0, browser_1.codicon)('run-all')
    });
    TestViewCommands.DEBUG_ALL_TESTS = core_1.Command.toDefaultLocalizedCommand({
        id: "testing.debugAll" /* TestCommandId.DebugAllAction */,
        label: 'Debug Tests',
        category: 'Test',
        iconClass: (0, browser_1.codicon)('debug-all')
    });
    TestViewCommands.RUN_TEST = core_1.Command.toDefaultLocalizedCommand({
        id: "testing.run" /* TestCommandId.RunAction */,
        label: 'Run Test',
        category: 'Test',
        iconClass: (0, browser_1.codicon)('run')
    });
    TestViewCommands.RUN_TEST_WITH_PROFILE = core_1.Command.toDefaultLocalizedCommand({
        id: "testing.runUsing" /* TestCommandId.RunUsingProfileAction */,
        category: 'Test',
        label: 'Execute using Profile...'
    });
    TestViewCommands.DEBUG_TEST = core_1.Command.toDefaultLocalizedCommand({
        id: "testing.debug" /* TestCommandId.DebugAction */,
        label: 'Debug Test',
        category: 'Test',
        iconClass: (0, browser_1.codicon)('debug-alt')
    });
    TestViewCommands.CANCEL_ALL_RUNS = core_1.Command.toLocalizedCommand({
        id: 'testing.cancelAllRuns',
        label: 'Cancel All Test Runs',
        category: 'Test',
        iconClass: (0, browser_1.codicon)('debug-stop')
    }, 'theia/test/cancelAllTestRuns', core_1.nls.getDefaultKey('Test'));
    TestViewCommands.CANCEL_RUN = core_1.Command.toDefaultLocalizedCommand({
        id: "testing.cancelRun" /* TestCommandId.CancelTestRunAction */,
        label: 'Cancel Test Run',
        category: 'Test',
        iconClass: (0, browser_1.codicon)('debug-stop')
    });
    TestViewCommands.GOTO_TEST = core_1.Command.toDefaultLocalizedCommand({
        id: "testing.editFocusedTest" /* TestCommandId.GoToTest */,
        label: 'Go to Test',
        category: 'Test',
        iconClass: (0, browser_1.codicon)('go-to-file')
    });
    TestViewCommands.CONFIGURE_PROFILES = core_1.Command.toDefaultLocalizedCommand({
        id: "testing.configureProfile" /* TestCommandId.ConfigureTestProfilesAction */,
        label: 'Configure Test Profiles',
        category: 'Test'
    });
    TestViewCommands.SELECT_DEFAULT_PROFILES = core_1.Command.toDefaultLocalizedCommand({
        id: "testing.selectDefaultTestProfiles" /* TestCommandId.SelectDefaultTestProfiles */,
        label: 'Select Default Profile',
        category: 'Test'
    });
    TestViewCommands.CLEAR_ALL_RESULTS = core_1.Command.toDefaultLocalizedCommand({
        id: "testing.clearTestResults" /* TestCommandId.ClearTestResultsAction */,
        label: 'Clear All Results',
        category: 'Test',
        iconClass: (0, browser_1.codicon)('trash')
    });
})(TestViewCommands || (exports.TestViewCommands = TestViewCommands = {}));
exports.TEST_VIEW_CONTEXT_MENU = ['test-view-context-menu'];
exports.TEST_VIEW_INLINE_MENU = [...exports.TEST_VIEW_CONTEXT_MENU, 'inline'];
exports.TEST_VIEW_CONTAINER_ID = 'test-view-container';
exports.TEST_VIEW_CONTAINER_TITLE_OPTIONS = {
    label: core_1.nls.localizeByDefault('Testing'),
    iconClass: (0, browser_1.codicon)('beaker'),
    closeable: true
};
let TestViewContribution = class TestViewContribution extends browser_1.AbstractViewContribution {
    constructor() {
        super({
            viewContainerId: exports.TEST_VIEW_CONTAINER_ID,
            widgetId: test_tree_widget_1.TestTreeWidget.ID,
            widgetName: core_1.nls.localizeByDefault('Test Explorer'),
            defaultWidgetOptions: {
                area: 'left',
                rank: 600,
            }
        });
    }
    async initializeLayout() {
        await this.openView({ activate: false });
    }
    registerCommands(commands) {
        super.registerCommands(commands);
        commands.registerCommand(TestViewCommands.REFRESH, {
            isEnabled: w => this.withWidget(w, () => !this.testService.isRefreshing),
            isVisible: w => this.withWidget(w, () => !this.testService.isRefreshing),
            execute: () => this.testService.refresh()
        });
        commands.registerCommand(TestViewCommands.CANCEL_REFRESH, {
            isEnabled: w => this.withWidget(w, () => this.testService.isRefreshing),
            isVisible: w => this.withWidget(w, () => this.testService.isRefreshing),
            execute: () => this.testService.cancelRefresh()
        });
        commands.registerCommand(TestViewCommands.RUN_ALL_TESTS, {
            isEnabled: w => this.withWidget(w, () => true),
            isVisible: w => this.withWidget(w, () => true),
            execute: () => this.testService.runAllTests(test_service_1.TestRunProfileKind.Run)
        });
        commands.registerCommand(TestViewCommands.DEBUG_ALL_TESTS, {
            isEnabled: w => this.withWidget(w, () => true),
            isVisible: w => this.withWidget(w, () => true),
            execute: () => this.testService.runAllTests(test_service_1.TestRunProfileKind.Debug)
        });
        commands.registerCommand(TestViewCommands.RUN_TEST, {
            isEnabled: t => test_service_1.TestItem.is(t),
            isVisible: t => test_service_1.TestItem.is(t),
            execute: t => {
                this.testService.runTests(test_service_1.TestRunProfileKind.Run, [t]);
            }
        });
        commands.registerCommand(TestViewCommands.SELECT_DEFAULT_PROFILES, {
            isEnabled: t => test_service_1.TestItem.is(t),
            isVisible: t => test_service_1.TestItem.is(t),
            execute: () => {
                this.testService.selectDefaultProfile();
            }
        });
        commands.registerCommand(TestViewCommands.DEBUG_TEST, {
            isEnabled: t => test_service_1.TestItem.is(t),
            isVisible: t => test_service_1.TestItem.is(t),
            execute: t => {
                this.testService.runTests(test_service_1.TestRunProfileKind.Debug, [t]);
            }
        });
        commands.registerCommand(TestViewCommands.RUN_TEST_WITH_PROFILE, {
            isEnabled: t => test_service_1.TestItem.is(t),
            isVisible: t => test_service_1.TestItem.is(t),
            execute: t => {
                this.testService.runTestsWithProfile([t]);
            }
        });
        commands.registerCommand(TestViewCommands.CANCEL_ALL_RUNS, {
            isEnabled: w => this.withWidget(w, () => true),
            isVisible: w => this.withWidget(w, () => true),
            execute: () => this.cancelAllRuns()
        });
        commands.registerCommand(TestViewCommands.GOTO_TEST, {
            isEnabled: t => test_service_1.TestItem.is(t) && !!t.uri,
            isVisible: t => test_service_1.TestItem.is(t) && !!t.uri,
            execute: t => {
                if (test_service_1.TestItem.is(t)) {
                    this.fileSystem.resolve(t.uri).then(stat => {
                        if (stat.isFile) {
                            this.navigationService.reveal(navigation_location_1.NavigationLocation.create(t.uri, t.range ? t.range.start : { line: 0, character: 0 }));
                        }
                        else {
                            commands.executeCommand(file_navigator_commands_1.FileNavigatorCommands.REVEAL_IN_NAVIGATOR.id, t.uri);
                        }
                    });
                }
            }
        });
        commands.registerCommand(TestViewCommands.CONFIGURE_PROFILES, {
            execute: () => {
                this.testService.configureProfile();
            }
        });
    }
    cancelAllRuns() {
        this.testService.getControllers().forEach(controller => controller.testRuns.forEach(run => run.cancel()));
    }
    registerMenus(menus) {
        super.registerMenus(menus);
        menus.registerMenuAction(exports.TEST_VIEW_INLINE_MENU, {
            commandId: TestViewCommands.RUN_TEST.id,
            order: 'a'
        });
        menus.registerMenuAction(exports.TEST_VIEW_INLINE_MENU, {
            commandId: TestViewCommands.DEBUG_TEST.id,
            order: 'aa'
        });
        menus.registerMenuAction(exports.TEST_VIEW_INLINE_MENU, {
            commandId: TestViewCommands.GOTO_TEST.id,
            order: 'aaa'
        });
        menus.registerMenuAction(exports.TEST_VIEW_CONTEXT_MENU, {
            commandId: TestViewCommands.RUN_TEST_WITH_PROFILE.id,
            order: 'aaaa'
        });
        menus.registerMenuAction(exports.TEST_VIEW_CONTEXT_MENU, {
            commandId: TestViewCommands.SELECT_DEFAULT_PROFILES.id,
            order: 'aaaaa'
        });
    }
    registerToolbarItems(toolbar) {
        toolbar.registerItem({
            id: TestViewCommands.REFRESH.id,
            command: TestViewCommands.REFRESH.id,
            priority: 0,
            onDidChange: this.testService.onDidChangeIsRefreshing
        });
        toolbar.registerItem({
            id: TestViewCommands.CANCEL_REFRESH.id,
            command: TestViewCommands.CANCEL_REFRESH.id,
            priority: 0,
            onDidChange: this.testService.onDidChangeIsRefreshing
        });
        toolbar.registerItem({
            id: TestViewCommands.RUN_ALL_TESTS.id,
            command: TestViewCommands.RUN_ALL_TESTS.id,
            menuPath: exports.PLUGIN_TEST_VIEW_TITLE_MENU,
            contextKeyOverlays: {
                'testing.profile.context.group': 'run'
            },
            priority: 1
        });
        toolbar.registerItem({
            id: TestViewCommands.DEBUG_ALL_TESTS.id,
            command: TestViewCommands.DEBUG_ALL_TESTS.id,
            menuPath: exports.PLUGIN_TEST_VIEW_TITLE_MENU,
            contextKeyOverlays: {
                'testing.profile.context.group': 'debug'
            },
            priority: 2
        });
        toolbar.registerItem({
            id: TestViewCommands.CANCEL_ALL_RUNS.id,
            command: TestViewCommands.CANCEL_ALL_RUNS.id,
            priority: 3
        });
    }
    withWidget(widget = this.tryGetWidget(), cb) {
        if (widget instanceof test_tree_widget_1.TestTreeWidget && widget.id === test_tree_widget_1.TestTreeWidget.ID) {
            return cb(widget);
        }
        return false;
    }
};
exports.TestViewContribution = TestViewContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(test_service_1.TestService),
    tslib_1.__metadata("design:type", Object)
], TestViewContribution.prototype, "testService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], TestViewContribution.prototype, "contextKeys", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(navigation_location_service_1.NavigationLocationService),
    tslib_1.__metadata("design:type", navigation_location_service_1.NavigationLocationService)
], TestViewContribution.prototype, "navigationService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], TestViewContribution.prototype, "fileSystem", void 0);
exports.TestViewContribution = TestViewContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], TestViewContribution);


/***/ }),

/***/ "../../node_modules/@theia/test/lib/common/tree-delta.js":
/*!***************************************************************!*\
  !*** ../../node_modules/@theia/test/lib/common/tree-delta.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2022 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AccumulatingTreeDeltaEmitter = exports.TreeDeltaBuilderImpl = exports.MappingTreeDeltaBuilder = exports.DeltaKind = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const collections_1 = __webpack_require__(/*! ./collections */ "../../node_modules/@theia/test/lib/common/collections.js");
var DeltaKind;
(function (DeltaKind) {
    DeltaKind[DeltaKind["NONE"] = 0] = "NONE";
    DeltaKind[DeltaKind["ADDED"] = 1] = "ADDED";
    DeltaKind[DeltaKind["REMOVED"] = 2] = "REMOVED";
    DeltaKind[DeltaKind["CHANGED"] = 3] = "CHANGED";
})(DeltaKind || (exports.DeltaKind = DeltaKind = {}));
class MappingTreeDeltaBuilder {
    constructor(wrapped, map, mapPartial) {
        this.wrapped = wrapped;
        this.map = map;
        this.mapPartial = mapPartial;
    }
    reportAdded(path, added) {
        this.wrapped.reportAdded(path, this.map(added));
    }
    reportRemoved(path) {
        this.wrapped.reportRemoved(path);
    }
    reportChanged(path, change) {
        this.wrapped.reportChanged(path, this.mapPartial(change));
    }
}
exports.MappingTreeDeltaBuilder = MappingTreeDeltaBuilder;
class TreeDeltaBuilderImpl {
    constructor() {
        this._currentDelta = [];
    }
    get currentDelta() {
        return this._currentDelta;
    }
    reportAdded(path, added) {
        this.findNode(path, (parentCollection, nodeIndex, residual) => {
            if (residual.length === 0) {
                // we matched an exact node
                const child = parentCollection[nodeIndex];
                if (child.type === DeltaKind.REMOVED) {
                    child.type = DeltaKind.CHANGED;
                }
                else if (child.type === DeltaKind.NONE) {
                    child.type = DeltaKind.ADDED;
                }
                child.value = added;
            }
            else {
                this.insert(parentCollection, nodeIndex, {
                    path: residual,
                    type: DeltaKind.ADDED,
                    value: added,
                });
            }
        });
    }
    reportRemoved(path) {
        this.findNode(path, (parentCollection, nodeIndex, residual) => {
            if (residual.length === 0) {
                // we matched an exact node
                const child = parentCollection[nodeIndex];
                if (child.type === DeltaKind.CHANGED) {
                    child.type = DeltaKind.REMOVED;
                    delete child.value;
                }
                else if (child.type === DeltaKind.ADDED) {
                    parentCollection.splice(nodeIndex, 1);
                }
                else if (child.type === DeltaKind.NONE) {
                    child.type = DeltaKind.REMOVED;
                }
            }
            else {
                this.insert(parentCollection, nodeIndex, {
                    path: residual,
                    type: DeltaKind.REMOVED,
                });
            }
        });
    }
    reportChanged(path, change) {
        this.findNode(path, (parentCollection, nodeIndex, residual) => {
            if (residual.length === 0) {
                // we matched an exact node
                const child = parentCollection[nodeIndex];
                if (child.type === DeltaKind.NONE) {
                    child.type = DeltaKind.CHANGED;
                    child.value = change;
                }
                else if (child.type === DeltaKind.CHANGED) {
                    Object.assign(child.value, change);
                }
            }
            else {
                this.insert(parentCollection, nodeIndex, {
                    path: residual,
                    type: DeltaKind.CHANGED,
                    value: change,
                });
            }
        });
    }
    insert(parentCollection, nodeIndex, delta) {
        if (nodeIndex < 0) {
            parentCollection.push(delta);
        }
        else {
            const child = parentCollection[nodeIndex];
            const prefixLength = computePrefixLength(delta.path, child.path);
            if (prefixLength === delta.path.length) {
                child.path = child.path.slice(prefixLength);
                delta.childDeltas = [child];
                parentCollection[nodeIndex] = delta;
            }
            else {
                const newNode = {
                    path: child.path.slice(0, prefixLength),
                    type: DeltaKind.NONE,
                    childDeltas: []
                };
                parentCollection[nodeIndex] = newNode;
                delta.path = delta.path.slice(prefixLength);
                newNode.childDeltas.push(delta);
                child.path = child.path.slice(prefixLength);
                newNode.childDeltas.push(child);
                if (newNode.path.length === 0) {
                    console.log('newNode');
                }
            }
            if (delta.path.length === 0) {
                console.log('delta');
            }
            if (child.path.length === 0) {
                console.log('child');
            }
        }
    }
    findNode(path, handler) {
        doFindNode(this._currentDelta, path, handler);
    }
}
exports.TreeDeltaBuilderImpl = TreeDeltaBuilderImpl;
function doFindNode(rootCollection, path, handler) {
    // handler parameters:
    // parent collection: the collection the node index refers to, if valid
    // nodeIndex: the index of the node that has a common path prefix with the path of the path we're searching
    // residual path: the path that has not been consumed looking for the path: if empty, we found the exact node
    let commonPrefixLength = 0;
    const childIndex = rootCollection.findIndex(delta => {
        commonPrefixLength = computePrefixLength(delta.path, path);
        return commonPrefixLength > 0;
    });
    if (childIndex >= 0) {
        // we know which child to insert into
        const child = rootCollection[childIndex];
        if (commonPrefixLength === child.path.length) {
            // we matched a child
            if (commonPrefixLength === path.length) {
                // it's an exact match: we already have a node for the given path
                handler(rootCollection, childIndex, []);
                return;
            }
            // we know the node is below the child
            if (child.type === DeltaKind.REMOVED || child.type === DeltaKind.ADDED) {
                // there will be no children deltas beneath added/remove nodes
                return;
            }
            if (!child.childDeltas) {
                child.childDeltas = [];
            }
            doFindNode(child.childDeltas, path.slice(child.path.length), handler);
        }
        else {
            handler(rootCollection, childIndex, path);
        }
    }
    else {
        // we have no node to insert into
        handler(rootCollection, -1, path);
    }
}
function computePrefixLength(left, right) {
    let i = 0;
    while (i < left.length && i < right.length && left[i] === right[i]) {
        i++;
    }
    return i;
}
class AccumulatingTreeDeltaEmitter extends TreeDeltaBuilderImpl {
    constructor(timeoutMillis) {
        super();
        this.onDidFlushEmitter = new core_1.Emitter();
        this.onDidFlush = this.onDidFlushEmitter.event;
        this.batcher = new collections_1.ChangeBatcher(() => this.doEmitDelta(), timeoutMillis);
    }
    flush() {
        this.batcher.flush();
    }
    doEmitDelta() {
        const batch = this._currentDelta;
        this._currentDelta = [];
        this.onDidFlushEmitter.fire(batch);
    }
    reportAdded(path, added) {
        super.reportAdded(path, added);
        // console.debug(`reported added, now: ${JSON.stringify(path, undefined, 3)}`);
        // logging levels don't work in plugin host: https://github.com/eclipse-theia/theia/issues/12234
        this.batcher.changeOccurred();
    }
    reportChanged(path, change) {
        super.reportChanged(path, change);
        // console.debug(`reported changed, now: ${JSON.stringify(path, undefined, 3)}`);
        // logging levels don't work in plugin host: https://github.com/eclipse-theia/theia/issues/12234
        this.batcher.changeOccurred();
    }
    reportRemoved(path) {
        super.reportRemoved(path);
        // console.debug(`reported removed, now: ${JSON.stringify(path, undefined, 3)}`);
        // logging levels don't work in plugin host: https://github.com/eclipse-theia/theia/issues/12234
        this.batcher.changeOccurred();
    }
}
exports.AccumulatingTreeDeltaEmitter = AccumulatingTreeDeltaEmitter;


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_test_lib_browser_view_test-run-view-contribution_js.js.map