(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_terminal_lib_browser_terminal-widget-impl_js"],{

/***/ "../../node_modules/@theia/terminal/lib/browser/base/terminal-widget.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/browser/base/terminal-widget.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalWidgetOptions = exports.TerminalWidget = exports.TerminalLocation = void 0;
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
var TerminalLocation;
(function (TerminalLocation) {
    TerminalLocation[TerminalLocation["Panel"] = 1] = "Panel";
    TerminalLocation[TerminalLocation["Editor"] = 2] = "Editor";
})(TerminalLocation || (exports.TerminalLocation = TerminalLocation = {}));
/**
 * Terminal UI widget.
 */
class TerminalWidget extends browser_1.BaseWidget {
}
exports.TerminalWidget = TerminalWidget;
/**
 * Terminal widget options.
 */
exports.TerminalWidgetOptions = Symbol('TerminalWidgetOptions');


/***/ }),

/***/ "../../node_modules/@theia/terminal/lib/browser/search/terminal-search-widget.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/browser/search/terminal-search-widget.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2019 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalSearchWidget = exports.TerminalSearchWidgetFactory = exports.TERMINAL_SEARCH_WIDGET_FACTORY_ID = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const react_widget_1 = __webpack_require__(/*! @theia/core/lib/browser/widgets/react-widget */ "../../node_modules/@theia/core/lib/browser/widgets/react-widget.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
__webpack_require__(/*! ../../../src/browser/style/terminal-search.css */ "../../node_modules/@theia/terminal/src/browser/style/terminal-search.css");
const xterm_1 = __webpack_require__(/*! xterm */ "../../node_modules/xterm/lib/xterm.js");
const xterm_addon_search_1 = __webpack_require__(/*! xterm-addon-search */ "../../node_modules/xterm-addon-search/lib/xterm-addon-search.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
exports.TERMINAL_SEARCH_WIDGET_FACTORY_ID = 'terminal-search';
exports.TerminalSearchWidgetFactory = Symbol('TerminalSearchWidgetFactory');
let TerminalSearchWidget = class TerminalSearchWidget extends react_widget_1.ReactWidget {
    constructor() {
        super(...arguments);
        this.searchOptions = {};
        this.onSearchInputFocus = () => {
            if (this.searchBox) {
                this.searchBox.classList.add('focused');
            }
        };
        this.onSearchInputBlur = () => {
            if (this.searchBox) {
                this.searchBox.classList.remove('focused');
            }
        };
        this.handleHide = () => {
            this.hide();
        };
        this.handleCaseSensitiveOptionClicked = (event) => {
            this.searchOptions.caseSensitive = !this.searchOptions.caseSensitive;
            this.updateSearchInputBox(this.searchOptions.caseSensitive, event.currentTarget);
        };
        this.handleWholeWordOptionClicked = (event) => {
            this.searchOptions.wholeWord = !this.searchOptions.wholeWord;
            this.updateSearchInputBox(this.searchOptions.wholeWord, event.currentTarget);
        };
        this.handleRegexOptionClicked = (event) => {
            this.searchOptions.regex = !this.searchOptions.regex;
            this.updateSearchInputBox(this.searchOptions.regex, event.currentTarget);
        };
        this.onInputChanged = (event) => {
            // move to previous search result on `Shift + Enter`
            if (event && event.shiftKey && event.keyCode === browser_1.Key.ENTER.keyCode) {
                this.search(false, 'previous');
                return;
            }
            // move to next search result on `Enter`
            if (event && event.keyCode === browser_1.Key.ENTER.keyCode) {
                this.search(false, 'next');
                return;
            }
            this.search(true, 'next');
        };
        this.handleNextButtonClicked = () => {
            this.search(false, 'next');
        };
        this.handlePreviousButtonClicked = () => {
            this.search(false, 'previous');
        };
    }
    init() {
        this.node.classList.add('theia-search-terminal-widget-parent');
        this.searchAddon = new xterm_addon_search_1.SearchAddon();
        this.terminal.loadAddon(this.searchAddon);
        this.hide();
        this.update();
    }
    render() {
        return React.createElement("div", { className: 'theia-search-terminal-widget' },
            React.createElement("div", { className: 'theia-search-elem-box', ref: searchBox => this.searchBox = searchBox },
                React.createElement("input", { title: 'Find', type: 'text', spellCheck: 'false', placeholder: 'Find', ref: ip => this.searchInput = ip, onKeyUp: this.onInputChanged, onFocus: this.onSearchInputFocus, onBlur: this.onSearchInputBlur }),
                React.createElement("div", { title: 'Match case', tabIndex: 0, className: 'search-elem ' + (0, browser_1.codicon)('case-sensitive'), onClick: this.handleCaseSensitiveOptionClicked }),
                React.createElement("div", { title: 'Match whole word', tabIndex: 0, className: 'search-elem ' + (0, browser_1.codicon)('whole-word'), onClick: this.handleWholeWordOptionClicked }),
                React.createElement("div", { title: 'Use regular expression', tabIndex: 0, className: 'search-elem ' + (0, browser_1.codicon)('regex'), onClick: this.handleRegexOptionClicked })),
            React.createElement("button", { title: 'Previous match', className: 'search-elem ' + (0, browser_1.codicon)('arrow-up'), onClick: this.handlePreviousButtonClicked }),
            React.createElement("button", { title: 'Next match', className: 'search-elem ' + (0, browser_1.codicon)('arrow-down'), onClick: this.handleNextButtonClicked }),
            React.createElement("button", { title: 'Close', className: 'search-elem ' + (0, browser_1.codicon)('close'), onClick: this.handleHide }));
    }
    updateSearchInputBox(enable, optionElement) {
        if (enable) {
            optionElement.classList.add('option-enabled');
        }
        else {
            optionElement.classList.remove('option-enabled');
        }
        this.searchInput.focus();
    }
    search(incremental, searchDirection) {
        if (this.searchInput) {
            this.searchOptions.incremental = incremental;
            const searchText = this.searchInput.value;
            if (searchDirection === 'next') {
                this.searchAddon.findNext(searchText, this.searchOptions);
            }
            if (searchDirection === 'previous') {
                this.searchAddon.findPrevious(searchText, this.searchOptions);
            }
        }
    }
    onAfterHide() {
        this.terminal.focus();
    }
    onAfterShow() {
        if (this.searchInput) {
            this.searchInput.select();
        }
    }
};
exports.TerminalSearchWidget = TerminalSearchWidget;
tslib_1.__decorate([
    (0, inversify_1.inject)(xterm_1.Terminal),
    tslib_1.__metadata("design:type", xterm_1.Terminal)
], TerminalSearchWidget.prototype, "terminal", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TerminalSearchWidget.prototype, "init", null);
exports.TerminalSearchWidget = TerminalSearchWidget = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TerminalSearchWidget);


/***/ }),

/***/ "../../node_modules/@theia/terminal/lib/browser/shell-terminal-profile.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/browser/shell-terminal-profile.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2022 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ShellTerminalProfile = void 0;
class ShellTerminalProfile {
    get shellPath() {
        return this.options.shellPath;
    }
    constructor(terminalService, options) {
        this.terminalService = terminalService;
        this.options = options;
    }
    async start() {
        const widget = await this.terminalService.newTerminal(this.options);
        widget.start();
        return widget;
    }
    /**
     * Makes a copy of this profile modified with the options given
     * as an argument.
     * @param options the options to override
     * @returns a modified copy of this profile
     */
    modify(options) {
        return new ShellTerminalProfile(this.terminalService, { ...this.options, ...options });
    }
}
exports.ShellTerminalProfile = ShellTerminalProfile;


/***/ }),

/***/ "../../node_modules/@theia/terminal/lib/browser/terminal-copy-on-selection-handler.js":
/*!********************************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/browser/terminal-copy-on-selection-handler.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2019 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalCopyOnSelectionHandler = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
let TerminalCopyOnSelectionHandler = class TerminalCopyOnSelectionHandler {
    constructor() {
        this.copyListener = (ev) => {
            if (this.interceptCopy && ev.clipboardData) {
                ev.clipboardData.setData('text/plain', this.textToCopy);
                ev.preventDefault();
            }
        };
    }
    init() {
        document.addEventListener('copy', this.copyListener);
    }
    async clipBoardCopyIsGranted() {
        // Unfortunately Firefox doesn't support permission check `clipboard-write`, so let try to copy anyway,
        if (browser_1.isFirefox) {
            return true;
        }
        try {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            const permissions = navigator.permissions;
            const { state } = await permissions.query({ name: 'clipboard-write' });
            if (state === 'granted') {
                return true;
            }
        }
        catch (e) { }
        return false;
    }
    executeCommandCopy() {
        try {
            this.interceptCopy = true;
            document.execCommand('copy');
            this.interceptCopy = false;
        }
        catch (e) {
            // do nothing
        }
    }
    async writeToClipBoard() {
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        const clipboard = navigator.clipboard;
        if (!clipboard) {
            this.executeCommandCopy();
            return;
        }
        try {
            await clipboard.writeText(this.textToCopy);
        }
        catch (e) {
            this.executeCommandCopy();
        }
    }
    async copy(text) {
        this.textToCopy = text;
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        const permissions = navigator.permissions;
        if (permissions && permissions.query && await this.clipBoardCopyIsGranted()) {
            await this.writeToClipBoard();
        }
        else {
            this.executeCommandCopy();
        }
    }
};
exports.TerminalCopyOnSelectionHandler = TerminalCopyOnSelectionHandler;
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TerminalCopyOnSelectionHandler.prototype, "init", null);
exports.TerminalCopyOnSelectionHandler = TerminalCopyOnSelectionHandler = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TerminalCopyOnSelectionHandler);


/***/ }),

/***/ "../../node_modules/@theia/terminal/lib/browser/terminal-frontend-contribution.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/browser/terminal-frontend-contribution.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalFrontendContribution = exports.TerminalCommands = exports.TerminalMenus = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const terminal_widget_impl_1 = __webpack_require__(/*! ./terminal-widget-impl */ "../../node_modules/@theia/terminal/lib/browser/terminal-widget-impl.js");
const terminal_widget_1 = __webpack_require__(/*! ./base/terminal-widget */ "../../node_modules/@theia/terminal/lib/browser/base/terminal-widget.js");
const terminal_profile_service_1 = __webpack_require__(/*! ./terminal-profile-service */ "../../node_modules/@theia/terminal/lib/browser/terminal-profile-service.js");
const uri_command_handler_1 = __webpack_require__(/*! @theia/core/lib/common/uri-command-handler */ "../../node_modules/@theia/core/lib/common/uri-command-handler.js");
const shell_terminal_protocol_1 = __webpack_require__(/*! ../common/shell-terminal-protocol */ "../../node_modules/@theia/terminal/lib/common/shell-terminal-protocol.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_2 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const context_key_service_1 = __webpack_require__(/*! @theia/core/lib/browser/context-key-service */ "../../node_modules/@theia/core/lib/browser/context-key-service.js");
const terminal_theme_service_1 = __webpack_require__(/*! ./terminal-theme-service */ "../../node_modules/@theia/terminal/lib/browser/terminal-theme-service.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const terminal_watcher_1 = __webpack_require__(/*! ../common/terminal-watcher */ "../../node_modules/@theia/terminal/lib/common/terminal-watcher.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const terminal_preferences_1 = __webpack_require__(/*! ./terminal-preferences */ "../../node_modules/@theia/terminal/lib/browser/terminal-preferences.js");
const shell_terminal_profile_1 = __webpack_require__(/*! ./shell-terminal-profile */ "../../node_modules/@theia/terminal/lib/browser/shell-terminal-profile.js");
const browser_3 = __webpack_require__(/*! @theia/variable-resolver/lib/browser */ "../../node_modules/@theia/variable-resolver/lib/browser/index.js");
const color_1 = __webpack_require__(/*! @theia/core/lib/common/color */ "../../node_modules/@theia/core/lib/common/color.js");
var TerminalMenus;
(function (TerminalMenus) {
    TerminalMenus.TERMINAL = [...core_1.MAIN_MENU_BAR, '7_terminal'];
    TerminalMenus.TERMINAL_NEW = [...TerminalMenus.TERMINAL, '1_terminal'];
    TerminalMenus.TERMINAL_TASKS = [...TerminalMenus.TERMINAL, '2_terminal'];
    TerminalMenus.TERMINAL_TASKS_INFO = [...TerminalMenus.TERMINAL_TASKS, '3_terminal'];
    TerminalMenus.TERMINAL_TASKS_CONFIG = [...TerminalMenus.TERMINAL_TASKS, '4_terminal'];
    TerminalMenus.TERMINAL_NAVIGATOR_CONTEXT_MENU = ['navigator-context-menu', 'navigation'];
    TerminalMenus.TERMINAL_OPEN_EDITORS_CONTEXT_MENU = ['open-editors-context-menu', 'navigation'];
    TerminalMenus.TERMINAL_CONTEXT_MENU = ['terminal-context-menu'];
    TerminalMenus.TERMINAL_CONTRIBUTIONS = [...TerminalMenus.TERMINAL_CONTEXT_MENU, '5_terminal_contributions'];
    TerminalMenus.TERMINAL_TITLE_CONTRIBUTIONS = [...browser_1.SHELL_TABBAR_CONTEXT_MENU, 'terminal_title_contributions'];
})(TerminalMenus || (exports.TerminalMenus = TerminalMenus = {}));
var TerminalCommands;
(function (TerminalCommands) {
    const TERMINAL_CATEGORY = 'Terminal';
    TerminalCommands.NEW = common_1.Command.toDefaultLocalizedCommand({
        id: 'terminal:new',
        category: TERMINAL_CATEGORY,
        label: 'Create New Terminal'
    });
    TerminalCommands.PROFILE_NEW = common_1.Command.toLocalizedCommand({
        id: 'terminal:new:profile',
        category: TERMINAL_CATEGORY,
        label: 'Create New Integrated Terminal from a Profile'
    });
    TerminalCommands.PROFILE_DEFAULT = common_1.Command.toLocalizedCommand({
        id: 'terminal:profile:default',
        category: TERMINAL_CATEGORY,
        label: 'Choose the default Terminal Profile'
    });
    TerminalCommands.NEW_ACTIVE_WORKSPACE = common_1.Command.toDefaultLocalizedCommand({
        id: 'terminal:new:active:workspace',
        category: TERMINAL_CATEGORY,
        label: 'Create New Terminal (In Active Workspace)'
    });
    TerminalCommands.TERMINAL_CLEAR = common_1.Command.toDefaultLocalizedCommand({
        id: 'terminal:clear',
        category: TERMINAL_CATEGORY,
        label: 'Clear'
    });
    TerminalCommands.TERMINAL_CONTEXT = common_1.Command.toDefaultLocalizedCommand({
        id: 'terminal:context',
        category: TERMINAL_CATEGORY,
        label: 'Open in Integrated Terminal'
    });
    TerminalCommands.SPLIT = common_1.Command.toDefaultLocalizedCommand({
        id: 'terminal:split',
        category: TERMINAL_CATEGORY,
        label: 'Split Terminal'
    });
    TerminalCommands.TERMINAL_FIND_TEXT = common_1.Command.toDefaultLocalizedCommand({
        id: 'terminal:find',
        category: TERMINAL_CATEGORY,
        label: 'Find'
    });
    TerminalCommands.TERMINAL_FIND_TEXT_CANCEL = common_1.Command.toDefaultLocalizedCommand({
        id: 'terminal:find:cancel',
        category: TERMINAL_CATEGORY,
        label: 'Hide Find'
    });
    TerminalCommands.SCROLL_LINE_UP = common_1.Command.toDefaultLocalizedCommand({
        id: 'terminal:scroll:line:up',
        category: TERMINAL_CATEGORY,
        label: 'Scroll Up (Line)'
    });
    TerminalCommands.SCROLL_LINE_DOWN = common_1.Command.toDefaultLocalizedCommand({
        id: 'terminal:scroll:line:down',
        category: TERMINAL_CATEGORY,
        label: 'Scroll Down (Line)'
    });
    TerminalCommands.SCROLL_TO_TOP = common_1.Command.toDefaultLocalizedCommand({
        id: 'terminal:scroll:top',
        category: TERMINAL_CATEGORY,
        label: 'Scroll to Top'
    });
    TerminalCommands.SCROLL_PAGE_UP = common_1.Command.toDefaultLocalizedCommand({
        id: 'terminal:scroll:page:up',
        category: TERMINAL_CATEGORY,
        label: 'Scroll Up (Page)'
    });
    TerminalCommands.SCROLL_PAGE_DOWN = common_1.Command.toDefaultLocalizedCommand({
        id: 'terminal:scroll:page:down',
        category: TERMINAL_CATEGORY,
        label: 'Scroll Down (Page)'
    });
    TerminalCommands.TOGGLE_TERMINAL = common_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.terminal.toggleTerminal',
        category: TERMINAL_CATEGORY,
        label: 'Toggle Terminal'
    });
    TerminalCommands.KILL_TERMINAL = common_1.Command.toDefaultLocalizedCommand({
        id: 'terminal:kill',
        category: TERMINAL_CATEGORY,
        label: 'Kill Terminal'
    });
    TerminalCommands.SELECT_ALL = {
        id: 'terminal:select:all',
        label: browser_1.CommonCommands.SELECT_ALL.label,
        category: TERMINAL_CATEGORY,
    };
    /**
     * Command that displays all terminals that are currently opened
     */
    TerminalCommands.SHOW_ALL_OPENED_TERMINALS = common_1.Command.toDefaultLocalizedCommand({
        id: 'workbench.action.showAllTerminals',
        category: browser_1.CommonCommands.VIEW_CATEGORY,
        label: 'Show All Opened Terminals'
    });
})(TerminalCommands || (exports.TerminalCommands = TerminalCommands = {}));
const ENVIRONMENT_VARIABLE_COLLECTIONS_KEY = 'terminal.integrated.environmentVariableCollections';
let TerminalFrontendContribution = class TerminalFrontendContribution {
    constructor() {
        this.mergePreferencesPromise = Promise.resolve();
        this.onDidCreateTerminalEmitter = new common_1.Emitter();
        this.onDidCreateTerminal = this.onDidCreateTerminalEmitter.event;
        this.onDidChangeCurrentTerminalEmitter = new common_1.Emitter();
        this.onDidChangeCurrentTerminal = this.onDidChangeCurrentTerminalEmitter.event;
        // IDs of the most recently used terminals
        this.mostRecentlyUsedTerminalEntries = [];
    }
    init() {
        this.shell.onDidChangeCurrentWidget(() => this.updateCurrentTerminal());
        this.widgetManager.onDidCreateWidget(({ widget }) => {
            if (widget instanceof terminal_widget_1.TerminalWidget) {
                this.updateCurrentTerminal();
                this.onDidCreateTerminalEmitter.fire(widget);
                this.setLastUsedTerminal(widget);
            }
        });
        const terminalFocusKey = this.contextKeyService.createKey('terminalFocus', false);
        const terminalSearchToggle = this.contextKeyService.createKey('terminalHideSearch', false);
        const updateFocusKey = () => {
            terminalFocusKey.set(this.shell.activeWidget instanceof terminal_widget_1.TerminalWidget);
            terminalSearchToggle.set(this.terminalHideSearch);
        };
        updateFocusKey();
        this.shell.onDidChangeActiveWidget(updateFocusKey);
        this.terminalWatcher.onStoreTerminalEnvVariablesRequested(data => {
            this.storageService.setData(ENVIRONMENT_VARIABLE_COLLECTIONS_KEY, data);
        });
        this.terminalWatcher.onUpdateTerminalEnvVariablesRequested(() => {
            this.storageService.getData(ENVIRONMENT_VARIABLE_COLLECTIONS_KEY).then(data => {
                if (data) {
                    this.shellTerminalServer.restorePersisted(data);
                }
            });
        });
    }
    get terminalHideSearch() {
        if (!(this.shell.activeWidget instanceof terminal_widget_1.TerminalWidget)) {
            return false;
        }
        const searchWidget = this.shell.activeWidget.getSearchBox();
        return searchWidget.isVisible;
    }
    async onStart(app) {
        this.contributeDefaultProfiles();
        this.terminalPreferences.onPreferenceChanged(e => {
            if (e.preferenceName.startsWith('terminal.integrated.')) {
                this.mergePreferencesPromise = this.mergePreferencesPromise.finally(() => this.mergePreferences());
            }
        });
        this.mergePreferencesPromise = this.mergePreferencesPromise.finally(() => this.mergePreferences());
        // extension contributions get read after this point: need to set the default profile if necessary
        this.profileService.onAdded(id => {
            let defaultProfileId;
            switch (common_1.OS.backend.type()) {
                case common_1.OS.Type.Windows: {
                    defaultProfileId = this.terminalPreferences['terminal.integrated.defaultProfile.windows'];
                    break;
                }
                case common_1.OS.Type.Linux: {
                    defaultProfileId = this.terminalPreferences['terminal.integrated.defaultProfile.linux'];
                    break;
                }
                case common_1.OS.Type.OSX: {
                    defaultProfileId = this.terminalPreferences['terminal.integrated.defaultProfile.osx'];
                    break;
                }
            }
            if (defaultProfileId) {
                this.profileService.setDefaultProfile(defaultProfileId);
            }
        });
    }
    async contributeDefaultProfiles() {
        if (common_1.OS.backend.isWindows) {
            this.contributedProfileStore.registerTerminalProfile('cmd', new shell_terminal_profile_1.ShellTerminalProfile(this, {
                shellPath: await this.resolveShellPath([
                    '${env:windir}\\Sysnative\\cmd.exe',
                    '${env:windir}\\System32\\cmd.exe'
                ])
            }));
        }
        else {
            this.contributedProfileStore.registerTerminalProfile('SHELL', new shell_terminal_profile_1.ShellTerminalProfile(this, {
                shellPath: await this.resolveShellPath('${SHELL}'),
                shellArgs: ['-l'],
                iconClass: 'codicon codicon-terminal'
            }));
        }
        // contribute default profiles based on legacy preferences
    }
    async mergePreferences() {
        var _a, _b, _c;
        let profiles;
        let defaultProfile;
        let legacyShellPath;
        let legacyShellArgs;
        const removed = new Set(this.userProfileStore.all.map(([id, profile]) => id));
        switch (common_1.OS.backend.type()) {
            case common_1.OS.Type.Windows: {
                profiles = this.terminalPreferences['terminal.integrated.profiles.windows'];
                defaultProfile = this.terminalPreferences['terminal.integrated.defaultProfile.windows'];
                legacyShellPath = (_a = this.terminalPreferences['terminal.integrated.shell.windows']) !== null && _a !== void 0 ? _a : undefined;
                legacyShellArgs = this.terminalPreferences['terminal.integrated.shellArgs.windows'];
                break;
            }
            case common_1.OS.Type.Linux: {
                profiles = this.terminalPreferences['terminal.integrated.profiles.linux'];
                defaultProfile = this.terminalPreferences['terminal.integrated.defaultProfile.linux'];
                legacyShellPath = (_b = this.terminalPreferences['terminal.integrated.shell.linux']) !== null && _b !== void 0 ? _b : undefined;
                legacyShellArgs = this.terminalPreferences['terminal.integrated.shellArgs.linux'];
                break;
            }
            case common_1.OS.Type.OSX: {
                profiles = this.terminalPreferences['terminal.integrated.profiles.osx'];
                defaultProfile = this.terminalPreferences['terminal.integrated.defaultProfile.osx'];
                legacyShellPath = (_c = this.terminalPreferences['terminal.integrated.shell.osx']) !== null && _c !== void 0 ? _c : undefined;
                legacyShellArgs = this.terminalPreferences['terminal.integrated.shellArgs.osx'];
                break;
            }
        }
        if (profiles) {
            for (const id of Object.getOwnPropertyNames(profiles)) {
                const profile = profiles[id];
                removed.delete(id);
                if (profile) {
                    const shellPath = await this.resolveShellPath(profile.path);
                    if (shellPath) {
                        const options = {
                            shellPath: shellPath,
                            shellArgs: profile.args ? await this.variableResolver.resolve(profile.args) : undefined,
                            useServerTitle: profile.overrideName ? false : undefined,
                            env: profile.env ? await this.variableResolver.resolve(profile.env) : undefined,
                            title: profile.overrideName ? id : undefined
                        };
                        this.userProfileStore.registerTerminalProfile(id, new shell_terminal_profile_1.ShellTerminalProfile(this, options));
                    }
                }
                else {
                    this.userProfileStore.registerTerminalProfile(id, terminal_profile_service_1.NULL_PROFILE);
                }
            }
        }
        if (legacyShellPath) {
            this.userProfileStore.registerTerminalProfile('Legacy Shell Preferences', new shell_terminal_profile_1.ShellTerminalProfile(this, {
                shellPath: legacyShellPath,
                shellArgs: legacyShellArgs
            }));
            // if no other default is set, use the legacy preferences as default if they exist
            this.profileService.setDefaultProfile('Legacy Shell Preferences');
        }
        if (defaultProfile && this.profileService.getProfile(defaultProfile)) {
            this.profileService.setDefaultProfile(defaultProfile);
        }
        for (const id of removed) {
            this.userProfileStore.unregisterTerminalProfile(id);
        }
    }
    async resolveShellPath(path) {
        if (!path) {
            return undefined;
        }
        if (typeof path === 'string') {
            path = [path];
        }
        for (const p of path) {
            const resolved = await this.variableResolver.resolve(p);
            if (resolved) {
                const resolvedURI = uri_1.default.fromFilePath(resolved);
                if (await this.fileService.exists(resolvedURI)) {
                    return resolved;
                }
            }
        }
        return undefined;
    }
    onWillStop() {
        const preferenceValue = this.terminalPreferences['terminal.integrated.confirmOnExit'];
        if (preferenceValue !== 'never') {
            const allTerminals = this.widgetManager.getWidgets(terminal_widget_impl_1.TERMINAL_WIDGET_FACTORY_ID);
            if (allTerminals.length) {
                return {
                    prepare: async () => {
                        if (preferenceValue === 'always') {
                            return allTerminals.length;
                        }
                        else {
                            const activeTerminals = await Promise.all(allTerminals.map(widget => widget.hasChildProcesses()))
                                .then(hasChildProcesses => hasChildProcesses.filter(hasChild => hasChild));
                            return activeTerminals.length;
                        }
                    },
                    action: async (activeTerminalCount) => activeTerminalCount === 0 || this.confirmExitWithActiveTerminals(activeTerminalCount),
                    reason: 'Active integrated terminal',
                };
            }
        }
    }
    async confirmExitWithActiveTerminals(activeTerminalCount) {
        const msg = activeTerminalCount === 1
            ? nls_1.nls.localizeByDefault('Do you want to terminate the active terminal session?')
            : nls_1.nls.localizeByDefault('Do you want to terminate the {0} active terminal sessions?', activeTerminalCount);
        const safeToExit = await new browser_1.ConfirmDialog({
            title: '',
            msg,
            ok: nls_1.nls.localizeByDefault('Terminate'),
            cancel: browser_1.Dialog.CANCEL,
        }).open();
        return safeToExit === true;
    }
    get currentTerminal() {
        return this._currentTerminal;
    }
    setCurrentTerminal(current) {
        if (this._currentTerminal !== current) {
            this._currentTerminal = current;
            this.onDidChangeCurrentTerminalEmitter.fire(this._currentTerminal);
        }
    }
    updateCurrentTerminal() {
        const widget = this.shell.currentWidget;
        if (widget instanceof terminal_widget_1.TerminalWidget) {
            this.setCurrentTerminal(widget);
        }
        else if (!this._currentTerminal || !this._currentTerminal.isVisible) {
            this.setCurrentTerminal(undefined);
        }
    }
    getLastUsedTerminalId() {
        const mostRecent = this.mostRecentlyUsedTerminalEntries[this.mostRecentlyUsedTerminalEntries.length - 1];
        if (mostRecent) {
            return mostRecent.id;
        }
    }
    get lastUsedTerminal() {
        const id = this.getLastUsedTerminalId();
        if (id) {
            return this.getById(id);
        }
    }
    setLastUsedTerminal(lastUsedTerminal) {
        const lastUsedTerminalId = lastUsedTerminal.id;
        const entryIndex = this.mostRecentlyUsedTerminalEntries.findIndex(entry => entry.id === lastUsedTerminalId);
        let toDispose;
        if (entryIndex >= 0) {
            toDispose = this.mostRecentlyUsedTerminalEntries[entryIndex].disposables;
            this.mostRecentlyUsedTerminalEntries.splice(entryIndex, 1);
        }
        else {
            toDispose = new common_1.DisposableCollection();
            toDispose.push(lastUsedTerminal.onDidChangeVisibility((isVisible) => {
                if (isVisible) {
                    this.setLastUsedTerminal(lastUsedTerminal);
                }
            }));
            toDispose.push(lastUsedTerminal.onDidDispose(() => {
                const index = this.mostRecentlyUsedTerminalEntries.findIndex(entry => entry.id === lastUsedTerminalId);
                if (index >= 0) {
                    this.mostRecentlyUsedTerminalEntries[index].disposables.dispose();
                    this.mostRecentlyUsedTerminalEntries.splice(index, 1);
                }
            }));
        }
        const newEntry = { id: lastUsedTerminalId, disposables: toDispose };
        if (lastUsedTerminal.isVisible) {
            this.mostRecentlyUsedTerminalEntries.push(newEntry);
        }
        else {
            this.mostRecentlyUsedTerminalEntries = [newEntry, ...this.mostRecentlyUsedTerminalEntries];
        }
    }
    get all() {
        return this.widgetManager.getWidgets(terminal_widget_impl_1.TERMINAL_WIDGET_FACTORY_ID);
    }
    getById(id) {
        return this.all.find(terminal => terminal.id === id);
    }
    getByTerminalId(terminalId) {
        return this.all.find(terminal => terminal.terminalId === terminalId);
    }
    getDefaultShell() {
        return this.shellTerminalServer.getDefaultShell();
    }
    registerCommands(commands) {
        commands.registerCommand(TerminalCommands.NEW, {
            execute: () => this.openTerminal()
        });
        commands.registerCommand(TerminalCommands.PROFILE_NEW, {
            execute: async () => {
                const profile = await this.selectTerminalProfile(nls_1.nls.localize('theia/terminal/selectProfile', 'Select a profile for the new terminal'));
                if (!profile) {
                    return;
                }
                this.openTerminal(undefined, profile[1]);
            }
        });
        commands.registerCommand(TerminalCommands.PROFILE_DEFAULT, {
            execute: () => this.chooseDefaultProfile()
        });
        commands.registerCommand(TerminalCommands.NEW_ACTIVE_WORKSPACE, {
            execute: () => this.openActiveWorkspaceTerminal()
        });
        commands.registerCommand(TerminalCommands.SPLIT, {
            execute: () => this.splitTerminal(),
            isEnabled: w => this.withWidget(w, () => true),
            isVisible: w => this.withWidget(w, () => true),
        });
        commands.registerCommand(TerminalCommands.TERMINAL_CLEAR);
        commands.registerHandler(TerminalCommands.TERMINAL_CLEAR.id, {
            execute: () => { var _a; return (_a = this.currentTerminal) === null || _a === void 0 ? void 0 : _a.clearOutput(); }
        });
        commands.registerCommand(TerminalCommands.TERMINAL_CONTEXT, uri_command_handler_1.UriAwareCommandHandler.MonoSelect(this.selectionService, {
            execute: uri => this.openInTerminal(uri)
        }));
        commands.registerCommand(TerminalCommands.TERMINAL_FIND_TEXT);
        commands.registerHandler(TerminalCommands.TERMINAL_FIND_TEXT.id, {
            isEnabled: () => {
                if (this.shell.activeWidget instanceof terminal_widget_1.TerminalWidget) {
                    return !this.shell.activeWidget.getSearchBox().isVisible;
                }
                return false;
            },
            execute: () => {
                const termWidget = this.shell.activeWidget;
                const terminalSearchBox = termWidget.getSearchBox();
                terminalSearchBox.show();
            }
        });
        commands.registerCommand(TerminalCommands.TERMINAL_FIND_TEXT_CANCEL);
        commands.registerHandler(TerminalCommands.TERMINAL_FIND_TEXT_CANCEL.id, {
            isEnabled: () => {
                if (this.shell.activeWidget instanceof terminal_widget_1.TerminalWidget) {
                    return this.shell.activeWidget.getSearchBox().isVisible;
                }
                return false;
            },
            execute: () => {
                const termWidget = this.shell.activeWidget;
                const terminalSearchBox = termWidget.getSearchBox();
                terminalSearchBox.hide();
            }
        });
        commands.registerCommand(TerminalCommands.SCROLL_LINE_UP, {
            isEnabled: () => this.shell.activeWidget instanceof terminal_widget_1.TerminalWidget,
            isVisible: () => false,
            execute: () => {
                this.shell.activeWidget.scrollLineUp();
            }
        });
        commands.registerCommand(TerminalCommands.SCROLL_LINE_DOWN, {
            isEnabled: () => this.shell.activeWidget instanceof terminal_widget_1.TerminalWidget,
            isVisible: () => false,
            execute: () => {
                this.shell.activeWidget.scrollLineDown();
            }
        });
        commands.registerCommand(TerminalCommands.SCROLL_TO_TOP, {
            isEnabled: () => this.shell.activeWidget instanceof terminal_widget_1.TerminalWidget,
            isVisible: () => false,
            execute: () => {
                this.shell.activeWidget.scrollToTop();
            }
        });
        commands.registerCommand(TerminalCommands.SCROLL_PAGE_UP, {
            isEnabled: () => this.shell.activeWidget instanceof terminal_widget_1.TerminalWidget,
            isVisible: () => false,
            execute: () => {
                this.shell.activeWidget.scrollPageUp();
            }
        });
        commands.registerCommand(TerminalCommands.SCROLL_PAGE_DOWN, {
            isEnabled: () => this.shell.activeWidget instanceof terminal_widget_1.TerminalWidget,
            isVisible: () => false,
            execute: () => {
                this.shell.activeWidget.scrollPageDown();
            }
        });
        commands.registerCommand(TerminalCommands.TOGGLE_TERMINAL, {
            execute: () => this.toggleTerminal()
        });
        commands.registerCommand(TerminalCommands.KILL_TERMINAL, {
            isEnabled: () => !!this.currentTerminal,
            execute: () => { var _a; return (_a = this.currentTerminal) === null || _a === void 0 ? void 0 : _a.close(); }
        });
        commands.registerCommand(TerminalCommands.SELECT_ALL, {
            isEnabled: () => !!this.currentTerminal,
            execute: () => { var _a; return (_a = this.currentTerminal) === null || _a === void 0 ? void 0 : _a.selectAll(); }
        });
    }
    toggleTerminal() {
        const terminals = this.shell.getWidgets('bottom').filter(w => w instanceof terminal_widget_1.TerminalWidget);
        if (terminals.length === 0) {
            this.openTerminal();
            return;
        }
        if (!this.shell.isExpanded('bottom')) {
            this.shell.expandPanel('bottom');
            terminals[0].activate();
        }
        else {
            const visibleTerminal = terminals.find(t => t.isVisible);
            if (!visibleTerminal) {
                this.shell.bottomPanel.activateWidget(terminals[0]);
            }
            else if (this.shell.activeWidget !== visibleTerminal) {
                this.shell.bottomPanel.activateWidget(visibleTerminal);
            }
            else {
                this.shell.collapsePanel('bottom');
            }
        }
    }
    async openInTerminal(uri) {
        // Determine folder path of URI
        let stat;
        try {
            stat = await this.fileService.resolve(uri);
        }
        catch {
            return;
        }
        // Use folder if a file was selected
        const cwd = (stat.isDirectory) ? uri.toString() : uri.parent.toString();
        // Open terminal
        const termWidget = await this.newTerminal({ cwd });
        termWidget.start();
        this.open(termWidget);
    }
    registerMenus(menus) {
        menus.registerSubmenu(TerminalMenus.TERMINAL, terminal_widget_impl_1.TerminalWidgetImpl.LABEL);
        menus.registerMenuAction(TerminalMenus.TERMINAL_NEW, {
            commandId: TerminalCommands.NEW.id,
            label: nls_1.nls.localizeByDefault('New Terminal'),
            order: '0'
        });
        menus.registerMenuAction(TerminalMenus.TERMINAL_NEW, {
            commandId: TerminalCommands.PROFILE_NEW.id,
            label: nls_1.nls.localize('theia/terminal/profileNew', 'New Terminal (With Profile)...'),
            order: '1'
        });
        menus.registerMenuAction(TerminalMenus.TERMINAL_NEW, {
            commandId: TerminalCommands.PROFILE_DEFAULT.id,
            label: nls_1.nls.localize('theia/terminal/profileDefault', 'Choose Default Profile...'),
            order: '3'
        });
        menus.registerMenuAction(TerminalMenus.TERMINAL_NEW, {
            commandId: TerminalCommands.SPLIT.id,
            order: '3'
        });
        menus.registerMenuAction(TerminalMenus.TERMINAL_NAVIGATOR_CONTEXT_MENU, {
            commandId: TerminalCommands.TERMINAL_CONTEXT.id,
            order: 'z'
        });
        menus.registerMenuAction(TerminalMenus.TERMINAL_OPEN_EDITORS_CONTEXT_MENU, {
            commandId: TerminalCommands.TERMINAL_CONTEXT.id,
            order: 'z'
        });
        menus.registerMenuAction([...TerminalMenus.TERMINAL_CONTEXT_MENU, '_1'], {
            commandId: TerminalCommands.NEW_ACTIVE_WORKSPACE.id,
            label: nls_1.nls.localizeByDefault('New Terminal')
        });
        menus.registerMenuAction([...TerminalMenus.TERMINAL_CONTEXT_MENU, '_1'], {
            commandId: TerminalCommands.SPLIT.id
        });
        menus.registerMenuAction([...TerminalMenus.TERMINAL_CONTEXT_MENU, '_2'], {
            commandId: browser_1.CommonCommands.COPY.id
        });
        menus.registerMenuAction([...TerminalMenus.TERMINAL_CONTEXT_MENU, '_2'], {
            commandId: browser_1.CommonCommands.PASTE.id
        });
        menus.registerMenuAction([...TerminalMenus.TERMINAL_CONTEXT_MENU, '_2'], {
            commandId: TerminalCommands.SELECT_ALL.id
        });
        menus.registerMenuAction([...TerminalMenus.TERMINAL_CONTEXT_MENU, '_3'], {
            commandId: TerminalCommands.TERMINAL_CLEAR.id
        });
        menus.registerMenuAction([...TerminalMenus.TERMINAL_CONTEXT_MENU, '_4'], {
            commandId: TerminalCommands.KILL_TERMINAL.id
        });
        menus.registerSubmenu(TerminalMenus.TERMINAL_CONTRIBUTIONS, '', {
            role: 1 /* CompoundMenuNodeRole.Group */
        });
        menus.registerSubmenu(TerminalMenus.TERMINAL_TITLE_CONTRIBUTIONS, '', {
            role: 1 /* CompoundMenuNodeRole.Group */,
            when: 'isTerminalTab'
        });
    }
    registerToolbarItems(toolbar) {
        toolbar.registerItem({
            id: TerminalCommands.NEW.id,
            command: TerminalCommands.NEW.id,
            icon: (0, browser_1.codicon)('add'),
            tooltip: TerminalCommands.NEW.label,
            isVisible: w => this.withWidget(w, () => true),
        });
        toolbar.registerItem({
            id: TerminalCommands.SPLIT.id,
            command: TerminalCommands.SPLIT.id,
            icon: (0, browser_1.codicon)('split-horizontal'),
            tooltip: TerminalCommands.SPLIT.label
        });
    }
    registerKeybindings(keybindings) {
        /* Register passthrough keybindings for combinations recognized by
           xterm.js and converted to control characters.
             See: https://github.com/xtermjs/xterm.js/blob/v3/src/Terminal.ts#L1684 */
        /* Register ctrl + k (the passed Key) as a passthrough command in the
           context of the terminal.  */
        const regCtrl = (k) => {
            keybindings.registerKeybinding({
                command: browser_1.KeybindingRegistry.PASSTHROUGH_PSEUDO_COMMAND,
                keybinding: browser_1.KeyCode.createKeyCode({ key: k, ctrl: true }).toString(),
                when: 'terminalFocus',
            });
        };
        /* Register alt + k (the passed Key) as a passthrough command in the
           context of the terminal.  */
        const regAlt = (k) => {
            keybindings.registerKeybinding({
                command: browser_1.KeybindingRegistry.PASSTHROUGH_PSEUDO_COMMAND,
                keybinding: browser_1.KeyCode.createKeyCode({ key: k, alt: true }).toString(),
                when: 'terminalFocus'
            });
        };
        /* ctrl-space (000 - NUL).  */
        regCtrl(browser_1.Key.SPACE);
        /* ctrl-A (001/1/0x1) through ctrl-Z (032/26/0x1A).  */
        for (let i = 0; i < 26; i++) {
            regCtrl({
                keyCode: browser_1.Key.KEY_A.keyCode + i,
                code: 'Key' + String.fromCharCode('A'.charCodeAt(0) + i)
            });
        }
        /* ctrl-[ or ctrl-3 (033/27/0x1B - ESC).  */
        regCtrl(browser_1.Key.BRACKET_LEFT);
        regCtrl(browser_1.Key.DIGIT3);
        /* ctrl-\ or ctrl-4 (034/28/0x1C - FS).  */
        regCtrl(browser_1.Key.BACKSLASH);
        regCtrl(browser_1.Key.DIGIT4);
        /* ctrl-] or ctrl-5 (035/29/0x1D - GS).  */
        regCtrl(browser_1.Key.BRACKET_RIGHT);
        regCtrl(browser_1.Key.DIGIT5);
        /* ctrl-6 (036/30/0x1E - RS).  */
        regCtrl(browser_1.Key.DIGIT6);
        /* ctrl-7 (037/31/0x1F - US).  */
        regCtrl(browser_1.Key.DIGIT7);
        /* ctrl-8 (177/127/0x7F - DEL).  */
        regCtrl(browser_1.Key.DIGIT8);
        /* alt-A (0x1B 0x62) through alt-Z (0x1B 0x7A).  */
        for (let i = 0; i < 26; i++) {
            regAlt({
                keyCode: browser_1.Key.KEY_A.keyCode + i,
                code: 'Key' + String.fromCharCode('A'.charCodeAt(0) + i)
            });
        }
        /* alt-` (0x1B 0x60).  */
        regAlt(browser_1.Key.BACKQUOTE);
        /* alt-0 (0x1B 0x30) through alt-9 (0x1B 0x39).  */
        for (let i = 0; i < 10; i++) {
            regAlt({
                keyCode: browser_1.Key.DIGIT0.keyCode + i,
                code: 'Digit' + String.fromCharCode('0'.charCodeAt(0) + i)
            });
        }
        if (common_1.isOSX) {
            // selectAll on OSX
            keybindings.registerKeybinding({
                command: browser_1.KeybindingRegistry.PASSTHROUGH_PSEUDO_COMMAND,
                keybinding: 'ctrlcmd+a',
                when: 'terminalFocus'
            });
        }
        keybindings.registerKeybinding({
            command: TerminalCommands.NEW.id,
            keybinding: 'ctrl+shift+`'
        });
        keybindings.registerKeybinding({
            command: TerminalCommands.NEW_ACTIVE_WORKSPACE.id,
            keybinding: 'ctrl+`'
        });
        keybindings.registerKeybinding({
            command: TerminalCommands.TERMINAL_CLEAR.id,
            keybinding: 'ctrlcmd+k',
            when: 'terminalFocus'
        });
        keybindings.registerKeybinding({
            command: TerminalCommands.TERMINAL_FIND_TEXT.id,
            keybinding: 'ctrlcmd+f',
            when: 'terminalFocus'
        });
        keybindings.registerKeybinding({
            command: TerminalCommands.TERMINAL_FIND_TEXT_CANCEL.id,
            keybinding: 'esc',
            when: 'terminalHideSearch'
        });
        keybindings.registerKeybinding({
            command: TerminalCommands.SCROLL_LINE_UP.id,
            keybinding: 'ctrl+shift+up',
            when: 'terminalFocus'
        });
        keybindings.registerKeybinding({
            command: TerminalCommands.SCROLL_LINE_DOWN.id,
            keybinding: 'ctrl+shift+down',
            when: 'terminalFocus'
        });
        keybindings.registerKeybinding({
            command: TerminalCommands.SCROLL_TO_TOP.id,
            keybinding: 'shift-home',
            when: 'terminalFocus'
        });
        keybindings.registerKeybinding({
            command: TerminalCommands.SCROLL_PAGE_UP.id,
            keybinding: 'shift-pageUp',
            when: 'terminalFocus'
        });
        keybindings.registerKeybinding({
            command: TerminalCommands.SCROLL_PAGE_DOWN.id,
            keybinding: 'shift-pageDown',
            when: 'terminalFocus'
        });
        keybindings.registerKeybinding({
            command: TerminalCommands.TOGGLE_TERMINAL.id,
            keybinding: 'ctrl+`',
        });
        keybindings.registerKeybinding({
            command: TerminalCommands.SELECT_ALL.id,
            keybinding: 'ctrlcmd+a',
            when: 'terminalFocus'
        });
    }
    async newTerminal(options) {
        const widget = await this.widgetManager.getOrCreateWidget(terminal_widget_impl_1.TERMINAL_WIDGET_FACTORY_ID, {
            created: new Date().toISOString(),
            ...options
        });
        return widget;
    }
    // TODO: reuse WidgetOpenHandler.open
    open(widget, options) {
        var _a;
        const area = widget.location === terminal_widget_1.TerminalLocation.Editor ? 'main' : 'bottom';
        const widgetOptions = { area: area, ...options === null || options === void 0 ? void 0 : options.widgetOptions };
        let preserveFocus = false;
        if (typeof widget.location === 'object') {
            if ('parentTerminal' in widget.location) {
                widgetOptions.ref = this.getById(widget.location.parentTerminal);
                widgetOptions.mode = 'split-right';
            }
            else if ('viewColumn' in widget.location) {
                preserveFocus = (_a = widget.location.preserveFocus) !== null && _a !== void 0 ? _a : false;
                switch (widget.location.viewColumn) {
                    case common_1.ViewColumn.Active:
                        widgetOptions.ref = this.shell.currentWidget;
                        widgetOptions.mode = 'tab-after';
                        break;
                    case common_1.ViewColumn.Beside:
                        widgetOptions.ref = this.shell.currentWidget;
                        widgetOptions.mode = 'split-right';
                        break;
                    default:
                        widgetOptions.area = 'main';
                        const mainAreaTerminals = this.shell.getWidgets('main').filter(w => w instanceof terminal_widget_1.TerminalWidget && w.isVisible);
                        const column = Math.min(widget.location.viewColumn, mainAreaTerminals.length);
                        widgetOptions.mode = widget.location.viewColumn <= mainAreaTerminals.length ? 'split-left' : 'split-right';
                        widgetOptions.ref = mainAreaTerminals[column - 1];
                }
            }
        }
        const op = {
            mode: 'activate',
            ...options,
            widgetOptions: widgetOptions
        };
        if (!widget.isAttached) {
            this.shell.addWidget(widget, op.widgetOptions);
        }
        if (op.mode === 'activate' && !preserveFocus) {
            this.shell.activateWidget(widget.id);
        }
        else if (op.mode === 'reveal' || preserveFocus) {
            this.shell.revealWidget(widget.id);
        }
    }
    async selectTerminalCwd() {
        return new Promise(async (resolve) => {
            var _a, _b;
            const roots = this.workspaceService.tryGetRoots();
            if (roots.length === 0) {
                resolve(undefined);
            }
            else if (roots.length === 1) {
                resolve(roots[0].resource.toString());
            }
            else {
                const items = roots.map(({ resource }) => ({
                    label: this.labelProvider.getName(resource),
                    description: this.labelProvider.getLongName(resource),
                    resource
                }));
                const selectedItem = await ((_a = this.quickInputService) === null || _a === void 0 ? void 0 : _a.showQuickPick(items, {
                    placeholder: nls_1.nls.localizeByDefault('Select current working directory for new terminal')
                }));
                resolve((_b = selectedItem === null || selectedItem === void 0 ? void 0 : selectedItem.resource) === null || _b === void 0 ? void 0 : _b.toString());
            }
        });
    }
    async selectTerminalProfile(placeholder) {
        return new Promise(async (resolve) => {
            var _a;
            const profiles = this.profileService.all;
            if (profiles.length === 0) {
                resolve(undefined);
            }
            else {
                const items = profiles.map(([id, profile]) => ({
                    label: id,
                    profile
                }));
                const selectedItem = await ((_a = this.quickInputService) === null || _a === void 0 ? void 0 : _a.showQuickPick(items, {
                    placeholder
                }));
                resolve(selectedItem ? [selectedItem.label, selectedItem.profile] : undefined);
            }
        });
    }
    async splitTerminal(referenceTerminal) {
        if (referenceTerminal || this.currentTerminal) {
            const ref = referenceTerminal !== null && referenceTerminal !== void 0 ? referenceTerminal : this.currentTerminal;
            await this.openTerminal({ ref, mode: 'split-right' });
        }
    }
    async openTerminal(options, terminalProfile) {
        let profile = terminalProfile;
        if (!terminalProfile) {
            profile = this.profileService.defaultProfile;
            if (!profile) {
                throw new Error('There are no profiles registered');
            }
        }
        if (profile instanceof shell_terminal_profile_1.ShellTerminalProfile) {
            if (this.workspaceService.workspace) {
                const cwd = await this.selectTerminalCwd();
                if (!cwd) {
                    return;
                }
                profile = profile.modify({ cwd });
            }
        }
        const termWidget = await (profile === null || profile === void 0 ? void 0 : profile.start());
        if (!!termWidget) {
            this.open(termWidget, { widgetOptions: options });
        }
    }
    async chooseDefaultProfile() {
        const result = await this.selectTerminalProfile(nls_1.nls.localizeByDefault('Select your default terminal profile'));
        if (!result) {
            return;
        }
        this.preferenceService.set(`terminal.integrated.defaultProfile.${common_1.OS.backend.type().toLowerCase()}`, result[0], browser_1.PreferenceScope.User);
    }
    async openActiveWorkspaceTerminal(options) {
        const termWidget = await this.newTerminal({});
        termWidget.start();
        this.open(termWidget, { widgetOptions: options });
    }
    withWidget(widget, fn) {
        if (widget instanceof terminal_widget_1.TerminalWidget) {
            return fn(widget);
        }
        return false;
    }
    /**
     * It should be aligned with https://code.visualstudio.com/api/references/theme-color#integrated-terminal-colors
     */
    registerColors(colors) {
        colors.register({
            id: 'terminal.background',
            defaults: {
                dark: 'panel.background',
                light: 'panel.background',
                hcDark: 'panel.background',
                hcLight: 'panel.background'
            },
            description: 'The background color of the terminal, this allows coloring the terminal differently to the panel.'
        });
        colors.register({
            id: 'terminal.foreground',
            defaults: {
                light: '#333333',
                dark: '#CCCCCC',
                hcDark: '#FFFFFF',
                hcLight: '#292929'
            },
            description: 'The foreground color of the terminal.'
        });
        colors.register({
            id: 'terminalCursor.foreground',
            description: 'The foreground color of the terminal cursor.'
        });
        colors.register({
            id: 'terminalCursor.background',
            description: 'The background color of the terminal cursor. Allows customizing the color of a character overlapped by a block cursor.'
        });
        colors.register({
            id: 'terminal.selectionBackground',
            defaults: {
                light: 'editor.selectionBackground',
                dark: 'editor.selectionBackground',
                hcDark: 'editor.selectionBackground',
                hcLight: 'editor.selectionBackground'
            },
            description: 'The selection background color of the terminal.'
        });
        colors.register({
            id: 'terminal.inactiveSelectionBackground',
            defaults: {
                light: color_1.Color.transparent('terminal.selectionBackground', 0.5),
                dark: color_1.Color.transparent('terminal.selectionBackground', 0.5),
                hcDark: color_1.Color.transparent('terminal.selectionBackground', 0.7),
                hcLight: color_1.Color.transparent('terminal.selectionBackground', 0.5),
            },
            description: 'The selection background color of the terminal when it does not have focus.'
        });
        colors.register({
            id: 'terminal.selectionForeground',
            defaults: {
                light: undefined,
                dark: undefined,
                hcDark: '#000000',
                hcLight: '#ffffff'
            },
            // eslint-disable-next-line max-len
            description: 'The selection foreground color of the terminal. When this is null the selection foreground will be retained and have the minimum contrast ratio feature applied.'
        });
        colors.register({
            id: 'terminal.border',
            defaults: {
                light: 'panel.border',
                dark: 'panel.border',
                hcDark: 'panel.border',
                hcLight: 'panel.border'
            },
            description: 'The color of the border that separates split panes within the terminal. This defaults to panel.border.'
        });
        // eslint-disable-next-line guard-for-in
        for (const id in terminal_theme_service_1.terminalAnsiColorMap) {
            const entry = terminal_theme_service_1.terminalAnsiColorMap[id];
            const colorName = id.substring(13);
            colors.register({
                id,
                defaults: entry.defaults,
                description: `'${colorName}'  ANSI color in the terminal.`
            });
        }
    }
};
exports.TerminalFrontendContribution = TerminalFrontendContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ApplicationShell),
    tslib_1.__metadata("design:type", browser_1.ApplicationShell)
], TerminalFrontendContribution.prototype, "shell", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(shell_terminal_protocol_1.ShellTerminalServerProxy),
    tslib_1.__metadata("design:type", Object)
], TerminalFrontendContribution.prototype, "shellTerminalServer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.WidgetManager),
    tslib_1.__metadata("design:type", browser_1.WidgetManager)
], TerminalFrontendContribution.prototype, "widgetManager", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], TerminalFrontendContribution.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.SelectionService),
    tslib_1.__metadata("design:type", common_1.SelectionService)
], TerminalFrontendContribution.prototype, "selectionService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], TerminalFrontendContribution.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.QuickInputService),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], TerminalFrontendContribution.prototype, "quickInputService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.WorkspaceService),
    tslib_1.__metadata("design:type", browser_2.WorkspaceService)
], TerminalFrontendContribution.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(terminal_profile_service_1.TerminalProfileService),
    tslib_1.__metadata("design:type", Object)
], TerminalFrontendContribution.prototype, "profileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(terminal_profile_service_1.UserTerminalProfileStore),
    tslib_1.__metadata("design:type", Object)
], TerminalFrontendContribution.prototype, "userProfileStore", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(terminal_profile_service_1.ContributedTerminalProfileStore),
    tslib_1.__metadata("design:type", Object)
], TerminalFrontendContribution.prototype, "contributedProfileStore", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(terminal_watcher_1.TerminalWatcher),
    tslib_1.__metadata("design:type", terminal_watcher_1.TerminalWatcher)
], TerminalFrontendContribution.prototype, "terminalWatcher", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_3.VariableResolverService),
    tslib_1.__metadata("design:type", browser_3.VariableResolverService)
], TerminalFrontendContribution.prototype, "variableResolver", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.StorageService),
    tslib_1.__metadata("design:type", Object)
], TerminalFrontendContribution.prototype, "storageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], TerminalFrontendContribution.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(terminal_preferences_1.TerminalPreferences),
    tslib_1.__metadata("design:type", Object)
], TerminalFrontendContribution.prototype, "terminalPreferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(context_key_service_1.ContextKeyService),
    tslib_1.__metadata("design:type", Object)
], TerminalFrontendContribution.prototype, "contextKeyService", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TerminalFrontendContribution.prototype, "init", null);
exports.TerminalFrontendContribution = TerminalFrontendContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TerminalFrontendContribution);


/***/ }),

/***/ "../../node_modules/@theia/terminal/lib/browser/terminal-profile-service.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/browser/terminal-profile-service.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2022 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultTerminalProfileService = exports.DefaultProfileStore = exports.NULL_PROFILE = exports.UserTerminalProfileStore = exports.ContributedTerminalProfileStore = exports.TerminalProfileService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const shell_terminal_profile_1 = __webpack_require__(/*! ./shell-terminal-profile */ "../../node_modules/@theia/terminal/lib/browser/shell-terminal-profile.js");
exports.TerminalProfileService = Symbol('TerminalProfileService');
exports.ContributedTerminalProfileStore = Symbol('ContributedTerminalProfileStore');
exports.UserTerminalProfileStore = Symbol('UserTerminalProfileStore');
exports.NULL_PROFILE = {
    start: async () => { throw new Error('you cannot start a null profile'); }
};
let DefaultProfileStore = class DefaultProfileStore {
    constructor() {
        this.onAddedEmitter = new core_1.Emitter();
        this.onRemovedEmitter = new core_1.Emitter();
        this.profiles = new Map();
        this.onAdded = this.onAddedEmitter.event;
        this.onRemoved = this.onRemovedEmitter.event;
    }
    registerTerminalProfile(id, profile) {
        this.profiles.set(id, profile);
        this.onAddedEmitter.fire([id, profile]);
    }
    unregisterTerminalProfile(id) {
        this.profiles.delete(id);
        this.onRemovedEmitter.fire(id);
    }
    hasProfile(id) {
        return this.profiles.has(id);
    }
    getProfile(id) {
        return this.profiles.get(id);
    }
    get all() {
        return [...this.profiles.entries()];
    }
};
exports.DefaultProfileStore = DefaultProfileStore;
exports.DefaultProfileStore = DefaultProfileStore = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DefaultProfileStore);
let DefaultTerminalProfileService = class DefaultTerminalProfileService {
    constructor(...stores) {
        this.defaultProfileIndex = 0;
        this.order = [];
        this.onAddedEmitter = new core_1.Emitter();
        this.onRemovedEmitter = new core_1.Emitter();
        this.onDidChangeDefaultShellEmitter = new core_1.Emitter();
        this.onAdded = this.onAddedEmitter.event;
        this.onRemoved = this.onRemovedEmitter.event;
        this.onDidChangeDefaultShell = this.onDidChangeDefaultShellEmitter.event;
        this.stores = stores;
        for (const store of this.stores) {
            store.onAdded(e => {
                if (e[1] === exports.NULL_PROFILE) {
                    this.handleRemoved(e[0]);
                }
                else {
                    this.handleAdded(e[0]);
                }
            });
            store.onRemoved(id => {
                if (!this.getProfile(id)) {
                    this.handleRemoved(id);
                }
                else {
                    // we may have removed a null profile
                    this.handleAdded(id);
                }
            });
        }
    }
    handleRemoved(id) {
        const index = this.order.indexOf(id);
        if (index >= 0 && !this.getProfile(id)) {
            // the profile was removed, but it's still in the `order` array
            this.order.splice(index, 1);
            this.defaultProfileIndex = Math.max(0, Math.min(this.order.length - 1, index));
            this.onRemovedEmitter.fire(id);
        }
    }
    handleAdded(id) {
        const index = this.order.indexOf(id);
        if (index < 0) {
            this.order.push(id);
            this.onAddedEmitter.fire(id);
        }
    }
    get defaultProfile() {
        const id = this.order[this.defaultProfileIndex];
        if (id) {
            return this.getProfile(id);
        }
        return undefined;
    }
    setDefaultProfile(id) {
        const profile = this.getProfile(id);
        if (!profile) {
            throw new Error(`Cannot set default to unknown profile '${id}' `);
        }
        this.defaultProfileIndex = this.order.indexOf(id);
        if (profile instanceof shell_terminal_profile_1.ShellTerminalProfile && profile.shellPath) {
            this.onDidChangeDefaultShellEmitter.fire(profile.shellPath);
        }
        else {
            this.onDidChangeDefaultShellEmitter.fire('');
        }
    }
    getProfile(id) {
        for (const store of this.stores) {
            if (store.hasProfile(id)) {
                const found = store.getProfile(id);
                return found === exports.NULL_PROFILE ? undefined : found;
            }
        }
        return undefined;
    }
    getId(profile) {
        for (const [id, p] of this.all) {
            if (p === profile) {
                return id;
            }
        }
    }
    get all() {
        return this.order.filter(id => !!this.getProfile(id)).map(id => [id, this.getProfile(id)]);
    }
};
exports.DefaultTerminalProfileService = DefaultTerminalProfileService;
exports.DefaultTerminalProfileService = DefaultTerminalProfileService = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__param(0, (0, inversify_1.unmanaged)()),
    tslib_1.__metadata("design:paramtypes", [Object])
], DefaultTerminalProfileService);


/***/ }),

/***/ "../../node_modules/@theia/terminal/lib/browser/terminal-widget-impl.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/browser/terminal-widget-impl.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var TerminalWidgetImpl_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalWidgetImpl = exports.TerminalContribution = exports.TERMINAL_WIDGET_FACTORY_ID = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const xterm_1 = __webpack_require__(/*! xterm */ "../../node_modules/xterm/lib/xterm.js");
const xterm_addon_fit_1 = __webpack_require__(/*! xterm-addon-fit */ "../../node_modules/xterm-addon-fit/lib/xterm-addon-fit.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_2 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const shell_terminal_protocol_1 = __webpack_require__(/*! ../common/shell-terminal-protocol */ "../../node_modules/@theia/terminal/lib/common/shell-terminal-protocol.js");
const terminal_protocol_1 = __webpack_require__(/*! ../common/terminal-protocol */ "../../node_modules/@theia/terminal/lib/common/terminal-protocol.js");
const base_terminal_protocol_1 = __webpack_require__(/*! ../common/base-terminal-protocol */ "../../node_modules/@theia/terminal/lib/common/base-terminal-protocol.js");
const terminal_watcher_1 = __webpack_require__(/*! ../common/terminal-watcher */ "../../node_modules/@theia/terminal/lib/common/terminal-watcher.js");
const terminal_widget_1 = __webpack_require__(/*! ./base/terminal-widget */ "../../node_modules/@theia/terminal/lib/browser/base/terminal-widget.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "../../node_modules/@theia/core/lib/common/promise-util.js");
const terminal_preferences_1 = __webpack_require__(/*! ./terminal-preferences */ "../../node_modules/@theia/terminal/lib/browser/terminal-preferences.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const terminal_service_1 = __webpack_require__(/*! ./base/terminal-service */ "../../node_modules/@theia/terminal/lib/browser/base/terminal-service.js");
const terminal_search_widget_1 = __webpack_require__(/*! ./search/terminal-search-widget */ "../../node_modules/@theia/terminal/lib/browser/search/terminal-search-widget.js");
const terminal_copy_on_selection_handler_1 = __webpack_require__(/*! ./terminal-copy-on-selection-handler */ "../../node_modules/@theia/terminal/lib/browser/terminal-copy-on-selection-handler.js");
const terminal_theme_service_1 = __webpack_require__(/*! ./terminal-theme-service */ "../../node_modules/@theia/terminal/lib/browser/terminal-theme-service.js");
const shell_command_builder_1 = __webpack_require__(/*! @theia/process/lib/common/shell-command-builder */ "../../node_modules/@theia/process/lib/common/shell-command-builder.js");
const keys_1 = __webpack_require__(/*! @theia/core/lib/browser/keys */ "../../node_modules/@theia/core/lib/browser/keys.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
const terminal_frontend_contribution_1 = __webpack_require__(/*! ./terminal-frontend-contribution */ "../../node_modules/@theia/terminal/lib/browser/terminal-frontend-contribution.js");
const debounce = __webpack_require__(/*! p-debounce */ "../../node_modules/p-debounce/index.js");
const markdown_string_1 = __webpack_require__(/*! @theia/core/lib/common/markdown-rendering/markdown-string */ "../../node_modules/@theia/core/lib/common/markdown-rendering/markdown-string.js");
const markdown_renderer_1 = __webpack_require__(/*! @theia/core/lib/browser/markdown-rendering/markdown-renderer */ "../../node_modules/@theia/core/lib/browser/markdown-rendering/markdown-renderer.js");
const service_connection_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/messaging/service-connection-provider */ "../../node_modules/@theia/core/lib/browser/messaging/service-connection-provider.js");
const color_registry_1 = __webpack_require__(/*! @theia/core/lib/browser/color-registry */ "../../node_modules/@theia/core/lib/browser/color-registry.js");
exports.TERMINAL_WIDGET_FACTORY_ID = 'terminal';
exports.TerminalContribution = Symbol('TerminalContribution');
class TerminalBufferImpl {
    constructor(term) {
        this.term = term;
    }
    get length() {
        return this.term.buffer.active.length;
    }
    ;
    getLines(start, length) {
        const result = [];
        for (let i = 0; i < length && this.length - 1 - i >= 0; i++) {
            result.push(this.term.buffer.active.getLine(this.length - 1 - i).translateToString());
        }
        return result;
    }
}
let TerminalWidgetImpl = TerminalWidgetImpl_1 = class TerminalWidgetImpl extends terminal_widget_1.TerminalWidget {
    constructor() {
        super(...arguments);
        this.isExtractable = true;
        this.terminalKind = 'user';
        this._terminalId = -1;
        this.onTermDidClose = new core_1.Emitter();
        this.restored = false;
        this.closeOnDispose = true;
        this.isAttachedCloseListener = false;
        this.shown = false;
        this.lastCwd = new uri_1.default();
        this.onDidOpenEmitter = new core_1.Emitter();
        this.onDidOpen = this.onDidOpenEmitter.event;
        this.onDidOpenFailureEmitter = new core_1.Emitter();
        this.onDidOpenFailure = this.onDidOpenFailureEmitter.event;
        this.onSizeChangedEmitter = new core_1.Emitter();
        this.onSizeChanged = this.onSizeChangedEmitter.event;
        this.onDataEmitter = new core_1.Emitter();
        this.onData = this.onDataEmitter.event;
        this.onOutputEmitter = new core_1.Emitter();
        this.onOutput = this.onOutputEmitter.event;
        this.onKeyEmitter = new core_1.Emitter();
        this.onKey = this.onKeyEmitter.event;
        this.onMouseEnterLinkHoverEmitter = new core_1.Emitter();
        this.onMouseEnterLinkHover = this.onMouseEnterLinkHoverEmitter.event;
        this.onMouseLeaveLinkHoverEmitter = new core_1.Emitter();
        this.onMouseLeaveLinkHover = this.onMouseLeaveLinkHoverEmitter.event;
        this.toDisposeOnConnect = new core_1.DisposableCollection();
        this.needsResize = true;
        // Device status code emitted by Xterm.js
        // Check: https://github.com/xtermjs/xterm.js/blob/release/3.14/src/InputHandler.ts#L1055-L1082
        this.deviceStatusCodes = new Set(['\u001B[>0;276;0c', '\u001B[>85;95;0c', '\u001B[>83;40003;0c', '\u001B[?1;2c', '\u001B[?6c']);
        this.termOpened = false;
        this.initialData = '';
        this.resizeTerminal = debounce(() => this.doResizeTerminal(), 50);
    }
    get markdownRenderer() {
        this._markdownRenderer || (this._markdownRenderer = this.markdownRendererFactory());
        return this._markdownRenderer;
    }
    get buffer() {
        return this._buffer;
    }
    init() {
        this.id = this._terminalDOMId;
        this.setTitle(this.options.title || TerminalWidgetImpl_1.LABEL);
        this.setIconClass();
        if (this.options.kind) {
            this.terminalKind = this.options.kind;
        }
        if (this.options.destroyTermOnClose === true) {
            this.toDispose.push(core_1.Disposable.create(() => this.term.dispose()));
        }
        this.location = this.options.location || terminal_widget_1.TerminalLocation.Panel;
        this.title.closable = true;
        this.addClass('terminal-container');
        this.term = new xterm_1.Terminal({
            cursorBlink: this.preferences['terminal.integrated.cursorBlinking'],
            cursorStyle: this.preferences['terminal.integrated.cursorStyle'] === 'line' ? 'bar' : this.preferences['terminal.integrated.cursorStyle'],
            cursorWidth: this.preferences['terminal.integrated.cursorWidth'],
            fontFamily: this.preferences['terminal.integrated.fontFamily'],
            fontSize: this.preferences['terminal.integrated.fontSize'],
            fontWeight: this.preferences['terminal.integrated.fontWeight'],
            fontWeightBold: this.preferences['terminal.integrated.fontWeightBold'],
            drawBoldTextInBrightColors: this.preferences['terminal.integrated.drawBoldTextInBrightColors'],
            letterSpacing: this.preferences['terminal.integrated.letterSpacing'],
            lineHeight: this.preferences['terminal.integrated.lineHeight'],
            scrollback: this.preferences['terminal.integrated.scrollback'],
            fastScrollSensitivity: this.preferences['terminal.integrated.fastScrollSensitivity'],
            theme: this.themeService.theme
        });
        this._buffer = new TerminalBufferImpl(this.term);
        this.fitAddon = new xterm_addon_fit_1.FitAddon();
        this.term.loadAddon(this.fitAddon);
        this.initializeLinkHover();
        this.toDispose.push(this.preferences.onPreferenceChanged(change => {
            this.updateConfig();
            this.needsResize = true;
            this.update();
        }));
        this.toDispose.push(this.themeService.onDidChange(() => {
            this.term.options.theme = this.themeService.theme;
            this.setIconClass();
        }));
        this.attachCustomKeyEventHandler();
        const titleChangeListenerDispose = this.term.onTitleChange((title) => {
            if (this.options.useServerTitle) {
                this.title.label = title;
            }
        });
        this.toDispose.push(titleChangeListenerDispose);
        this.toDispose.push(this.terminalWatcher.onTerminalError(({ terminalId, error, attached }) => {
            if (terminalId === this.terminalId) {
                this.exitStatus = { code: undefined, reason: base_terminal_protocol_1.TerminalExitReason.Process };
                this.logger.error(`The terminal process terminated. Cause: ${error}`);
                if (!attached) {
                    this.dispose();
                }
            }
        }));
        this.toDispose.push(this.terminalWatcher.onTerminalExit(({ terminalId, code, reason, attached }) => {
            if (terminalId === this.terminalId) {
                if (reason) {
                    this.exitStatus = { code, reason };
                }
                else {
                    this.exitStatus = { code, reason: base_terminal_protocol_1.TerminalExitReason.Process };
                }
                if (!attached) {
                    this.dispose();
                }
            }
        }));
        this.toDispose.push(this.toDisposeOnConnect);
        this.toDispose.push(this.shellTerminalServer.onDidCloseConnection(() => {
            const disposable = this.shellTerminalServer.onDidOpenConnection(() => {
                disposable.dispose();
                this.reconnectTerminalProcess();
            });
            this.toDispose.push(disposable);
        }));
        this.toDispose.push(this.onTermDidClose);
        this.toDispose.push(this.onDidOpenEmitter);
        this.toDispose.push(this.onDidOpenFailureEmitter);
        this.toDispose.push(this.onSizeChangedEmitter);
        this.toDispose.push(this.onDataEmitter);
        this.toDispose.push(this.onKeyEmitter);
        const touchEndListener = (event) => {
            if (this.node.contains(event.target)) {
                this.lastTouchEnd = event;
            }
        };
        document.addEventListener('touchend', touchEndListener, { passive: true });
        this.onDispose(() => {
            document.removeEventListener('touchend', touchEndListener);
        });
        const mouseListener = (event) => {
            this.lastMousePosition = { x: event.x, y: event.y };
        };
        this.node.addEventListener('mousemove', mouseListener);
        this.onDispose(() => {
            this.node.removeEventListener('mousemove', mouseListener);
        });
        const contextMenuListener = (event) => {
            event.preventDefault();
            event.stopPropagation();
            this.contextMenuRenderer.render({ menuPath: terminal_frontend_contribution_1.TerminalMenus.TERMINAL_CONTEXT_MENU, anchor: event, context: this.node });
        };
        this.node.addEventListener('contextmenu', contextMenuListener);
        this.onDispose(() => this.node.removeEventListener('contextmenu', contextMenuListener));
        this.toDispose.push(this.term.onSelectionChange(() => {
            if (this.copyOnSelection) {
                this.copyOnSelectionHandler.copy(this.term.getSelection());
            }
        }));
        this.toDispose.push(this.term.onResize(data => {
            this.onSizeChangedEmitter.fire(data);
        }));
        this.toDispose.push(this.term.onData(data => {
            this.onDataEmitter.fire(data);
        }));
        this.toDispose.push(this.term.onBinary(data => {
            this.onDataEmitter.fire(data);
        }));
        this.toDispose.push(this.term.onKey(data => {
            this.onKeyEmitter.fire(data);
        }));
        for (const contribution of this.terminalContributionProvider.getContributions()) {
            contribution.onCreate(this);
        }
        this.searchBox = this.terminalSearchBoxFactory(this.term);
        this.toDispose.push(this.searchBox);
    }
    get kind() {
        return this.terminalKind;
    }
    updateConfig() {
        this.setCursorBlink(this.preferences.get('terminal.integrated.cursorBlinking'));
        this.setCursorStyle(this.preferences.get('terminal.integrated.cursorStyle'));
        this.setCursorWidth(this.preferences.get('terminal.integrated.cursorWidth'));
        this.term.options.fontFamily = this.preferences.get('terminal.integrated.fontFamily');
        this.term.options.fontSize = this.preferences.get('terminal.integrated.fontSize');
        this.term.options.fontWeight = this.preferences.get('terminal.integrated.fontWeight');
        this.term.options.fontWeightBold = this.preferences.get('terminal.integrated.fontWeightBold');
        this.term.options.drawBoldTextInBrightColors = this.preferences.get('terminal.integrated.drawBoldTextInBrightColors');
        this.term.options.letterSpacing = this.preferences.get('terminal.integrated.letterSpacing');
        this.term.options.lineHeight = this.preferences.get('terminal.integrated.lineHeight');
        this.term.options.scrollback = this.preferences.get('terminal.integrated.scrollback');
        this.term.options.fastScrollSensitivity = this.preferences.get('terminal.integrated.fastScrollSensitivity');
    }
    setIconClass() {
        var _a;
        (_a = this.styleElement) === null || _a === void 0 ? void 0 : _a.remove();
        if (this.options.iconClass) {
            const iconClass = this.options.iconClass;
            if (typeof iconClass === 'string') {
                this.title.iconClass = iconClass;
            }
            else {
                const iconClasses = [];
                iconClasses.push(iconClass.id);
                if (iconClass.color) {
                    this.styleElement = browser_1.DecorationStyle.createStyleElement(`${this.terminalId}-terminal-style`);
                    const classId = 'terminal-icon-' + (0, core_1.generateUuid)().replace(/-/g, '');
                    const color = this.colorRegistry.getCurrentColor(iconClass.color.id);
                    this.styleElement.textContent = `
                        .${classId}::before {
                            color: ${color};
                        }
                    `;
                    iconClasses.push(classId);
                }
                this.title.iconClass = iconClasses.join(' ');
            }
        }
    }
    setCursorBlink(blink) {
        if (this.term.options.cursorBlink !== blink) {
            this.term.options.cursorBlink = blink;
            this.term.refresh(0, this.term.rows - 1);
        }
    }
    setCursorStyle(style) {
        if (this.term.options.cursorStyle !== style) {
            this.term.options.cursorStyle = (style === 'line') ? 'bar' : style;
        }
    }
    setCursorWidth(width) {
        if (this.term.options.cursorWidth !== width) {
            this.term.options.cursorWidth = width;
        }
    }
    initializeLinkHover() {
        this.linkHover = document.createElement('div');
        this.linkHover.style.position = 'fixed';
        this.linkHover.style.color = 'var(--theia-editorHoverWidget-foreground)';
        this.linkHover.style.backgroundColor = 'var(--theia-editorHoverWidget-background)';
        this.linkHover.style.borderColor = 'var(--theia-editorHoverWidget-border)';
        this.linkHover.style.borderWidth = '0.5px';
        this.linkHover.style.borderStyle = 'solid';
        this.linkHover.style.padding = '5px';
        // Above the xterm.js canvas layers:
        // https://github.com/xtermjs/xterm.js/blob/ff790236c1b205469f17a21246141f512d844295/src/renderer/Renderer.ts#L41-L46
        this.linkHover.style.zIndex = '10';
        // Initially invisible:
        this.linkHover.style.display = 'none';
        this.linkHoverButton = document.createElement('a');
        this.linkHoverButton.textContent = this.linkHoverMessage();
        this.linkHoverButton.style.cursor = 'pointer';
        this.linkHover.appendChild(this.linkHoverButton);
        const cmdCtrl = common_1.isOSX ? 'cmd' : 'ctrl';
        const cmdHint = document.createTextNode(` (${nls_1.nls.localizeByDefault(`${cmdCtrl} + click`)})`);
        this.linkHover.appendChild(cmdHint);
        const onMouseEnter = (mouseEvent) => this.onMouseEnterLinkHoverEmitter.fire(mouseEvent);
        this.linkHover.addEventListener('mouseenter', onMouseEnter);
        this.toDispose.push(core_1.Disposable.create(() => this.linkHover.removeEventListener('mouseenter', onMouseEnter)));
        const onMouseLeave = (mouseEvent) => this.onMouseLeaveLinkHoverEmitter.fire(mouseEvent);
        this.linkHover.addEventListener('mouseleave', onMouseLeave);
        this.toDispose.push(core_1.Disposable.create(() => this.linkHover.removeEventListener('mouseleave', onMouseLeave)));
        this.node.appendChild(this.linkHover);
    }
    showLinkHover(invokeAction, x, y, message) {
        var _a, _b, _c, _d;
        const mouseY = (_b = (_a = this.lastMousePosition) === null || _a === void 0 ? void 0 : _a.y) !== null && _b !== void 0 ? _b : y;
        const mouseX = (_d = (_c = this.lastMousePosition) === null || _c === void 0 ? void 0 : _c.x) !== null && _d !== void 0 ? _d : x;
        this.linkHoverButton.textContent = this.linkHoverMessage(message);
        this.linkHoverButton.onclick = (mouseEvent) => invokeAction(mouseEvent);
        this.linkHover.style.display = 'inline';
        this.linkHover.style.top = `${mouseY - 30}px`;
        this.linkHover.style.left = `${mouseX - 60}px`;
    }
    linkHoverMessage(message) {
        return message !== null && message !== void 0 ? message : nls_1.nls.localizeByDefault('Follow link');
    }
    hideLinkHover() {
        this.linkHover.style.display = 'none';
        // eslint-disable-next-line no-null/no-null
        this.linkHoverButton.onclick = null;
    }
    getTerminal() {
        return this.term;
    }
    getSearchBox() {
        return this.searchBox;
    }
    onCloseRequest(msg) {
        this.exitStatus = { code: undefined, reason: base_terminal_protocol_1.TerminalExitReason.User };
        super.onCloseRequest(msg);
    }
    get dimensions() {
        return {
            cols: this.term.cols,
            rows: this.term.rows,
        };
    }
    get cwd() {
        if (!base_terminal_protocol_1.IBaseTerminalServer.validateId(this.terminalId)) {
            return Promise.reject(new Error('terminal is not started'));
        }
        if (this.terminalService.getById(this.id)) {
            return this.shellTerminalServer.getCwdURI(this.terminalId)
                .then(cwdUrl => {
                this.lastCwd = new uri_1.default(cwdUrl);
                return this.lastCwd;
            }).catch(() => this.lastCwd);
        }
        return Promise.resolve(new uri_1.default());
    }
    get processId() {
        if (!base_terminal_protocol_1.IBaseTerminalServer.validateId(this.terminalId)) {
            return Promise.reject(new Error('terminal is not started'));
        }
        return this.shellTerminalServer.getProcessId(this.terminalId);
    }
    get processInfo() {
        if (!base_terminal_protocol_1.IBaseTerminalServer.validateId(this.terminalId)) {
            return Promise.reject(new Error('terminal is not started'));
        }
        return this.shellTerminalServer.getProcessInfo(this.terminalId);
    }
    get envVarCollectionDescriptionsByExtension() {
        if (!base_terminal_protocol_1.IBaseTerminalServer.validateId(this.terminalId)) {
            return Promise.reject(new Error('terminal is not started'));
        }
        return this.shellTerminalServer.getEnvVarCollectionDescriptionsByExtension(this.terminalId);
    }
    get terminalId() {
        return this._terminalId;
    }
    get lastTouchEndEvent() {
        return this.lastTouchEnd;
    }
    get hiddenFromUser() {
        var _a;
        if (this.shown) {
            return false;
        }
        return (_a = this.options.hideFromUser) !== null && _a !== void 0 ? _a : false;
    }
    get transient() {
        // The terminal is transient if session persistence is disabled or it's explicitly marked as transient
        return !this.preferences['terminal.integrated.enablePersistentSessions'] || !!this.options.isTransient;
    }
    onDispose(onDispose) {
        this.toDispose.push(core_1.Disposable.create(onDispose));
    }
    clearOutput() {
        this.term.clear();
    }
    selectAll() {
        this.term.selectAll();
    }
    async hasChildProcesses() {
        return this.shellTerminalServer.hasChildProcesses(await this.processId);
    }
    storeState() {
        this.closeOnDispose = false;
        if (this.transient || this.options.isPseudoTerminal) {
            return {};
        }
        return { terminalId: this.terminalId, titleLabel: this.title.label };
    }
    restoreState(oldState) {
        // transient terminals and pseudo terminals are not restored
        if (this.transient || this.options.isPseudoTerminal) {
            this.dispose();
            return;
        }
        if (this.restored === false) {
            const state = oldState;
            /* This is a workaround to issue #879 */
            this.restored = true;
            this.title.label = state.titleLabel;
            this.start(state.terminalId);
        }
    }
    /**
     * Create a new shell terminal in the back-end and attach it to a
     * new terminal widget.
     * If id is provided attach to the terminal for this id.
     */
    async start(id) {
        this._terminalId = typeof id !== 'number' ? await this.createTerminal() : await this.attachTerminal(id);
        this.resizeTerminalProcess();
        this.connectTerminalProcess();
        if (base_terminal_protocol_1.IBaseTerminalServer.validateId(this.terminalId)) {
            this.onDidOpenEmitter.fire(undefined);
            await this.shellTerminalServer.onAttachAttempted(this._terminalId);
            return this.terminalId;
        }
        this.onDidOpenFailureEmitter.fire(undefined);
        throw new Error('Failed to start terminal' + (id ? ` for id: ${id}.` : '.'));
    }
    async attachTerminal(id) {
        const terminalId = await this.shellTerminalServer.attach(id);
        if (base_terminal_protocol_1.IBaseTerminalServer.validateId(terminalId)) {
            // reset exit status if a new terminal process is attached
            this.exitStatus = undefined;
            return terminalId;
        }
        this.logger.warn(`Failed attaching to terminal id ${id}, the terminal is most likely gone. Starting up a new terminal instead.`);
        if (this.kind === 'user') {
            return this.createTerminal();
        }
        else {
            return -1;
        }
    }
    async createTerminal() {
        var _a, _b;
        let rootURI = (_a = this.options.cwd) === null || _a === void 0 ? void 0 : _a.toString();
        if (!rootURI) {
            const root = (await this.workspaceService.roots)[0];
            rootURI = (_b = root === null || root === void 0 ? void 0 : root.resource) === null || _b === void 0 ? void 0 : _b.toString();
        }
        const { cols, rows } = this.term;
        const terminalId = await this.shellTerminalServer.create({
            shell: this.options.shellPath || this.shellPreferences.shell[core_1.OS.backend.type()],
            args: this.options.shellArgs || this.shellPreferences.shellArgs[core_1.OS.backend.type()],
            env: this.options.env,
            strictEnv: this.options.strictEnv,
            isPseudo: this.options.isPseudoTerminal,
            rootURI,
            cols,
            rows
        });
        if (base_terminal_protocol_1.IBaseTerminalServer.validateId(terminalId)) {
            return terminalId;
        }
        throw new Error('Error creating terminal widget, see the backend error log for more information.');
    }
    processMessage(msg) {
        super.processMessage(msg);
        switch (msg.type) {
            case 'fit-request':
                this.onFitRequest(msg);
                break;
            default:
                break;
        }
    }
    onFitRequest(msg) {
        super.onFitRequest(msg);
        browser_1.MessageLoop.sendMessage(this, browser_1.Widget.ResizeMessage.UnknownSize);
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this.term.focus();
    }
    onAfterShow(msg) {
        super.onAfterShow(msg);
        this.update();
        this.shown = true;
    }
    onAfterAttach(msg) {
        browser_1.Widget.attach(this.searchBox, this.node);
        super.onAfterAttach(msg);
        this.update();
    }
    onBeforeDetach(msg) {
        browser_1.Widget.detach(this.searchBox);
        super.onBeforeDetach(msg);
    }
    onResize(msg) {
        super.onResize(msg);
        this.needsResize = true;
        this.update();
    }
    onUpdateRequest(msg) {
        super.onUpdateRequest(msg);
        if (!this.isVisible || !this.isAttached) {
            return;
        }
        this.open();
        if (this.needsResize) {
            this.resizeTerminal();
            this.needsResize = false;
        }
    }
    connectTerminalProcess() {
        if (typeof this.terminalId !== 'number') {
            return;
        }
        if (this.options.isPseudoTerminal) {
            return;
        }
        this.toDisposeOnConnect.dispose();
        this.toDispose.push(this.toDisposeOnConnect);
        const waitForConnection = this.waitForConnection = new promise_util_1.Deferred();
        this.connectionProvider.listen(`${terminal_protocol_1.terminalsPath}/${this.terminalId}`, (path, connection) => {
            connection.onMessage(e => {
                this.write(e().readString());
            });
            // Excludes the device status code emitted by Xterm.js
            const sendData = (data) => {
                if (data && !this.deviceStatusCodes.has(data) && !this.disableEnterWhenAttachCloseListener()) {
                    connection.getWriteBuffer().writeString(data).commit();
                }
            };
            const disposable = new core_1.DisposableCollection();
            disposable.push(this.term.onData(sendData));
            disposable.push(this.term.onBinary(sendData));
            connection.onClose(() => disposable.dispose());
            if (waitForConnection) {
                waitForConnection.resolve(connection);
            }
        }, false);
    }
    async reconnectTerminalProcess() {
        if (this.options.isPseudoTerminal) {
            return;
        }
        if (typeof this.terminalId === 'number') {
            await this.start(this.terminalId);
        }
    }
    open() {
        if (this.termOpened) {
            return;
        }
        this.term.open(this.node);
        // Workaround for https://github.com/xtermjs/xterm.js/issues/4775. Can be removed for releases > 5.3.0
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        const viewPort = this.term._core.viewport;
        viewPort.register(core_1.Disposable.create(() => {
            if (typeof viewPort._refreshAnimationFrame === 'number') {
                viewPort._coreBrowserService.window.cancelAnimationFrame(viewPort._refreshAnimationFrame);
            }
        }));
        if (browser_1.isFirefox) {
            // monkey patching intersection observer handling for secondary window support
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            const renderService = this.term._core._renderService;
            const originalFunc = renderService._handleIntersectionChange.bind(renderService);
            const replacement = function (entry) {
                if (entry.target.ownerDocument !== document) {
                    // in Firefox, the intersection observer always reports the widget as non-intersecting if the dom element
                    // is in a different document from when the IntersectionObserver started observing. Since we know
                    // that the widget is always "visible" when in a secondary window, so we refresh the rows ourselves
                    const patchedEvent = {
                        ...entry,
                        isIntersecting: true,
                    };
                    originalFunc(patchedEvent);
                }
                else {
                    originalFunc(entry);
                }
            };
            renderService._handleIntersectionChange = replacement.bind(renderService);
        }
        if (this.initialData) {
            this.term.write(this.initialData);
        }
        this.termOpened = true;
        this.initialData = '';
    }
    write(data) {
        if (this.termOpened) {
            this.term.write(data);
            this.onOutputEmitter.fire(data);
        }
        else {
            this.initialData += data;
        }
    }
    resize(cols, rows) {
        this.term.resize(cols, rows);
    }
    sendText(text) {
        if (this.waitForConnection) {
            this.waitForConnection.promise.then(connection => connection.getWriteBuffer().writeString(text).commit());
        }
    }
    async executeCommand(commandOptions) {
        this.sendText(this.shellCommandBuilder.buildCommand(await this.processInfo, commandOptions) + core_1.OS.backend.EOL);
    }
    scrollLineUp() {
        this.term.scrollLines(-1);
    }
    scrollLineDown() {
        this.term.scrollLines(1);
    }
    scrollToTop() {
        this.term.scrollToTop();
    }
    scrollToBottom() {
        this.term.scrollToBottom();
    }
    scrollPageUp() {
        this.term.scrollPages(-1);
    }
    scrollPageDown() {
        this.term.scrollPages(1);
    }
    resetTerminal() {
        this.term.reset();
    }
    writeLine(text) {
        this.term.writeln(text);
        this.onOutputEmitter.fire(text + '\n');
    }
    get onTerminalDidClose() {
        return this.onTermDidClose.event;
    }
    dispose() {
        var _a, _b;
        if (this.closeOnDispose === true && typeof this.terminalId === 'number' && !((_a = this.exitStatus) === null || _a === void 0 ? void 0 : _a.code)) {
            // Close the backend terminal only when explicitly closing the terminal
            // a refresh for example won't close it.
            this.shellTerminalServer.close(this.terminalId);
            // Exit status is set when terminal is closed by user or by process, so most likely an extension closed it.
            this.exitStatus = { code: undefined, reason: base_terminal_protocol_1.TerminalExitReason.Extension };
        }
        if (this.exitStatus) {
            this.onTermDidClose.fire(this);
        }
        if (this.enhancedPreviewNode) {
            // don't use preview node anymore. rendered markdown will be disposed on super call
            this.enhancedPreviewNode = undefined;
        }
        (_b = this.styleElement) === null || _b === void 0 ? void 0 : _b.remove();
        super.dispose();
    }
    doResizeTerminal() {
        if (this.isDisposed) {
            return;
        }
        const geo = this.fitAddon.proposeDimensions();
        if (geo) {
            const cols = geo.cols;
            const rows = geo.rows - 1; // subtract one row for margin
            this.term.resize(cols, rows);
            this.resizeTerminalProcess();
        }
    }
    resizeTerminalProcess() {
        if (this.options.isPseudoTerminal) {
            return;
        }
        if (!base_terminal_protocol_1.IBaseTerminalServer.validateId(this.terminalId)
            || this.exitStatus
            || !this.terminalService.getById(this.id)) {
            return;
        }
        const { cols, rows } = this.term;
        this.shellTerminalServer.resize(this.terminalId, cols, rows);
    }
    get enableCopy() {
        return this.preferences['terminal.enableCopy'];
    }
    get enablePaste() {
        return this.preferences['terminal.enablePaste'];
    }
    get shellPreferences() {
        var _a, _b, _c;
        return {
            shell: {
                Windows: (_a = this.preferences['terminal.integrated.shell.windows']) !== null && _a !== void 0 ? _a : undefined,
                Linux: (_b = this.preferences['terminal.integrated.shell.linux']) !== null && _b !== void 0 ? _b : undefined,
                OSX: (_c = this.preferences['terminal.integrated.shell.osx']) !== null && _c !== void 0 ? _c : undefined,
            },
            shellArgs: {
                Windows: this.preferences['terminal.integrated.shellArgs.windows'],
                Linux: this.preferences['terminal.integrated.shellArgs.linux'],
                OSX: this.preferences['terminal.integrated.shellArgs.osx'],
            }
        };
    }
    customKeyHandler(event) {
        const keyBindings = browser_1.KeyCode.createKeyCode(event).toString();
        const ctrlCmdCopy = (common_1.isOSX && keyBindings === 'meta+c') || (!common_1.isOSX && keyBindings === 'ctrl+c');
        const ctrlCmdPaste = (common_1.isOSX && keyBindings === 'meta+v') || (!common_1.isOSX && keyBindings === 'ctrl+v');
        if (ctrlCmdCopy && this.enableCopy && this.term.hasSelection()) {
            return false;
        }
        if (ctrlCmdPaste && this.enablePaste) {
            return false;
        }
        return true;
    }
    get copyOnSelection() {
        return this.preferences['terminal.integrated.copyOnSelection'];
    }
    attachCustomKeyEventHandler() {
        this.term.attachCustomKeyEventHandler(e => this.customKeyHandler(e));
    }
    setTitle(title) {
        this.title.caption = title;
        this.title.label = title;
    }
    waitOnExit(waitOnExit) {
        if (waitOnExit) {
            if (typeof waitOnExit === 'string') {
                let message = waitOnExit;
                // Bold the message and add an extra new line to make it stand out from the rest of the output
                message = `\r\n\x1b[1m${message}\x1b[0m`;
                this.write(message);
            }
            this.attachPressEnterKeyToCloseListener(this.term);
            return;
        }
        this.dispose();
    }
    attachPressEnterKeyToCloseListener(term) {
        if (term.textarea) {
            this.isAttachedCloseListener = true;
            this.addKeyListener(term.textarea, keys_1.Key.ENTER, (event) => {
                this.dispose();
                this.isAttachedCloseListener = false;
            });
        }
    }
    disableEnterWhenAttachCloseListener() {
        return this.isAttachedCloseListener;
    }
    getEnhancedPreviewNode() {
        if (this.enhancedPreviewNode) {
            return this.enhancedPreviewNode;
        }
        this.enhancedPreviewNode = document.createElement('div');
        Promise.all([this.envVarCollectionDescriptionsByExtension, this.processId, this.processInfo])
            .then((values) => {
            const extensions = values[0];
            const processId = values[1];
            const processInfo = values[2];
            const markdown = new markdown_string_1.MarkdownStringImpl();
            markdown.appendMarkdown('Process ID: ' + processId + '\\\n');
            markdown.appendMarkdown('Command line: ' +
                processInfo.executable +
                ' ' +
                processInfo.arguments.join(' ') +
                '\n\n---\n\n');
            markdown.appendMarkdown('The following extensions have contributed to this terminal\'s environment:\n');
            extensions.forEach((arr, key) => {
                arr.forEach(value => {
                    if (value === undefined) {
                        markdown.appendMarkdown('* ' + key + '\n');
                    }
                    else if (typeof value === 'string') {
                        markdown.appendMarkdown('* ' + key + ': ' + value + '\n');
                    }
                    else {
                        markdown.appendMarkdown('* ' + key + ': ' + value.value + '\n');
                    }
                });
            });
            const enhancedPreviewNode = this.enhancedPreviewNode;
            if (!this.isDisposed && enhancedPreviewNode) {
                const result = this.markdownRenderer.render(markdown);
                this.toDispose.push(result);
                enhancedPreviewNode.appendChild(result.element);
            }
        });
        return this.enhancedPreviewNode;
    }
};
exports.TerminalWidgetImpl = TerminalWidgetImpl;
TerminalWidgetImpl.LABEL = nls_1.nls.localizeByDefault('Terminal');
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.WorkspaceService),
    tslib_1.__metadata("design:type", browser_2.WorkspaceService)
], TerminalWidgetImpl.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(service_connection_provider_1.RemoteConnectionProvider),
    tslib_1.__metadata("design:type", service_connection_provider_1.ServiceConnectionProvider)
], TerminalWidgetImpl.prototype, "connectionProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(terminal_widget_1.TerminalWidgetOptions),
    tslib_1.__metadata("design:type", Object)
], TerminalWidgetImpl.prototype, "options", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(shell_terminal_protocol_1.ShellTerminalServerProxy),
    tslib_1.__metadata("design:type", Object)
], TerminalWidgetImpl.prototype, "shellTerminalServer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(terminal_watcher_1.TerminalWatcher),
    tslib_1.__metadata("design:type", terminal_watcher_1.TerminalWatcher)
], TerminalWidgetImpl.prototype, "terminalWatcher", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ILogger),
    (0, inversify_1.named)('terminal'),
    tslib_1.__metadata("design:type", Object)
], TerminalWidgetImpl.prototype, "logger", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)('terminal-dom-id'),
    tslib_1.__metadata("design:type", String)
], TerminalWidgetImpl.prototype, "_terminalDOMId", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(terminal_preferences_1.TerminalPreferences),
    tslib_1.__metadata("design:type", Object)
], TerminalWidgetImpl.prototype, "preferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.ContributionProvider),
    (0, inversify_1.named)(exports.TerminalContribution),
    tslib_1.__metadata("design:type", Object)
], TerminalWidgetImpl.prototype, "terminalContributionProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(terminal_service_1.TerminalService),
    tslib_1.__metadata("design:type", Object)
], TerminalWidgetImpl.prototype, "terminalService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(terminal_search_widget_1.TerminalSearchWidgetFactory),
    tslib_1.__metadata("design:type", Function)
], TerminalWidgetImpl.prototype, "terminalSearchBoxFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(terminal_copy_on_selection_handler_1.TerminalCopyOnSelectionHandler),
    tslib_1.__metadata("design:type", terminal_copy_on_selection_handler_1.TerminalCopyOnSelectionHandler)
], TerminalWidgetImpl.prototype, "copyOnSelectionHandler", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(terminal_theme_service_1.TerminalThemeService),
    tslib_1.__metadata("design:type", terminal_theme_service_1.TerminalThemeService)
], TerminalWidgetImpl.prototype, "themeService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(color_registry_1.ColorRegistry),
    tslib_1.__metadata("design:type", color_registry_1.ColorRegistry)
], TerminalWidgetImpl.prototype, "colorRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(shell_command_builder_1.ShellCommandBuilder),
    tslib_1.__metadata("design:type", shell_command_builder_1.ShellCommandBuilder)
], TerminalWidgetImpl.prototype, "shellCommandBuilder", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ContextMenuRenderer),
    tslib_1.__metadata("design:type", browser_1.ContextMenuRenderer)
], TerminalWidgetImpl.prototype, "contextMenuRenderer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(markdown_renderer_1.MarkdownRendererFactory),
    tslib_1.__metadata("design:type", Function)
], TerminalWidgetImpl.prototype, "markdownRendererFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TerminalWidgetImpl.prototype, "init", null);
exports.TerminalWidgetImpl = TerminalWidgetImpl = TerminalWidgetImpl_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TerminalWidgetImpl);


/***/ }),

/***/ "../../node_modules/@theia/terminal/lib/common/base-terminal-protocol.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/common/base-terminal-protocol.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2017 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DispatchingBaseTerminalClient = exports.TerminalExitReason = exports.IBaseTerminalServer = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
var IBaseTerminalServer;
(function (IBaseTerminalServer) {
    function validateId(id) {
        return typeof id === 'number' && id !== -1;
    }
    IBaseTerminalServer.validateId = validateId;
})(IBaseTerminalServer || (exports.IBaseTerminalServer = IBaseTerminalServer = {}));
var TerminalExitReason;
(function (TerminalExitReason) {
    TerminalExitReason[TerminalExitReason["Unknown"] = 0] = "Unknown";
    TerminalExitReason[TerminalExitReason["Shutdown"] = 1] = "Shutdown";
    TerminalExitReason[TerminalExitReason["Process"] = 2] = "Process";
    TerminalExitReason[TerminalExitReason["User"] = 3] = "User";
    TerminalExitReason[TerminalExitReason["Extension"] = 4] = "Extension";
})(TerminalExitReason || (exports.TerminalExitReason = TerminalExitReason = {}));
class DispatchingBaseTerminalClient {
    constructor() {
        this.clients = new Set();
    }
    push(client) {
        this.clients.add(client);
        return core_1.Disposable.create(() => this.clients.delete(client));
    }
    onTerminalExitChanged(event) {
        this.clients.forEach(c => {
            try {
                c.onTerminalExitChanged(event);
            }
            catch (e) {
                console.error(e);
            }
        });
    }
    onTerminalError(event) {
        this.clients.forEach(c => {
            try {
                c.onTerminalError(event);
            }
            catch (e) {
                console.error(e);
            }
        });
    }
    updateTerminalEnvVariables() {
        this.clients.forEach(c => {
            try {
                c.updateTerminalEnvVariables();
            }
            catch (e) {
                console.error(e);
            }
        });
    }
    storeTerminalEnvVariables(data) {
        this.clients.forEach(c => {
            try {
                c.storeTerminalEnvVariables(data);
            }
            catch (e) {
                console.error(e);
            }
        });
    }
}
exports.DispatchingBaseTerminalClient = DispatchingBaseTerminalClient;


/***/ }),

/***/ "../../node_modules/@theia/terminal/lib/common/terminal-protocol.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/common/terminal-protocol.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2017 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.terminalsPath = exports.terminalPath = exports.ITerminalServer = void 0;
exports.ITerminalServer = Symbol('ITerminalServer');
exports.terminalPath = '/services/terminal';
exports.terminalsPath = '/services/terminals';


/***/ }),

/***/ "../../node_modules/@theia/terminal/lib/common/terminal-watcher.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/lib/common/terminal-watcher.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2017 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TerminalWatcher = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const event_1 = __webpack_require__(/*! @theia/core/lib/common/event */ "../../node_modules/@theia/core/lib/common/event.js");
let TerminalWatcher = class TerminalWatcher {
    constructor() {
        this.onTerminalExitEmitter = new event_1.Emitter();
        this.onTerminalErrorEmitter = new event_1.Emitter();
        this.onStoreTerminalEnvVariablesRequestedEmitter = new event_1.Emitter();
        this.onUpdateTerminalEnvVariablesRequestedEmitter = new event_1.Emitter();
    }
    getTerminalClient() {
        const exitEmitter = this.onTerminalExitEmitter;
        const errorEmitter = this.onTerminalErrorEmitter;
        const storeTerminalEnvVariablesEmitter = this.onStoreTerminalEnvVariablesRequestedEmitter;
        const updateTerminalEnvVariablesEmitter = this.onUpdateTerminalEnvVariablesRequestedEmitter;
        return {
            storeTerminalEnvVariables(data) {
                storeTerminalEnvVariablesEmitter.fire(data);
            },
            updateTerminalEnvVariables() {
                updateTerminalEnvVariablesEmitter.fire(undefined);
            },
            onTerminalExitChanged(event) {
                exitEmitter.fire(event);
            },
            onTerminalError(event) {
                errorEmitter.fire(event);
            }
        };
    }
    get onTerminalExit() {
        return this.onTerminalExitEmitter.event;
    }
    get onTerminalError() {
        return this.onTerminalErrorEmitter.event;
    }
    get onStoreTerminalEnvVariablesRequested() {
        return this.onStoreTerminalEnvVariablesRequestedEmitter.event;
    }
    get onUpdateTerminalEnvVariablesRequested() {
        return this.onUpdateTerminalEnvVariablesRequestedEmitter.event;
    }
};
exports.TerminalWatcher = TerminalWatcher;
exports.TerminalWatcher = TerminalWatcher = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TerminalWatcher);


/***/ }),

/***/ "../../node_modules/@theia/terminal/src/browser/style/terminal-search.css":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/terminal/src/browser/style/terminal-search.css ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_cjs_js_terminal_search_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../css-loader/dist/cjs.js!./terminal-search.css */ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/terminal/src/browser/style/terminal-search.css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_css_loader_dist_cjs_js_terminal_search_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_css_loader_dist_cjs_js_terminal_search_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/terminal/src/browser/style/terminal-search.css":
/*!**************************************************************************************************************************!*\
  !*** ../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/terminal/src/browser/style/terminal-search.css ***!
  \**************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/api.js */ "../../node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/********************************************************************************
 * Copyright (C) 2019 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
 ********************************************************************************/

.theia-search-terminal-widget-parent {
  background: var(--theia-sideBar-background);
  position: absolute;
  margin: 0px;
  border: var(--theia-border-width) solid transparent;
  padding: 0px;
  top: 1px;
  right: 19px;

  z-index: 10;
}

.theia-search-terminal-widget-parent .theia-search-elem-box {
  display: flex;
  margin: 0px;
  border: var(--theia-border-width) solid transparent;
  padding: 0px;
  align-items: center;
  color: var(--theia-input-foreground);
  background: var(--theia-input-background);
}

.theia-search-terminal-widget-parent .theia-search-elem-box input {
  margin-left: 5px;
  padding: 0px;
  width: 100px;
  height: 18px;
  color: inherit;
  background-color: inherit;
  border: var(--theia-border-width) solid transparent;
  outline: none;
}

.theia-search-terminal-widget-parent
  .theia-search-elem-box
  .search-elem.codicon {
  height: 16px;
  width: 18px;
}

.theia-search-terminal-widget-parent .search-elem.codicon {
  border: var(--theia-border-width) solid transparent;
  height: 20px;
  width: 20px;
  opacity: 0.7;
  outline: none;
  color: var(--theia-input-foreground);
  padding: 0px;
  margin-left: 3px;
}

.theia-search-terminal-widget-parent .search-elem:hover {
  opacity: 1;
}

.theia-search-terminal-widget-parent .theia-search-elem-box.focused {
  border: var(--theia-border-width) solid var(--theia-focusBorder);
}

.theia-search-terminal-widget-parent
  .theia-search-elem-box
  .search-elem.option-enabled {
  border: var(--theia-border-width) solid var(--theia-inputOption-activeBorder);
  background-color: var(--theia-inputOption-activeBackground);
}

.theia-search-terminal-widget-parent .theia-search-terminal-widget {
  margin: 2px;
  display: flex;
  align-items: center;
  font: var(--theia-content-font-size);
  color: var(--theia-input-foreground);
}

.theia-search-terminal-widget-parent .theia-search-terminal-widget button {
  background-color: transparent;
}

.theia-search-terminal-widget-parent
  .theia-search-terminal-widget
  button:focus {
  border: var(--theia-border-width) var(--theia-focusBorder) solid;
}
`, "",{"version":3,"sources":["webpack://./../../node_modules/@theia/terminal/src/browser/style/terminal-search.css"],"names":[],"mappings":"AAAA;;;;;;;;;;;;;;iFAciF;;AAEjF;EACE,2CAA2C;EAC3C,kBAAkB;EAClB,WAAW;EACX,mDAAmD;EACnD,YAAY;EACZ,QAAQ;EACR,WAAW;;EAEX,WAAW;AACb;;AAEA;EACE,aAAa;EACb,WAAW;EACX,mDAAmD;EACnD,YAAY;EACZ,mBAAmB;EACnB,oCAAoC;EACpC,yCAAyC;AAC3C;;AAEA;EACE,gBAAgB;EAChB,YAAY;EACZ,YAAY;EACZ,YAAY;EACZ,cAAc;EACd,yBAAyB;EACzB,mDAAmD;EACnD,aAAa;AACf;;AAEA;;;EAGE,YAAY;EACZ,WAAW;AACb;;AAEA;EACE,mDAAmD;EACnD,YAAY;EACZ,WAAW;EACX,YAAY;EACZ,aAAa;EACb,oCAAoC;EACpC,YAAY;EACZ,gBAAgB;AAClB;;AAEA;EACE,UAAU;AACZ;;AAEA;EACE,gEAAgE;AAClE;;AAEA;;;EAGE,6EAA6E;EAC7E,2DAA2D;AAC7D;;AAEA;EACE,WAAW;EACX,aAAa;EACb,mBAAmB;EACnB,oCAAoC;EACpC,oCAAoC;AACtC;;AAEA;EACE,6BAA6B;AAC/B;;AAEA;;;EAGE,gEAAgE;AAClE","sourcesContent":["/********************************************************************************\n * Copyright (C) 2019 Red Hat, Inc. and others.\n *\n * This program and the accompanying materials are made available under the\n * terms of the Eclipse Public License v. 2.0 which is available at\n * http://www.eclipse.org/legal/epl-2.0.\n *\n * This Source Code may also be made available under the following Secondary\n * Licenses when the conditions for such availability set forth in the Eclipse\n * Public License v. 2.0 are satisfied: GNU General Public License, version 2\n * with the GNU Classpath Exception which is available at\n * https://www.gnu.org/software/classpath/license.html.\n *\n * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0\n ********************************************************************************/\n\n.theia-search-terminal-widget-parent {\n  background: var(--theia-sideBar-background);\n  position: absolute;\n  margin: 0px;\n  border: var(--theia-border-width) solid transparent;\n  padding: 0px;\n  top: 1px;\n  right: 19px;\n\n  z-index: 10;\n}\n\n.theia-search-terminal-widget-parent .theia-search-elem-box {\n  display: flex;\n  margin: 0px;\n  border: var(--theia-border-width) solid transparent;\n  padding: 0px;\n  align-items: center;\n  color: var(--theia-input-foreground);\n  background: var(--theia-input-background);\n}\n\n.theia-search-terminal-widget-parent .theia-search-elem-box input {\n  margin-left: 5px;\n  padding: 0px;\n  width: 100px;\n  height: 18px;\n  color: inherit;\n  background-color: inherit;\n  border: var(--theia-border-width) solid transparent;\n  outline: none;\n}\n\n.theia-search-terminal-widget-parent\n  .theia-search-elem-box\n  .search-elem.codicon {\n  height: 16px;\n  width: 18px;\n}\n\n.theia-search-terminal-widget-parent .search-elem.codicon {\n  border: var(--theia-border-width) solid transparent;\n  height: 20px;\n  width: 20px;\n  opacity: 0.7;\n  outline: none;\n  color: var(--theia-input-foreground);\n  padding: 0px;\n  margin-left: 3px;\n}\n\n.theia-search-terminal-widget-parent .search-elem:hover {\n  opacity: 1;\n}\n\n.theia-search-terminal-widget-parent .theia-search-elem-box.focused {\n  border: var(--theia-border-width) solid var(--theia-focusBorder);\n}\n\n.theia-search-terminal-widget-parent\n  .theia-search-elem-box\n  .search-elem.option-enabled {\n  border: var(--theia-border-width) solid var(--theia-inputOption-activeBorder);\n  background-color: var(--theia-inputOption-activeBackground);\n}\n\n.theia-search-terminal-widget-parent .theia-search-terminal-widget {\n  margin: 2px;\n  display: flex;\n  align-items: center;\n  font: var(--theia-content-font-size);\n  color: var(--theia-input-foreground);\n}\n\n.theia-search-terminal-widget-parent .theia-search-terminal-widget button {\n  background-color: transparent;\n}\n\n.theia-search-terminal-widget-parent\n  .theia-search-terminal-widget\n  button:focus {\n  border: var(--theia-border-width) var(--theia-focusBorder) solid;\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "../../node_modules/xterm-addon-search/lib/xterm-addon-search.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/xterm-addon-search/lib/xterm-addon-search.js ***!
  \***********************************************************************/
/***/ ((module) => {

!function(e,t){ true?module.exports=t():0}(self,(()=>(()=>{"use strict";var e={345:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.forwardEvent=t.EventEmitter=void 0,t.EventEmitter=class{constructor(){this._listeners=[],this._disposed=!1}get event(){return this._event||(this._event=e=>(this._listeners.push(e),{dispose:()=>{if(!this._disposed)for(let t=0;t<this._listeners.length;t++)if(this._listeners[t]===e)return void this._listeners.splice(t,1)}})),this._event}fire(e,t){const i=[];for(let e=0;e<this._listeners.length;e++)i.push(this._listeners[e]);for(let s=0;s<i.length;s++)i[s].call(void 0,e,t)}dispose(){this.clearListeners(),this._disposed=!0}clearListeners(){this._listeners&&(this._listeners.length=0)}},t.forwardEvent=function(e,t){return e((e=>t.fire(e)))}},859:(e,t)=>{function i(e){for(const t of e)t.dispose();e.length=0}Object.defineProperty(t,"__esModule",{value:!0}),t.getDisposeArrayDisposable=t.disposeArray=t.toDisposable=t.MutableDisposable=t.Disposable=void 0,t.Disposable=class{constructor(){this._disposables=[],this._isDisposed=!1}dispose(){this._isDisposed=!0;for(const e of this._disposables)e.dispose();this._disposables.length=0}register(e){return this._disposables.push(e),e}unregister(e){const t=this._disposables.indexOf(e);-1!==t&&this._disposables.splice(t,1)}},t.MutableDisposable=class{constructor(){this._isDisposed=!1}get value(){return this._isDisposed?void 0:this._value}set value(e){var t;this._isDisposed||e===this._value||(null===(t=this._value)||void 0===t||t.dispose(),this._value=e)}clear(){this.value=void 0}dispose(){var e;this._isDisposed=!0,null===(e=this._value)||void 0===e||e.dispose(),this._value=void 0}},t.toDisposable=function(e){return{dispose:e}},t.disposeArray=i,t.getDisposeArrayDisposable=function(e){return{dispose:()=>i(e)}}}},t={};function i(s){var r=t[s];if(void 0!==r)return r.exports;var o=t[s]={exports:{}};return e[s](o,o.exports,i),o.exports}var s={};return(()=>{var e=s;Object.defineProperty(e,"__esModule",{value:!0}),e.SearchAddon=void 0;const t=i(345),r=i(859),o=" ~!@#$%^&*()+`-=[]{}|\\;:\"',./<>?";class n extends r.Disposable{constructor(e){var i;super(),this._highlightedLines=new Set,this._highlightDecorations=[],this._selectedDecoration=this.register(new r.MutableDisposable),this._linesCacheTimeoutId=0,this._onDidChangeResults=this.register(new t.EventEmitter),this.onDidChangeResults=this._onDidChangeResults.event,this._highlightLimit=null!==(i=null==e?void 0:e.highlightLimit)&&void 0!==i?i:1e3}activate(e){this._terminal=e,this.register(this._terminal.onWriteParsed((()=>this._updateMatches()))),this.register(this._terminal.onResize((()=>this._updateMatches()))),this.register((0,r.toDisposable)((()=>this.clearDecorations())))}_updateMatches(){var e;this._highlightTimeout&&window.clearTimeout(this._highlightTimeout),this._cachedSearchTerm&&(null===(e=this._lastSearchOptions)||void 0===e?void 0:e.decorations)&&(this._highlightTimeout=setTimeout((()=>{const e=this._cachedSearchTerm;this._cachedSearchTerm=void 0,this.findPrevious(e,Object.assign(Object.assign({},this._lastSearchOptions),{incremental:!0,noScroll:!0}))}),200))}clearDecorations(e){this._selectedDecoration.clear(),(0,r.disposeArray)(this._highlightDecorations),this._highlightDecorations=[],this._highlightedLines.clear(),e||(this._cachedSearchTerm=void 0)}findNext(e,t){if(!this._terminal)throw new Error("Cannot use addon until it has been loaded");this._lastSearchOptions=t,(null==t?void 0:t.decorations)&&(void 0!==this._cachedSearchTerm&&e===this._cachedSearchTerm||this._highlightAllMatches(e,t));const i=this._findNextAndSelect(e,t);return this._fireResults(t),this._cachedSearchTerm=e,i}_highlightAllMatches(e,t){if(!this._terminal)throw new Error("Cannot use addon until it has been loaded");if(!e||0===e.length)return void this.clearDecorations();t=t||{},this.clearDecorations(!0);const i=[];let s,r=this._find(e,0,0,t);for(;r&&((null==s?void 0:s.row)!==r.row||(null==s?void 0:s.col)!==r.col)&&!(i.length>=this._highlightLimit);)s=r,i.push(s),r=this._find(e,s.col+s.term.length>=this._terminal.cols?s.row+1:s.row,s.col+s.term.length>=this._terminal.cols?0:s.col+1,t);for(const e of i){const i=this._createResultDecoration(e,t.decorations);i&&(this._highlightedLines.add(i.marker.line),this._highlightDecorations.push({decoration:i,match:e,dispose(){i.dispose()}}))}}_find(e,t,i,s){var r;if(!this._terminal||!e||0===e.length)return null===(r=this._terminal)||void 0===r||r.clearSelection(),void this.clearDecorations();if(i>this._terminal.cols)throw new Error(`Invalid col: ${i} to search in terminal of ${this._terminal.cols} cols`);let o;this._initLinesCache();const n={startRow:t,startCol:i};if(o=this._findInLine(e,n,s),!o)for(let i=t+1;i<this._terminal.buffer.active.baseY+this._terminal.rows&&(n.startRow=i,n.startCol=0,o=this._findInLine(e,n,s),!o);i++);return o}_findNextAndSelect(e,t){var i;if(!this._terminal||!e||0===e.length)return null===(i=this._terminal)||void 0===i||i.clearSelection(),this.clearDecorations(),!1;const s=this._terminal.getSelectionPosition();this._terminal.clearSelection();let r=0,o=0;s&&(this._cachedSearchTerm===e?(r=s.end.x,o=s.end.y):(r=s.start.x,o=s.start.y)),this._initLinesCache();const n={startRow:o,startCol:r};let l=this._findInLine(e,n,t);if(!l)for(let i=o+1;i<this._terminal.buffer.active.baseY+this._terminal.rows&&(n.startRow=i,n.startCol=0,l=this._findInLine(e,n,t),!l);i++);if(!l&&0!==o)for(let i=0;i<o&&(n.startRow=i,n.startCol=0,l=this._findInLine(e,n,t),!l);i++);return!l&&s&&(n.startRow=s.start.y,n.startCol=0,l=this._findInLine(e,n,t)),this._selectResult(l,null==t?void 0:t.decorations,null==t?void 0:t.noScroll)}findPrevious(e,t){if(!this._terminal)throw new Error("Cannot use addon until it has been loaded");this._lastSearchOptions=t,(null==t?void 0:t.decorations)&&(void 0!==this._cachedSearchTerm&&e===this._cachedSearchTerm||this._highlightAllMatches(e,t));const i=this._findPreviousAndSelect(e,t);return this._fireResults(t),this._cachedSearchTerm=e,i}_fireResults(e){if(null==e?void 0:e.decorations){let e=-1;if(this._selectedDecoration.value){const t=this._selectedDecoration.value.match;for(let i=0;i<this._highlightDecorations.length;i++){const s=this._highlightDecorations[i].match;if(s.row===t.row&&s.col===t.col&&s.size===t.size){e=i;break}}}this._onDidChangeResults.fire({resultIndex:e,resultCount:this._highlightDecorations.length})}}_findPreviousAndSelect(e,t){var i;if(!this._terminal)throw new Error("Cannot use addon until it has been loaded");if(!this._terminal||!e||0===e.length)return null===(i=this._terminal)||void 0===i||i.clearSelection(),this.clearDecorations(),!1;const s=this._terminal.getSelectionPosition();this._terminal.clearSelection();let r=this._terminal.buffer.active.baseY+this._terminal.rows-1,o=this._terminal.cols;const n=!0;this._initLinesCache();const l={startRow:r,startCol:o};let h;if(s&&(l.startRow=r=s.start.y,l.startCol=o=s.start.x,this._cachedSearchTerm!==e&&(h=this._findInLine(e,l,t,!1),h||(l.startRow=r=s.end.y,l.startCol=o=s.end.x))),h||(h=this._findInLine(e,l,t,n)),!h){l.startCol=Math.max(l.startCol,this._terminal.cols);for(let i=r-1;i>=0&&(l.startRow=i,h=this._findInLine(e,l,t,n),!h);i--);}if(!h&&r!==this._terminal.buffer.active.baseY+this._terminal.rows-1)for(let i=this._terminal.buffer.active.baseY+this._terminal.rows-1;i>=r&&(l.startRow=i,h=this._findInLine(e,l,t,n),!h);i--);return this._selectResult(h,null==t?void 0:t.decorations,null==t?void 0:t.noScroll)}_initLinesCache(){const e=this._terminal;this._linesCache||(this._linesCache=new Array(e.buffer.active.length),this._cursorMoveListener=e.onCursorMove((()=>this._destroyLinesCache())),this._resizeListener=e.onResize((()=>this._destroyLinesCache()))),window.clearTimeout(this._linesCacheTimeoutId),this._linesCacheTimeoutId=window.setTimeout((()=>this._destroyLinesCache()),15e3)}_destroyLinesCache(){this._linesCache=void 0,this._cursorMoveListener&&(this._cursorMoveListener.dispose(),this._cursorMoveListener=void 0),this._resizeListener&&(this._resizeListener.dispose(),this._resizeListener=void 0),this._linesCacheTimeoutId&&(window.clearTimeout(this._linesCacheTimeoutId),this._linesCacheTimeoutId=0)}_isWholeWord(e,t,i){return(0===e||o.includes(t[e-1]))&&(e+i.length===t.length||o.includes(t[e+i.length]))}_findInLine(e,t,i={},s=!1){var r;const o=this._terminal,n=t.startRow,l=t.startCol,h=o.buffer.active.getLine(n);if(null==h?void 0:h.isWrapped)return s?void(t.startCol+=o.cols):(t.startRow--,t.startCol+=o.cols,this._findInLine(e,t,i));let a=null===(r=this._linesCache)||void 0===r?void 0:r[n];a||(a=this._translateBufferLineToStringWithWrap(n,!0),this._linesCache&&(this._linesCache[n]=a));const[c,d]=a,_=this._bufferColsToStringOffset(n,l),u=i.caseSensitive?e:e.toLowerCase(),f=i.caseSensitive?c:c.toLowerCase();let g=-1;if(i.regex){const t=RegExp(u,"g");let i;if(s)for(;i=t.exec(f.slice(0,_));)g=t.lastIndex-i[0].length,e=i[0],t.lastIndex-=e.length-1;else i=t.exec(f.slice(_)),i&&i[0].length>0&&(g=_+(t.lastIndex-i[0].length),e=i[0])}else s?_-u.length>=0&&(g=f.lastIndexOf(u,_-u.length)):g=f.indexOf(u,_);if(g>=0){if(i.wholeWord&&!this._isWholeWord(g,f,e))return;let t=0;for(;t<d.length-1&&g>=d[t+1];)t++;let s=t;for(;s<d.length-1&&g+e.length>=d[s+1];)s++;const r=g-d[t],l=g+e.length-d[s],h=this._stringLengthToBufferSize(n+t,r);return{term:e,col:h,row:n+t,size:this._stringLengthToBufferSize(n+s,l)-h+o.cols*(s-t)}}}_stringLengthToBufferSize(e,t){const i=this._terminal.buffer.active.getLine(e);if(!i)return 0;for(let e=0;e<t;e++){const s=i.getCell(e);if(!s)break;const r=s.getChars();r.length>1&&(t-=r.length-1);const o=i.getCell(e+1);o&&0===o.getWidth()&&t++}return t}_bufferColsToStringOffset(e,t){const i=this._terminal;let s=e,r=0,o=i.buffer.active.getLine(s);for(;t>0&&o;){for(let e=0;e<t&&e<i.cols;e++){const t=o.getCell(e);if(!t)break;t.getWidth()&&(r+=0===t.getCode()?1:t.getChars().length)}if(s++,o=i.buffer.active.getLine(s),o&&!o.isWrapped)break;t-=i.cols}return r}_translateBufferLineToStringWithWrap(e,t){var i;const s=this._terminal,r=[],o=[0];let n=s.buffer.active.getLine(e);for(;n;){const l=s.buffer.active.getLine(e+1),h=!!l&&l.isWrapped;let a=n.translateToString(!h&&t);if(h&&l){const e=n.getCell(n.length-1);e&&0===e.getCode()&&1===e.getWidth()&&2===(null===(i=l.getCell(0))||void 0===i?void 0:i.getWidth())&&(a=a.slice(0,-1))}if(r.push(a),!h)break;o.push(o[o.length-1]+a.length),e++,n=l}return[r.join(""),o]}_selectResult(e,t,i){const s=this._terminal;if(this._selectedDecoration.clear(),!e)return s.clearSelection(),!1;if(s.select(e.col,e.row,e.size),t){const i=s.registerMarker(-s.buffer.active.baseY-s.buffer.active.cursorY+e.row);if(i){const o=s.registerDecoration({marker:i,x:e.col,width:e.size,backgroundColor:t.activeMatchBackground,layer:"top",overviewRulerOptions:{color:t.activeMatchColorOverviewRuler}});if(o){const s=[];s.push(i),s.push(o.onRender((e=>this._applyStyles(e,t.activeMatchBorder,!0)))),s.push(o.onDispose((()=>(0,r.disposeArray)(s)))),this._selectedDecoration.value={decoration:o,match:e,dispose(){o.dispose()}}}}}if(!i&&(e.row>=s.buffer.active.viewportY+s.rows||e.row<s.buffer.active.viewportY)){let t=e.row-s.buffer.active.viewportY;t-=Math.floor(s.rows/2),s.scrollLines(t)}return!0}_applyStyles(e,t,i){e.classList.contains("xterm-find-result-decoration")||(e.classList.add("xterm-find-result-decoration"),t&&(e.style.outline=`1px solid ${t}`)),i&&e.classList.add("xterm-find-active-result-decoration")}_createResultDecoration(e,t){const i=this._terminal,s=i.registerMarker(-i.buffer.active.baseY-i.buffer.active.cursorY+e.row);if(!s)return;const o=i.registerDecoration({marker:s,x:e.col,width:e.size,backgroundColor:t.matchBackground,overviewRulerOptions:this._highlightedLines.has(s.line)?void 0:{color:t.matchOverviewRuler,position:"center"}});if(o){const e=[];e.push(s),e.push(o.onRender((e=>this._applyStyles(e,t.matchBorder,!1)))),e.push(o.onDispose((()=>(0,r.disposeArray)(e))))}return o}}e.SearchAddon=n})(),s})()));


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_terminal_lib_browser_terminal-widget-impl_js.js.map