"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.provideSignatureHelp = exports.Context = void 0;
const cancellation_1 = require("../../../../base/common/cancellation");
const errors_1 = require("../../../../base/common/errors");
const types_1 = require("../../../../base/common/types");
const uri_1 = require("../../../../base/common/uri");
const position_1 = require("../../../common/core/position");
const languages = require("../../../common/languages");
const resolverService_1 = require("../../../common/services/resolverService");
const commands_1 = require("../../../../platform/commands/common/commands");
const contextkey_1 = require("../../../../platform/contextkey/common/contextkey");
const languageFeatures_1 = require("../../../common/services/languageFeatures");
exports.Context = {
    Visible: new contextkey_1.RawContextKey('parameterHintsVisible', false),
    MultipleSignatures: new contextkey_1.RawContextKey('parameterHintsMultipleSignatures', false),
};
function provideSignatureHelp(registry, model, position, context, token) {
    return __awaiter(this, void 0, void 0, function* () {
        const supports = registry.ordered(model);
        for (const support of supports) {
            try {
                const result = yield support.provideSignatureHelp(model, position, token, context);
                if (result) {
                    return result;
                }
            }
            catch (err) {
                (0, errors_1.onUnexpectedExternalError)(err);
            }
        }
        return undefined;
    });
}
exports.provideSignatureHelp = provideSignatureHelp;
commands_1.CommandsRegistry.registerCommand('_executeSignatureHelpProvider', (accessor, ...args) => __awaiter(void 0, void 0, void 0, function* () {
    const [uri, position, triggerCharacter] = args;
    (0, types_1.assertType)(uri_1.URI.isUri(uri));
    (0, types_1.assertType)(position_1.Position.isIPosition(position));
    (0, types_1.assertType)(typeof triggerCharacter === 'string' || !triggerCharacter);
    const languageFeaturesService = accessor.get(languageFeatures_1.ILanguageFeaturesService);
    const ref = yield accessor.get(resolverService_1.ITextModelService).createModelReference(uri);
    try {
        const result = yield provideSignatureHelp(languageFeaturesService.signatureHelpProvider, ref.object.textEditorModel, position_1.Position.lift(position), {
            triggerKind: languages.SignatureHelpTriggerKind.Invoke,
            isRetrigger: false,
            triggerCharacter,
        }, cancellation_1.CancellationToken.None);
        if (!result) {
            return undefined;
        }
        setTimeout(() => result.dispose(), 0);
        return result.value;
    }
    finally {
        ref.dispose();
    }
}));
//# sourceMappingURL=provideSignatureHelp.js.map