"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const cancellation_1 = require("../../../../base/common/cancellation");
const types_1 = require("../../../../base/common/types");
const uri_1 = require("../../../../base/common/uri");
const resolverService_1 = require("../../../common/services/resolverService");
const outlineModel_1 = require("./outlineModel");
const commands_1 = require("../../../../platform/commands/common/commands");
commands_1.CommandsRegistry.registerCommand('_executeDocumentSymbolProvider', function (accessor, ...args) {
    return __awaiter(this, void 0, void 0, function* () {
        const [resource] = args;
        (0, types_1.assertType)(uri_1.URI.isUri(resource));
        const outlineService = accessor.get(outlineModel_1.IOutlineModelService);
        const modelService = accessor.get(resolverService_1.ITextModelService);
        const reference = yield modelService.createModelReference(resource);
        try {
            return (yield outlineService.getOrCreate(reference.object.textEditorModel, cancellation_1.CancellationToken.None)).getTopLevelSymbols();
        }
        finally {
            reference.dispose();
        }
    });
});
//# sourceMappingURL=documentSymbols.js.map