"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.nullTokenizeEncoded = exports.nullTokenize = exports.NullState = void 0;
const languages_1 = require("../languages");
exports.NullState = new class {
    clone() {
        return this;
    }
    equals(other) {
        return (this === other);
    }
};
function nullTokenize(languageId, state) {
    return new languages_1.TokenizationResult([new languages_1.Token(0, '', languageId)], state);
}
exports.nullTokenize = nullTokenize;
function nullTokenizeEncoded(languageId, state) {
    const tokens = new Uint32Array(2);
    tokens[0] = 0;
    tokens[1] = ((languageId << 0 /* LANGUAGEID_OFFSET */)
        | (0 /* Other */ << 8 /* TOKEN_TYPE_OFFSET */)
        | (0 /* None */ << 10 /* FONT_STYLE_OFFSET */)
        | (1 /* DefaultForeground */ << 14 /* FOREGROUND_OFFSET */)
        | (2 /* DefaultBackground */ << 23 /* BACKGROUND_OFFSET */)) >>> 0;
    return new languages_1.EncodedTokenizationResult(tokens, state === null ? exports.NullState : state);
}
exports.nullTokenizeEncoded = nullTokenizeEncoded;
//# sourceMappingURL=nullTokenize.js.map