"use strict";
// *****************************************************************************
// Copyright (C) 2021 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
exports.StopReason = exports.APPLICATION_STATE_CHANGE_SIGNAL = exports.RELOAD_REQUESTED_SIGNAL = exports.CLOSE_REQUESTED_SIGNAL = exports.Restart = exports.TitleBarStyleAtStartup = exports.TitleBarStyleChanged = exports.RequestTitleBarStyle = void 0;
exports.RequestTitleBarStyle = 'requestTitleBarStyle';
exports.TitleBarStyleChanged = 'titleBarStyleChanged';
exports.TitleBarStyleAtStartup = 'titleBarStyleAtStartup';
exports.Restart = 'restart';
/**
 * Emitted by main when close requested.
 */
exports.CLOSE_REQUESTED_SIGNAL = 'close-requested';
/**
 * Emitted by window when a reload is requested.
 */
exports.RELOAD_REQUESTED_SIGNAL = 'reload-requested';
/**
 * Emitted by the window when the application changes state
 */
exports.APPLICATION_STATE_CHANGE_SIGNAL = 'application-state-changed';
var StopReason;
(function (StopReason) {
    /**
     * Closing the window with no prospect of restart.
     */
    StopReason[StopReason["Close"] = 0] = "Close";
    /**
     * Reload without closing the window.
     */
    StopReason[StopReason["Reload"] = 1] = "Reload";
    /**
     * Reload that includes closing the window.
     */
    StopReason[StopReason["Restart"] = 2] = "Restart";
})(StopReason = exports.StopReason || (exports.StopReason = {}));
//# sourceMappingURL=electron-messages.js.map