"use strict";
// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BuiltinThemeProvider = exports.ThemeService = exports.ThemeServiceSymbol = void 0;
const event_1 = require("../common/event");
const disposable_1 = require("../common/disposable");
const frontend_application_config_provider_1 = require("./frontend-application-config-provider");
const application_props_1 = require("@theia/application-package/lib/application-props");
/**
 * @deprecated since 1.20.0. Import from `@theia/core/lib/common/theme` instead.
 */
__exportStar(require("../common/theme"), exports);
exports.ThemeServiceSymbol = Symbol('ThemeService');
class ThemeService {
    constructor() {
        this.themes = {};
        this.themeChange = new event_1.Emitter();
        this.onDidColorThemeChange = this.themeChange.event;
    }
    static get() {
        const global = window; // eslint-disable-line @typescript-eslint/no-explicit-any
        if (!global[exports.ThemeServiceSymbol]) {
            const themeService = new ThemeService();
            themeService.register(...BuiltinThemeProvider.themes);
            themeService.startupTheme();
            global[exports.ThemeServiceSymbol] = themeService;
        }
        return global[exports.ThemeServiceSymbol];
    }
    register(...themes) {
        for (const theme of themes) {
            this.themes[theme.id] = theme;
        }
        this.validateActiveTheme();
        return disposable_1.Disposable.create(() => {
            for (const theme of themes) {
                delete this.themes[theme.id];
            }
            this.validateActiveTheme();
        });
    }
    validateActiveTheme() {
        if (!this.activeTheme) {
            return;
        }
        const theme = this.themes[this.activeTheme.id];
        if (!theme) {
            this.loadUserTheme();
        }
        else if (theme !== this.activeTheme) {
            this.activeTheme = undefined;
            this.setCurrentTheme(theme.id);
        }
    }
    getThemes() {
        const result = [];
        for (const o in this.themes) {
            if (this.themes.hasOwnProperty(o)) {
                result.push(this.themes[o]);
            }
        }
        return result;
    }
    getTheme(themeId) {
        return this.themes[themeId] || this.defaultTheme;
    }
    startupTheme() {
        const theme = this.getCurrentTheme();
        theme.activate();
    }
    loadUserTheme() {
        const theme = this.getCurrentTheme();
        this.setCurrentTheme(theme.id);
    }
    setCurrentTheme(themeId) {
        const newTheme = this.getTheme(themeId);
        const oldTheme = this.activeTheme;
        if (oldTheme) {
            if (oldTheme.id === newTheme.id) {
                return;
            }
            oldTheme.deactivate();
        }
        newTheme.activate();
        this.activeTheme = newTheme;
        window.localStorage.setItem('theme', themeId);
        this.themeChange.fire({
            newTheme, oldTheme
        });
    }
    getCurrentTheme() {
        const themeId = window.localStorage.getItem('theme') || this.defaultTheme.id;
        return this.getTheme(themeId);
    }
    /**
     * The default theme. If that is not applicable, returns with the fallback theme.
     */
    get defaultTheme() {
        return this.themes[frontend_application_config_provider_1.FrontendApplicationConfigProvider.get().defaultTheme] || this.themes[application_props_1.ApplicationProps.DEFAULT.frontend.config.defaultTheme];
    }
    /**
     * Resets the state to the user's default, or to the fallback theme. Also discards any persisted state in the local storage.
     */
    reset() {
        this.setCurrentTheme(this.defaultTheme.id);
    }
}
exports.ThemeService = ThemeService;
class BuiltinThemeProvider {
}
exports.BuiltinThemeProvider = BuiltinThemeProvider;
// Webpack converts these `require` in some Javascript object that wraps the `.css` files
BuiltinThemeProvider.darkCss = require('../../src/browser/style/variables-dark.useable.css');
BuiltinThemeProvider.lightCss = require('../../src/browser/style/variables-bright.useable.css');
BuiltinThemeProvider.darkTheme = {
    id: 'dark',
    type: 'dark',
    label: 'Dark (Theia)',
    editorTheme: 'dark-theia',
    activate() {
        BuiltinThemeProvider.darkCss.use();
    },
    deactivate() {
        BuiltinThemeProvider.darkCss.unuse();
    }
};
BuiltinThemeProvider.lightTheme = {
    id: 'light',
    type: 'light',
    label: 'Light (Theia)',
    editorTheme: 'light-theia',
    activate() {
        BuiltinThemeProvider.lightCss.use();
    },
    deactivate() {
        BuiltinThemeProvider.lightCss.unuse();
    }
};
BuiltinThemeProvider.hcTheme = {
    id: 'hc-theia',
    type: 'hc',
    label: 'High Contrast (Theia)',
    editorTheme: 'hc-theia',
    activate() {
        BuiltinThemeProvider.darkCss.use();
    },
    deactivate() {
        BuiltinThemeProvider.darkCss.unuse();
    }
};
BuiltinThemeProvider.themes = [
    BuiltinThemeProvider.darkTheme,
    BuiltinThemeProvider.lightTheme,
    BuiltinThemeProvider.hcTheme
];
//# sourceMappingURL=theming.js.map