"use strict";
// *****************************************************************************
// Copyright (C) 2021 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreferenceLanguageOverrideService = exports.getOverridePattern = exports.OVERRIDE_PROPERTY_PATTERN = exports.OverridePreferenceName = void 0;
const inversify_1 = require("inversify");
const common_1 = require("../../common");
const preference_schema_1 = require("../../common/preferences/preference-schema");
var OverridePreferenceName;
(function (OverridePreferenceName) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    function is(arg) {
        return !!arg && typeof arg === 'object' && 'preferenceName' in arg && 'overrideIdentifier' in arg;
    }
    OverridePreferenceName.is = is;
})(OverridePreferenceName = exports.OverridePreferenceName || (exports.OverridePreferenceName = {}));
const OVERRIDE_PROPERTY = '\\[(.*)\\]$';
exports.OVERRIDE_PROPERTY_PATTERN = new RegExp(OVERRIDE_PROPERTY);
const getOverridePattern = (identifier) => `\\[(${identifier})\\]$`;
exports.getOverridePattern = getOverridePattern;
let PreferenceLanguageOverrideService = class PreferenceLanguageOverrideService {
    constructor() {
        this.overrideIdentifiers = new Set();
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    testOverrideValue(name, value) {
        return preference_schema_1.PreferenceSchemaProperties.is(value) && exports.OVERRIDE_PROPERTY_PATTERN.test(name);
    }
    /**
     * @param overrideIdentifier the language id associated for a language override, e.g. `typescript`
     * @returns the form used to mark language overrides in preference files, e.g. `[typescript]`
     */
    markLanguageOverride(overrideIdentifier) {
        return `[${overrideIdentifier}]`;
    }
    /**
     * @returns the flat JSON path to an overridden preference, e.g. [typescript].editor.tabSize.
     */
    overridePreferenceName({ preferenceName, overrideIdentifier }) {
        return `${this.markLanguageOverride(overrideIdentifier)}.${preferenceName}`;
    }
    /**
     * @returns an OverridePreferenceName if the `name` contains a language override, e.g. [typescript].editor.tabSize.
     */
    overriddenPreferenceName(name) {
        const index = name.indexOf('.');
        if (index === -1) {
            return undefined;
        }
        const matches = name.substring(0, index).match(exports.OVERRIDE_PROPERTY_PATTERN);
        const overrideIdentifier = matches && matches[1];
        if (!overrideIdentifier || !this.overrideIdentifiers.has(overrideIdentifier)) {
            return undefined;
        }
        const preferenceName = name.substring(index + 1);
        return { preferenceName, overrideIdentifier };
    }
    computeOverridePatternPropertiesKey() {
        let param = '';
        for (const overrideIdentifier of this.overrideIdentifiers) {
            if (param.length) {
                param += '|';
            }
            param += new RegExp((0, common_1.escapeRegExpCharacters)(overrideIdentifier)).source;
        }
        return param.length ? (0, exports.getOverridePattern)(param) : undefined;
    }
    *getOverridePreferenceNames(preferenceName) {
        for (const overrideIdentifier of this.overrideIdentifiers) {
            yield this.overridePreferenceName({ preferenceName, overrideIdentifier });
        }
    }
    /**
     * @param overrideIdentifier
     * @returns true if the addition caused a change, i.e. if the identifier was not already present in the set of identifiers, false otherwise.
     */
    addOverrideIdentifier(overrideIdentifier) {
        const alreadyPresent = this.overrideIdentifiers.has(overrideIdentifier);
        if (!alreadyPresent) {
            this.overrideIdentifiers.add(overrideIdentifier);
        }
        return !alreadyPresent;
    }
    /**
     * @param overrideIdentifier
     * @returns true if the deletion caused a change, i.e. if the identifier was present in the set, false otherwise.
     */
    removeOverrideIdentifier(overrideIdentifier) {
        return this.overrideIdentifiers.delete(overrideIdentifier);
    }
};
PreferenceLanguageOverrideService = __decorate([
    (0, inversify_1.injectable)()
], PreferenceLanguageOverrideService);
exports.PreferenceLanguageOverrideService = PreferenceLanguageOverrideService;
//# sourceMappingURL=preference-language-override-service.js.map