/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.preferences;

import java.util.Objects;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.preferences.ProblemSeverity;

public class StandardPreferenceManager
extends PreferenceManager {
    private static final String M2E_APT_ID = "org.jboss.tools.maven.apt";
    private IMavenConfiguration mavenConfig;

    public StandardPreferenceManager() {
        StandardPreferenceManager.initializeMavenPreferences();
    }

    public static void initialize() {
        PreferenceManager.initialize();
        StandardPreferenceManager.initializeMavenPreferences();
    }

    public static void initializeMavenPreferences() {
        IEclipsePreferences m2eAptPrefs = DefaultScope.INSTANCE.getNode(M2E_APT_ID);
        if (m2eAptPrefs != null) {
            m2eAptPrefs.put("org.jboss.tools.maven.apt.mode", "jdt_apt");
        }
        IEclipsePreferences store = InstanceScope.INSTANCE.getNode("org.eclipse.m2e.core");
        store.put("eclipse.m2.problem.outofdateProjectConfig", ProblemSeverity.warning.toString());
    }

    @Override
    public void update(Preferences preferences) {
        String oldMavenGlobalSettings;
        String newMavenGlobalSettings;
        super.update(preferences);
        String newMavenSettings = preferences.getMavenUserSettings();
        String oldMavenSettings = this.getMavenConfiguration().getUserSettingsFile();
        if (!Objects.equals(newMavenSettings, oldMavenSettings)) {
            try {
                this.getMavenConfiguration().setUserSettingsFile(newMavenSettings);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("failed to set Maven settings", e);
                preferences.setMavenUserSettings(oldMavenSettings);
            }
        }
        if (!Objects.equals(newMavenGlobalSettings = preferences.getMavenGlobalSettings(), oldMavenGlobalSettings = this.getMavenConfiguration().getGlobalSettingsFile())) {
            try {
                this.getMavenConfiguration().setGlobalSettingsFile(newMavenGlobalSettings);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("failed to set Maven global settings", e);
                preferences.setMavenUserSettings(oldMavenSettings);
            }
        }
        this.updateParallelBuild(preferences.getMaxConcurrentBuilds());
    }

    private void updateParallelBuild(int maxConcurrentBuilds) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        if (description.getMaxConcurrentBuilds() == maxConcurrentBuilds) {
            return;
        }
        description.setMaxConcurrentBuilds(maxConcurrentBuilds);
        try {
            workspace.setDescription(description);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problems setting maxConcurrentBuilds from workspace.", e);
        }
        String stringValue = maxConcurrentBuilds != 1 ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("org.eclipse.m2e.core");
        pref.put("builderUsesNullSchedulingRule", stringValue);
        pref = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.core");
    }

    public IMavenConfiguration getMavenConfiguration() {
        if (this.mavenConfig == null) {
            this.mavenConfig = MavenPlugin.getMavenConfiguration();
        }
        return this.mavenConfig;
    }

    public void setMavenConfiguration(IMavenConfiguration mavenConfig) {
        this.mavenConfig = mavenConfig;
    }
}

