/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.AbstractPlainDatagramSocketImpl;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

class DualStackPlainDatagramSocketImpl
extends AbstractPlainDatagramSocketImpl {
    static JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    private final boolean exclusiveBind;
    private boolean reuseAddressEmulated;
    private boolean isReuseAddress;

    DualStackPlainDatagramSocketImpl(boolean bl) {
        this.exclusiveBind = bl;
    }

    @Override
    protected void datagramSocketCreate() throws SocketException {
        if (this.fd == null) {
            throw new SocketException("Socket closed");
        }
        int n = DualStackPlainDatagramSocketImpl.socketCreate(false);
        fdAccess.set(this.fd, n);
    }

    @Override
    protected synchronized void bind0(int n, InetAddress inetAddress) throws SocketException {
        int n2 = this.checkAndReturnNativeFD();
        if (inetAddress == null) {
            throw new NullPointerException("argument address");
        }
        DualStackPlainDatagramSocketImpl.socketBind(n2, inetAddress, n, this.exclusiveBind);
        this.localPort = n == 0 ? DualStackPlainDatagramSocketImpl.socketLocalPort(n2) : n;
    }

    @Override
    protected synchronized int peek(InetAddress inetAddress) throws IOException {
        int n = this.checkAndReturnNativeFD();
        if (inetAddress == null) {
            throw new NullPointerException("Null address in peek()");
        }
        DatagramPacket datagramPacket = new DatagramPacket(new byte[1], 1);
        int n2 = this.peekData(datagramPacket);
        inetAddress = datagramPacket.getAddress();
        return n2;
    }

    @Override
    protected synchronized int peekData(DatagramPacket datagramPacket) throws IOException {
        int n = this.checkAndReturnNativeFD();
        if (datagramPacket == null) {
            throw new NullPointerException("packet");
        }
        if (datagramPacket.getData() == null) {
            throw new NullPointerException("packet buffer");
        }
        return DualStackPlainDatagramSocketImpl.socketReceiveOrPeekData(n, datagramPacket, this.timeout, this.connected, true);
    }

    @Override
    protected synchronized void receive0(DatagramPacket datagramPacket) throws IOException {
        int n = this.checkAndReturnNativeFD();
        if (datagramPacket == null) {
            throw new NullPointerException("packet");
        }
        if (datagramPacket.getData() == null) {
            throw new NullPointerException("packet buffer");
        }
        DualStackPlainDatagramSocketImpl.socketReceiveOrPeekData(n, datagramPacket, this.timeout, this.connected, false);
    }

    @Override
    protected void send(DatagramPacket datagramPacket) throws IOException {
        int n = this.checkAndReturnNativeFD();
        if (datagramPacket == null) {
            throw new NullPointerException("null packet");
        }
        if (datagramPacket.getAddress() == null || datagramPacket.getData() == null) {
            throw new NullPointerException("null address || null buffer");
        }
        DualStackPlainDatagramSocketImpl.socketSend(n, datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength(), datagramPacket.getAddress(), datagramPacket.getPort(), this.connected);
    }

    @Override
    protected void connect0(InetAddress inetAddress, int n) throws SocketException {
        int n2 = this.checkAndReturnNativeFD();
        if (inetAddress == null) {
            throw new NullPointerException("address");
        }
        DualStackPlainDatagramSocketImpl.socketConnect(n2, inetAddress, n);
    }

    @Override
    protected void disconnect0(int n) {
        if (this.fd == null || !this.fd.valid()) {
            return;
        }
        DualStackPlainDatagramSocketImpl.socketDisconnect(fdAccess.get(this.fd));
    }

    @Override
    protected void datagramSocketClose() {
        if (this.fd == null || !this.fd.valid()) {
            return;
        }
        DualStackPlainDatagramSocketImpl.socketClose(fdAccess.get(this.fd));
        fdAccess.set(this.fd, -1);
    }

    @Override
    protected void socketSetOption(int n, Object object) throws SocketException {
        int n2 = this.checkAndReturnNativeFD();
        int n3 = 0;
        switch (n) {
            case 3: 
            case 4097: 
            case 4098: {
                n3 = (Integer)object;
                break;
            }
            case 4: {
                if (this.exclusiveBind && this.localPort != 0) {
                    this.reuseAddressEmulated = true;
                    this.isReuseAddress = (Boolean)object;
                    return;
                }
            }
            case 32: {
                n3 = (Boolean)object != false ? 1 : 0;
                break;
            }
            default: {
                throw new SocketException("Option not supported");
            }
        }
        DualStackPlainDatagramSocketImpl.socketSetIntOption(n2, n, n3);
    }

    @Override
    protected Object socketGetOption(int n) throws SocketException {
        int n2 = this.checkAndReturnNativeFD();
        if (n == 15) {
            return DualStackPlainDatagramSocketImpl.socketLocalAddress(n2);
        }
        if (n == 4 && this.reuseAddressEmulated) {
            return this.isReuseAddress;
        }
        int n3 = DualStackPlainDatagramSocketImpl.socketGetIntOption(n2, n);
        Comparable<Boolean> comparable = null;
        switch (n) {
            case 4: 
            case 32: {
                comparable = n3 == 0 ? Boolean.FALSE : Boolean.TRUE;
                break;
            }
            case 3: 
            case 4097: 
            case 4098: {
                comparable = new Integer(n3);
                break;
            }
            default: {
                throw new SocketException("Option not supported");
            }
        }
        return comparable;
    }

    @Override
    protected void join(InetAddress inetAddress, NetworkInterface networkInterface) throws IOException {
        throw new IOException("Method not implemented!");
    }

    @Override
    protected void leave(InetAddress inetAddress, NetworkInterface networkInterface) throws IOException {
        throw new IOException("Method not implemented!");
    }

    @Override
    protected void setTimeToLive(int n) throws IOException {
        throw new IOException("Method not implemented!");
    }

    @Override
    protected int getTimeToLive() throws IOException {
        throw new IOException("Method not implemented!");
    }

    @Override
    @Deprecated
    protected void setTTL(byte by) throws IOException {
        throw new IOException("Method not implemented!");
    }

    @Override
    @Deprecated
    protected byte getTTL() throws IOException {
        throw new IOException("Method not implemented!");
    }

    private int checkAndReturnNativeFD() throws SocketException {
        if (this.fd == null || !this.fd.valid()) {
            throw new SocketException("Socket closed");
        }
        return fdAccess.get(this.fd);
    }

    private static native void initIDs();

    private static native int socketCreate(boolean var0);

    private static native void socketBind(int var0, InetAddress var1, int var2, boolean var3) throws SocketException;

    private static native void socketConnect(int var0, InetAddress var1, int var2) throws SocketException;

    private static native void socketDisconnect(int var0);

    private static native void socketClose(int var0);

    private static native int socketLocalPort(int var0) throws SocketException;

    private static native Object socketLocalAddress(int var0) throws SocketException;

    private static native int socketReceiveOrPeekData(int var0, DatagramPacket var1, int var2, boolean var3, boolean var4) throws IOException;

    private static native void socketSend(int var0, byte[] var1, int var2, int var3, InetAddress var4, int var5, boolean var6) throws IOException;

    private static native void socketSetIntOption(int var0, int var1, int var2) throws SocketException;

    private static native int socketGetIntOption(int var0, int var1) throws SocketException;

    @Override
    native int dataAvailable();

    static {
        DualStackPlainDatagramSocketImpl.initIDs();
    }
}

