/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import sun.jvm.hotspot.oops.HeapVisitor;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.ObjectHistogramElement;
import sun.jvm.hotspot.oops.Oop;

public class ObjectHistogram
implements HeapVisitor {
    private HashMap map = new HashMap();

    @Override
    public void prologue(long size) {
    }

    @Override
    public boolean doObj(Oop obj) {
        Klass klass = obj.getKlass();
        if (!this.map.containsKey(klass)) {
            this.map.put(klass, new ObjectHistogramElement(klass));
        }
        ((ObjectHistogramElement)this.map.get(klass)).updateWith(obj);
        return false;
    }

    @Override
    public void epilogue() {
    }

    public List getElements() {
        ArrayList list = new ArrayList();
        list.addAll(this.map.values());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ObjectHistogramElement)o1).compare((ObjectHistogramElement)o2);
            }
        });
        return list;
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printOn(PrintStream tty) {
        List list = this.getElements();
        ObjectHistogramElement.titleOn(tty);
        ListIterator iterator = list.listIterator();
        int num = 0;
        int totalCount = 0;
        int totalSize = 0;
        while (iterator.hasNext()) {
            ObjectHistogramElement el = (ObjectHistogramElement)iterator.next();
            totalCount = (int)((long)totalCount + el.getCount());
            totalSize = (int)((long)totalSize + el.getSize());
            tty.print(++num + ":" + "\t\t");
            el.printOn(tty);
        }
        tty.println("Total : \t" + totalCount + "\t" + totalSize);
    }
}

