/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security;

import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.KeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.interfaces.EdECPrivateKey;
import java.security.interfaces.RSAKey;
import java.security.spec.NamedParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.RSAPSSParameterSpec;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.crypto.dsig.spec.XPathType;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLUtils {
    private static final XMLSignatureFactory FAC = XMLSignatureFactory.getInstance("DOM");
    public static final XPath XPATH = XPathFactory.newInstance().newXPath();

    public static String doc2string(Document doc) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        return writer.getBuffer().toString();
    }

    public static Document string2doc(String input) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder().parse(new InputSource(new StringReader(input)));
    }

    public static Document clone(Document d) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document copiedDocument = db.newDocument();
        Node copiedRoot = copiedDocument.importNode(d.getDocumentElement(), true);
        copiedDocument.appendChild(copiedRoot);
        return copiedDocument;
    }

    public static Element sub(Document d, String path) throws Exception {
        return (Element)XPATH.evaluate(path, d, XPathConstants.NODE);
    }

    public static Document withAttribute(Document d, String path, String attr, String value) throws Exception {
        d = XMLUtils.clone(d);
        XMLUtils.sub(d, path).setAttribute(attr, value);
        return d;
    }

    public static Document withText(Document d, String path, String value) throws Exception {
        d = XMLUtils.clone(d);
        XMLUtils.sub(d, path).setTextContent(value);
        return d;
    }

    public static Document withoutNode(Document d, String ... paths) throws Exception {
        d = XMLUtils.clone(d);
        for (String path : paths) {
            Element e = XMLUtils.sub(d, path);
            e.getParentNode().removeChild(e);
        }
        return d;
    }

    public static Signer signer(PrivateKey privateKey, X509Certificate cert) throws Exception {
        return XMLUtils.signer(privateKey).cert(cert);
    }

    public static Signer signer(PrivateKey privateKey, PublicKey publicKey) throws Exception {
        return XMLUtils.signer(privateKey).publicKey(publicKey);
    }

    public static Signer signer(KeyStore ks, String alias, char[] password) throws Exception {
        return XMLUtils.signer((PrivateKey)ks.getKey(alias, password)).keyName(alias);
    }

    public static Signer signer(PrivateKey privateKey) throws Exception {
        return new Signer(privateKey);
    }

    public static Validator validator(KeyStore ks) throws Exception {
        return new Validator(ks);
    }

    public static Validator validator() throws Exception {
        return new Validator(null);
    }

    public static void addPolicy(String rule) {
        Object value = Security.getProperty("jdk.xml.dsig.secureValidationPolicy");
        value = rule + "," + (String)value;
        Security.setProperty("jdk.xml.dsig.secureValidationPolicy", (String)value);
    }

    private XMLUtils() {
        assert (false) : "No one instantiates me";
    }

    static {
        XPATH.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return switch (prefix) {
                    case "ds" -> "http://www.w3.org/2000/09/xmldsig#";
                    case "pss" -> "http://www.w3.org/2007/05/xmldsig-more#";
                    default -> throw new IllegalArgumentException();
                };
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return null;
            }

            @Override
            public Iterator<String> getPrefixes(String namespaceURI) {
                return null;
            }
        });
    }

    public static class Signer {
        final PrivateKey privateKey;
        X509Certificate cert;
        PublicKey publicKey;
        String keyName;
        String sm = null;
        SignatureMethodParameterSpec smSpec = null;
        String dm = "http://www.w3.org/2001/04/xmlenc#sha256";
        String cm = "http://www.w3.org/2001/10/xml-exc-c14n#";
        String tr = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
        Map<String, Object> props = new HashMap<String, Object>();

        public Signer(PrivateKey privateKey) {
            this.privateKey = Objects.requireNonNull(privateKey);
        }

        public Signer cert(X509Certificate cert) {
            this.cert = cert;
            return this;
        }

        public Signer publicKey(PublicKey key) {
            this.publicKey = key;
            return this;
        }

        public Signer keyName(String n) {
            this.keyName = n;
            return this;
        }

        public Signer tr(String transform) {
            this.tr = Objects.requireNonNull(transform);
            return this;
        }

        public Signer dm(String method) {
            this.dm = Objects.requireNonNull(method);
            return this;
        }

        public Signer cm(String method) {
            this.cm = Objects.requireNonNull(method);
            return this;
        }

        public Signer sm(String method, SignatureMethodParameterSpec spec) {
            this.sm = method;
            this.smSpec = spec;
            return this;
        }

        public Signer sm(String method) throws Exception {
            return this.sm(method, null);
        }

        public Signer prop(String name, Object o) {
            this.props.put(name, o);
            return this;
        }

        public Document sign(URI uri) throws Exception {
            Document newDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            FAC.newXMLSignature(this.buildSignedInfo(uri.toString()), this.buildKeyInfo()).sign(this.withProps(new DOMSignContext(this.privateKey, (Node)newDocument)));
            return newDocument;
        }

        public Document sign(URI base, URI ref) throws Exception {
            Document newDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            DOMSignContext ctxt = new DOMSignContext(this.privateKey, (Node)newDocument);
            ctxt.setBaseURI(base.toString());
            FAC.newXMLSignature(this.buildSignedInfo(ref.toString()), this.buildKeyInfo()).sign(this.withProps(ctxt));
            return newDocument;
        }

        public Document sign(Document document) throws Exception {
            DOMResult result = new DOMResult();
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(document), result);
            Document newDocument = (Document)result.getNode();
            FAC.newXMLSignature(this.buildSignedInfo(""), this.buildKeyInfo()).sign(this.withProps(new DOMSignContext(this.privateKey, (Node)newDocument.getDocumentElement())));
            return newDocument;
        }

        public Document signEnveloping(Document document, String id, String ref) throws Exception {
            Document newDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            FAC.newXMLSignature(this.buildSignedInfo(FAC.newReference(ref, FAC.newDigestMethod(this.dm, null))), this.buildKeyInfo(), List.of(FAC.newXMLObject(List.of(new DOMStructure(document.getDocumentElement())), id, null, null)), null, null).sign(this.withProps(new DOMSignContext(this.privateKey, (Node)newDocument)));
            return newDocument;
        }

        public Document sign(byte[] data) throws Exception {
            Document newDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            FAC.newXMLSignature(this.buildSignedInfo(FAC.newReference("#object", FAC.newDigestMethod(this.dm, null), List.of(FAC.newTransform("http://www.w3.org/2000/09/xmldsig#base64", (TransformParameterSpec)null)), null, null)), this.buildKeyInfo(), List.of(FAC.newXMLObject(List.of(new DOMStructure(newDocument.createTextNode(Base64.getEncoder().encodeToString(data)))), "object", null, null)), null, null).sign(this.withProps(new DOMSignContext(this.privateKey, (Node)newDocument)));
            return newDocument;
        }

        public Document sign(String str) throws Exception {
            Document newDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            FAC.newXMLSignature(this.buildSignedInfo(FAC.newReference("#object", FAC.newDigestMethod(this.dm, null))), this.buildKeyInfo(), List.of(FAC.newXMLObject(List.of(new DOMStructure(newDocument.createTextNode(str))), "object", null, null)), null, null).sign(this.withProps(new DOMSignContext(this.privateKey, (Node)newDocument)));
            return newDocument;
        }

        private DOMSignContext withProps(DOMSignContext ctxt) {
            for (Map.Entry<String, Object> e : this.props.entrySet()) {
                ctxt.setProperty(e.getKey(), e.getValue());
            }
            return ctxt;
        }

        private SignedInfo buildSignedInfo(String ref) throws Exception {
            DigestMethod digestMethod = FAC.newDigestMethod(this.dm, null);
            return this.buildSignedInfo(FAC.newReference(ref, digestMethod, List.of(FAC.newTransform(this.tr, switch (this.tr) {
                case "http://www.w3.org/TR/1999/REC-xpath-19991116" -> new XPathFilterParameterSpec("//.");
                case "http://www.w3.org/2002/06/xmldsig-filter2" -> new XPathFilter2ParameterSpec(Collections.singletonList(new XPathType("//.", XPathType.Filter.INTERSECT)));
                default -> null;
            })), null, null));
        }

        private SignedInfo buildSignedInfo(Reference ref) throws Exception {
            SignatureMethod signatureMethod;
            if (this.sm == null) {
                String alg = this.privateKey.getAlgorithm().toUpperCase(Locale.ROOT);
                if (alg.equals("RSASSA-PSS")) {
                    PSSParameterSpec pspec = (PSSParameterSpec)((RSAKey)((Object)this.privateKey)).getParams();
                    signatureMethod = pspec != null ? FAC.newSignatureMethod("http://www.w3.org/2007/05/xmldsig-more#rsa-pss", new RSAPSSParameterSpec(pspec)) : FAC.newSignatureMethod("http://www.w3.org/2007/05/xmldsig-more#rsa-pss", null);
                } else {
                    signatureMethod = FAC.newSignatureMethod(switch (alg) {
                        case "RSA" -> "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
                        case "DSA" -> "http://www.w3.org/2009/xmldsig11#dsa-sha256";
                        case "EC" -> "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";
                        case "ED25519" -> "http://www.w3.org/2021/04/xmldsig-more#eddsa-ed25519";
                        case "ED448" -> "http://www.w3.org/2021/04/xmldsig-more#eddsa-ed448";
                        case "EDDSA" -> {
                            PrivateKey var7_7 = this.privateKey;
                            if (var7_7 instanceof EdECPrivateKey) {
                                EdECPrivateKey edsk = (EdECPrivateKey)var7_7;
                                if (edsk.getParams().getName().equals(NamedParameterSpec.ED25519.getName())) {
                                    yield "http://www.w3.org/2021/04/xmldsig-more#eddsa-ed25519";
                                }
                                yield "http://www.w3.org/2021/04/xmldsig-more#eddsa-ed448";
                            }
                            throw new InvalidKeyException();
                        }
                        default -> throw new InvalidKeyException();
                    }, null);
                }
            } else {
                signatureMethod = FAC.newSignatureMethod(this.sm, this.smSpec);
            }
            return FAC.newSignedInfo(FAC.newCanonicalizationMethod(this.cm, (C14NMethodParameterSpec)null), signatureMethod, List.of(ref));
        }

        private KeyInfo buildKeyInfo() throws Exception {
            KeyInfoFactory keyInfoFactory = FAC.getKeyInfoFactory();
            if (this.cert != null) {
                return keyInfoFactory.newKeyInfo(List.of(keyInfoFactory.newX509Data(List.of(this.cert))));
            }
            if (this.publicKey != null) {
                return keyInfoFactory.newKeyInfo(List.of(keyInfoFactory.newKeyValue(this.publicKey)));
            }
            if (this.keyName != null) {
                return keyInfoFactory.newKeyInfo(List.of(keyInfoFactory.newKeyName(this.keyName)));
            }
            return null;
        }
    }

    public static class Validator {
        private Boolean secureValidation = null;
        private String baseURI = null;
        private final KeyStore ks;
        Map<String, Object> props = new HashMap<String, Object>();

        public Validator(KeyStore ks) {
            this.ks = ks;
        }

        public Validator secureValidation(boolean v) {
            this.secureValidation = v;
            return this;
        }

        public Validator baseURI(String base) {
            this.baseURI = base;
            return this;
        }

        public Validator prop(String name, Object o) {
            this.props.put(name, o);
            return this;
        }

        public boolean validate(Document document) throws Exception {
            return this.validate(document, null);
        }

        public boolean validate(Document document, final PublicKey key) throws Exception {
            Node signatureNode;
            NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nodeList.getLength() == 1 && (signatureNode = nodeList.item(0)) != null) {
                KeySelector ks = key == null ? new MyKeySelector(this.ks) : new KeySelector(this){
                    {
                        Objects.requireNonNull(this$0);
                    }

                    @Override
                    public KeySelectorResult select(KeyInfo ki, KeySelector.Purpose p, AlgorithmMethod m, XMLCryptoContext c) {
                        return () -> key;
                    }
                };
                DOMValidateContext valContext = new DOMValidateContext(ks, signatureNode);
                if (this.baseURI != null) {
                    valContext.setBaseURI(this.baseURI);
                }
                if (this.secureValidation != null) {
                    valContext.setProperty("org.jcp.xml.dsig.secureValidation", this.secureValidation);
                    valContext.setProperty("org.apache.jcp.xml.dsig.secureValidation", this.secureValidation);
                }
                return XMLSignatureFactory.getInstance("DOM").unmarshalXMLSignature(valContext).validate(this.withProps(valContext));
            }
            return false;
        }

        private DOMValidateContext withProps(DOMValidateContext ctxt) {
            for (Map.Entry<String, Object> e : this.props.entrySet()) {
                ctxt.setProperty(e.getKey(), e.getValue());
            }
            return ctxt;
        }

        private static class MyKeySelector
        extends KeySelector {
            private final KeyStore ks;

            public MyKeySelector(KeyStore ks) {
                this.ks = ks;
            }

            @Override
            public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
                if (keyInfo == null) {
                    throw new IllegalArgumentException("Null KeyInfo object!");
                }
                for (XMLStructure xmlStructure : keyInfo.getContent()) {
                    PublicKey pk;
                    if (xmlStructure instanceof KeyValue) {
                        PublicKey pk2;
                        KeyValue kv = (KeyValue)xmlStructure;
                        try {
                            pk2 = kv.getPublicKey();
                        }
                        catch (KeyException ke) {
                            throw new KeySelectorException(ke);
                        }
                        return () -> pk2;
                    }
                    if (xmlStructure instanceof X509Data) {
                        X509Data x509 = (X509Data)xmlStructure;
                        for (Object data : x509.getContent()) {
                            if (!(data instanceof X509Certificate)) continue;
                            PublicKey pk3 = ((X509Certificate)data).getPublicKey();
                            return () -> pk3;
                        }
                        continue;
                    }
                    if (!(xmlStructure instanceof KeyName)) continue;
                    KeyName kn = (KeyName)xmlStructure;
                    try {
                        pk = this.ks.getCertificate(kn.getName()).getPublicKey();
                    }
                    catch (KeyStoreException e) {
                        throw new KeySelectorException(e);
                    }
                    return () -> pk;
                }
                throw new KeySelectorException("No KeyValue element found!");
            }
        }
    }
}

