/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ast extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Hora media de Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "hora est\u00e1ndar d\u2019Acre",
               "",
               "hora braniega d\u2019Acre",
               "",
               "hora d\u2019Acre",
               "",
            };
        final String[] Apia = new String[] {
               "Hora est\u00e1ndar d\u2019Apia",
               "",
               "Hora braniega d\u2019Apia",
               "",
               "Hora d\u2019Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Hora est\u00e1ndar de les Islles Cook",
               "",
               "Hora media braniega de les Islles Cook",
               "",
               "Hora de les Islles Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Hora est\u00e1ndar de Cuba",
               "CST",
               "Hora braniega de Cuba",
               "CDT",
               "Hora de Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Hora est\u00e1ndar de Fixi",
               "",
               "Hora braniega de Fixi",
               "",
               "Hora de Fixi",
               "",
            };
        final String[] Gulf = new String[] {
               "Hora est\u00e1ndar del Golfu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hora est\u00e1ndar de Hovd",
               "",
               "Hora braniega de Hovd",
               "",
               "Hora de Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Hora est\u00e1ndar d\u2019Ir\u00e1n",
               "",
               "Hora braniega d\u2019Ir\u00e1n",
               "",
               "Hora d\u2019Ir\u00e1n",
               "",
            };
        final String[] Niue = new String[] {
               "Hora de Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Hora est\u00e1ndar d\u2019Omsk",
               "",
               "Hora braniega d\u2019Omsk",
               "",
               "Hora d\u2019Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Hora est\u00e1ndar del Per\u00fa",
               "",
               "Hora braniega del Per\u00fa",
               "",
               "Hora del Per\u00fa",
               "",
            };
        final String[] Truk = new String[] {
               "Hora de Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Hora de la Islla Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Casey = new String[] {
               "Hora de Casey",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Hora est\u00e1ndar de Chile",
               "",
               "Hora braniega de Chile",
               "",
               "Hora de Chile",
               "",
            };
        final String[] China = new String[] {
               "Hora est\u00e1ndar de China",
               "CST",
               "Hora braniega de China",
               "CDT",
               "Hora de China",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Hora de les Islles Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Hora de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Hora est\u00e1ndar de la India",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Hora est\u00e1ndar de Xap\u00f3n",
               "JST",
               "Hora braniega de Xap\u00f3n",
               "JDT",
               "Hora de Xap\u00f3n",
               "JT",
            };
        final String[] Korea = new String[] {
               "Hora est\u00e1ndar de Corea",
               "KST",
               "Hora braniega de Corea",
               "KST",
               "Hora de Corea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Hora de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Hora del Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Hora de Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Hora est\u00e1ndar de Samoa",
               "SST",
               "Hora braniega de Samoa",
               "SST",
               "Hora de Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Hora de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Hora est\u00e1ndar de Tonga",
               "",
               "Hora braniega de Tonga",
               "",
               "Hora de Tonga",
               "",
            };
        final String[] Alaska = new String[] {
               "Hora est\u00e1ndar d\u2019Alaska",
               "AKST",
               "Hora braniega d\u2019Alaska",
               "AKDT",
               "Hora d\u2019Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Hora est\u00e1ndar del Amazonas",
               "",
               "Hora braniega del Amazonas",
               "",
               "Hora del Amazonas",
               "",
            };
        final String[] Anadyr = new String[] {
               "hora est\u00e1ndar d\u2019Anadyr",
               "",
               "hora braniega d\u2019Anadyr",
               "",
               "hora d\u2019Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Hora est\u00e1ndar de les Azores",
               "",
               "Hora braniega de Les Azores",
               "",
               "Hora de les Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Hora de But\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Hora de Brun\u00e9i Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Hora est\u00e1ndar de la Islla de Pascua",
               "",
               "Hora braniega de la Islla de Pascua",
               "",
               "Hora de la Islla de Pascua",
               "",
            };
        final String[] Guyana = new String[] {
               "Hora de La Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Hora est\u00e1ndar d\u2019Israel",
               "IST",
               "Hora braniega d\u2019Israel",
               "IDT",
               "Hora d\u2019Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Hora de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Hora de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Hora est\u00e1ndar de Mosc\u00fa",
               "MSK",
               "Hora braniega de Mosc\u00fa",
               "MSK",
               "Hora de Mosc\u00fa",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Hora de Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Hora est\u00e1ndar de Samara",
               "",
               "Hora braniega de Samara",
               "",
               "Hora de Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Hora de Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Hora est\u00e1ndar de Taip\u00e9i",
               "CST",
               "Hora braniega de Taip\u00e9i",
               "CDT",
               "Hora de Taip\u00e9i",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Hora de Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Hora de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Hora de Wallis y Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Hora est\u00e1ndar d\u2019Arabia",
               "",
               "Hora braniega d\u2019Arabia",
               "",
               "Hora d\u2019Arabia",
               "",
            };
        final String[] Armenia = new String[] {
               "Hora est\u00e1ndar d\u2019Armenia",
               "",
               "Hora braniega d\u2019Armenia",
               "",
               "Hora d\u2019Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Hora de Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Hora est\u00e1ndar de Chatham",
               "",
               "Hora braniega de Chatham",
               "",
               "Hora de Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Hora coordinada universal",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Hora d\u2019Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Hora de Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Hora est\u00e1ndar de Xeorxa",
               "",
               "Hora braniega de Xeorxa",
               "",
               "Hora de Xeorxa",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Hora est\u00e1ndar d\u2019Irkutsk",
               "",
               "Hora braniega d\u2019Irkutsk",
               "",
               "Hora d\u2019Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Hora est\u00e1ndar de Magad\u00e1n",
               "",
               "Hora braniega de Magad\u00e1n",
               "",
               "Hora de Magad\u00e1n",
               "",
            };
        final String[] Myanmar = new String[] {
               "Hora de Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Hora est\u00e1ndar de la Islla Norfolk",
               "",
               "Hora braniega de la Islla Norfolk",
               "",
               "Hora de la Islla Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Hora est\u00e1ndar de Fernando de Noronha",
               "",
               "Hora braniega de Fernando de Noronha",
               "",
               "Hora de Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Hora de Reuni\u00f3n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Hora de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Hora de les Islles Salom\u00f3n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Hora de Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Hora est\u00e1ndar del Urugu\u00e1i",
               "",
               "Hora braniega del Urugu\u00e1i",
               "",
               "Hora del Urugu\u00e1i",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Hora est\u00e1ndar de Vanuatu",
               "",
               "Hora braniega de Vanuatu",
               "",
               "Hora de Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Hora est\u00e1ndar de Yakutsk",
               "",
               "Hora braniega de Yakutsk",
               "",
               "Hora de Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Hora est\u00e1ndar del Atl\u00e1nticu",
               "AST",
               "Hora braniega del Atl\u00e1nticu",
               "ADT",
               "Hora del Atl\u00e1nticu",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Hora est\u00e1ndar de Brasilia",
               "",
               "Hora braniega de Brasilia",
               "",
               "Hora de Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Hora est\u00e1ndar de Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Hora est\u00e1ndar de Colombia",
               "",
               "Hora braniega de Colombia",
               "",
               "Hora de Colombia",
               "",
            };
        final String[] Falkland = new String[] {
               "Hora est\u00e1ndar de les Islles Falkland",
               "",
               "Hora braniega de les Islles Falkland",
               "",
               "Hora de les Islles Falkland",
               "",
            };
        final String[] Malaysia = new String[] {
               "Hora de Malasia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Hora de Les Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Hora est\u00e1ndar d\u2019Ul\u00e1n B\u00e1tor",
               "",
               "Hora braniega d\u2019Ul\u00e1n B\u00e1tor",
               "",
               "Hora d\u2019Ul\u00e1n B\u00e1tor",
               "",
            };
        final String[] Pakistan = new String[] {
               "Hora est\u00e1ndar del Paquist\u00e1n",
               "PKT",
               "Hora braniega del Paquist\u00e1n",
               "PKST",
               "Hora del Paquist\u00e1n",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Hora est\u00e1ndar del Paragu\u00e1i",
               "",
               "Hora braniega del Paragu\u00e1i",
               "",
               "Hora del Paragu\u00e1i",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Hora de Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Hora est\u00e1ndar de Saxal\u00edn",
               "",
               "Hora braniega de Saxal\u00edn",
               "",
               "Hora de Saxal\u00edn",
               "",
            };
        final String[] Suriname = new String[] {
               "Hora del Surinam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Hora est\u00e1ndar d\u2019Arxentina",
               "",
               "Hora braniega d\u2019Arxentina",
               "",
               "Hora d\u2019Arxentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Hora est\u00e1ndar de la Islla Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Hora de Gal\u00e1pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hora est\u00e1ndar de \u1e24ong Kong",
               "HKT",
               "Hora braniega de \u1e24ong Kong",
               "HKST",
               "Hora de \u1e24ong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Hora d\u2019Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "hora estandar de Petropavlovsk-Kamchatski",
               "",
               "hora braniega de Petropavlovsk-Kamchatski",
               "",
               "hora de Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Hora del Kirguist\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Hora est\u00e1ndar de Lord Howe",
               "",
               "Hora braniega de Lord Howe",
               "",
               "Hora de Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Hora de les Marqueses",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Hora est\u00e1ndar de Mauriciu",
               "",
               "Hora braniega de Mauriciu",
               "",
               "Hora de Mauriciu",
               "",
            };
        final String[] Singapore = new String[] {
               "Hora est\u00e1ndar de Singapur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Hora de Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Hora est\u00e1ndar de Volgogr\u00e1u",
               "MSK",
               "Hora braniega de Volgogr\u00e1u",
               "MSK",
               "Hora de Volgogr\u00e1u",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Hora est\u00e1ndar d\u2019Azerbaix\u00e1n",
               "",
               "Hora braniega d\u2019Azerbaix\u00e1n",
               "",
               "Hora d\u2019Azerbaix\u00e1n",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Hora est\u00e1ndar de Bangladex",
               "",
               "Hora braniega de Bangladex",
               "",
               "Hora de Bangladex",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Hora est\u00e1ndar de Cabu Verde",
               "",
               "Hora braniega de Cabu Verde",
               "",
               "Hora de Cabu Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Hora de Timor Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Hora de Les Seixeles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Hora del Taxiquist\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Hora est\u00e1ndar del Uzbequist\u00e1n",
               "",
               "Hora braniega del Uzbequist\u00e1n",
               "",
               "Hora del Uzbequist\u00e1n",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Hora d\u2019Afganist\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Hora est\u00e1ndar de Krasnoyarsk",
               "",
               "Hora braniega de Krasnoyarsk",
               "",
               "Hora de Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Hora est\u00e1ndar de Nueva Zelanda",
               "NZST",
               "Hora braniega de Nueva Zelanda",
               "NZDT",
               "Hora de Nueva Zelanda",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Hora est\u00e1ndar de Novosibirsk",
               "",
               "Hora braniega de Novosibirsk",
               "",
               "Hora de Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Hora est\u00e1ndar de Filipines",
               "PST",
               "Hora de branu de Filipines",
               "PDT",
               "Hora de Filipines",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Hora est\u00e1ndar de Vladivostok",
               "",
               "Hora braniega de Vladivostok",
               "",
               "Hora de Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Hora del Oc\u00e9anu \u00cdndicu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Hora de les Islles Line",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Hora est\u00e1ndar de Newfoundland",
               "NST",
               "Hora braniega de Newfoundland",
               "NDT",
               "Hora de Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Hora est\u00e1ndar del Turkmenist\u00e1n",
               "",
               "Hora braniega del Turkmenist\u00e1n",
               "",
               "Hora del Turkmenist\u00e1n",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Hora de La Guyana Francesa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Hora est\u00e1ndar de Nueva Caledonia",
               "",
               "Hora braniega de Nueva Caledonia",
               "",
               "Hora de Nueva Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Hora de Xeorxa del Sur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Hora est\u00e1ndar de Yekaterimburgu",
               "",
               "Hora braniega de Yekaterimburgu",
               "",
               "Hora de Yekaterimburgu",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Hora d\u2019\u00c1frica central",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Hora d\u2019\u00c1frica del este",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Hora est\u00e1ndar d\u2019\u00c1frica del oeste",
               "WAT",
               "Hora braniega d\u2019\u00c1frica del oeste",
               "WAT",
               "Hora d\u2019\u00c1frica del oeste",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Hora de Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Hora est\u00e1ndar d\u2019Europa Central",
               "CET",
               "Hora braniega d\u2019Europa Central",
               "CEST",
               "Hora d\u2019Europa Central",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Hora est\u00e1ndar d\u2019Europa del Este",
               "EET",
               "Hora braniega d\u2019Europa del Este",
               "EEST",
               "Hora d\u2019Europa del Este",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Hora est\u00e1ndar d\u2019Europa Occidental",
               "WET",
               "Hora braniega d\u2019Europa Occidental",
               "WEST",
               "Hora d\u2019Europa Occidental",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Hora est\u00e1ndar del Pac\u00edficu de M\u00e9xicu",
               "MST",
               "Hora braniega del Pac\u00edficu de M\u00e9xicu",
               "MDT",
               "Hora del Pac\u00edficu de M\u00e9xicu",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Hora de Sud\u00e1frica",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Hora est\u00e1ndar central norteamericana",
               "CST",
               "Hora braniega central norteamericana",
               "CDT",
               "Hora central norteamericana",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Hora est\u00e1ndar del este norteamericanu",
               "EST",
               "Hora braniega del este norteamericanu",
               "EDT",
               "Hora del este norteamericanu",
               "ET",
            };
        final String[] America_Pacific = new String[] {
               "Hora est\u00e1ndar del Pac\u00edficu norteamericanu",
               "PST",
               "Hora braniega del Pac\u00edficu norteamericanu",
               "PDT",
               "Hora del Pac\u00edficu norteamericanu",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Hora del sur y l\u2019ant\u00e1rticu franc\u00e9s",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Hora de les Islles Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hora est\u00e1ndar de Hawaii-Aleutianes",
               "HAST",
               "Hora braniega de Hawaii-Aleutianes",
               "HADT",
               "Hora de Hawaii-Aleutianes",
               "HAT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Hora de les Islles Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Hora est\u00e1ndar de Saint Pierre y Miquelon",
               "",
               "Hora braniega de Saint Pierre y Miquelon",
               "",
               "Hora de Saint Pierre y Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Hora est\u00e1ndar de les monta\u00f1es norteamericanes",
               "MST",
               "Hora braniega de les monta\u00f1es norteamericanes",
               "MDT",
               "Hora de les monta\u00f1es norteamericanes",
               "MT",
            };
        final String[] Marshall_Islands = new String[] {
               "Hora de les Islles Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Hora est\u00e1ndar del noroeste de M\u00e9xicu",
               "",
               "Hora braniega del noroeste de M\u00e9xicu",
               "",
               "Hora del noroeste de M\u00e9xicu",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Hora de Pap\u00faa Nueva Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Hora est\u00e1ndar d\u2019Australia central",
               "ACST",
               "Hora braniega d\u2019Australia central",
               "ACDT",
               "Hora d\u2019Australia central",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Hora est\u00e1ndar d\u2019Australia del este",
               "AEST",
               "Hora braniega d\u2019Australia del este",
               "AEDT",
               "Hora d\u2019Australia del este",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Hora est\u00e1ndar d\u2019Australia del oeste",
               "AWST",
               "Hora braniega d\u2019Australia del oeste",
               "AWDT",
               "Hora d\u2019Australia del oeste",
               "AWT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Hora est\u00e1ndar de Groenlandia oriental",
               "",
               "Hora braniega de Groenlandia oriental",
               "",
               "Hora de Groenlandia oriental",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Hora est\u00e1ndar de Groenlandia occidental",
               "",
               "Hora braniega de Groenlandia occidental",
               "",
               "Hora de Groenlandia occidental",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Hora d\u2019Indonesia central",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Hora d\u2019Indonesia del este",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Hora d\u2019Indonesia del oeste",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Hora del Kazakst\u00e1n oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Hora del Kazakst\u00e1n occidental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Hora est\u00e1ndar d\u2019Australia central del oeste",
               "",
               "Hora braniega d\u2019Australia central del oeste",
               "",
               "Hora d\u2019Australia central del oeste",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "Hora est\u00e1ndar de Hawaii-Aleutianes",
                    "HST",
                    "Hora braniega de Hawaii-Aleutianes",
                    "HDT",
                    "Hora de Hawaii-Aleutianes",
                    "HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Hora media de Greenwich",
                    "GMT",
                    "Hora est\u00e1ndar irlandesa",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Hora media de Greenwich",
                    "GMT",
                    "Hora braniega brit\u00e1nica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10",
                new String[] {
                    "Hora est\u00e1ndar de Hawaii-Aleutianes",
                    "HST",
                    "Hora braniega de Hawaii-Aleutianes",
                    "HDT",
                    "Hora de Hawaii-Aleutianes",
                    "HST",
                }
            },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Hora media de Greenwich",
                    "GMT",
                    "Hora braniega brit\u00e1nica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Casey },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Baku", "Bak\u00fa" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Am\u00e1n" },
            { "timezone.excity.Asia/Macau", "Mac\u00e1u" },
            { "timezone.excity.Asia/Seoul", "Se\u00fal" },
            { "timezone.excity.Asia/Tokyo", "Tokiu" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Brunei", "Brun\u00e9i" },
            { "timezone.excity.Asia/Hebron", "Hebr\u00f3n" },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "timezone.excity.Asia/Riyadh", "Riyad" },
            { "timezone.excity.Asia/Saigon", "Ciud\u00e1 de Ho Chi Minh" },
            { "timezone.excity.Asia/Tehran", "Te\u1e25r\u00e1n" },
            { "timezone.excity.Etc/Unknown", "Ciud\u00e1 desconocida" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Africa/Cairo", "El Cairu" },
            { "timezone.excity.Africa/Tunis", "T\u00fanez" },
            { "timezone.excity.Asia/Baghdad", "Bagdag" },
            { "timezone.excity.Asia/Bahrain", "Ba\u1e25r\u00e9in" },
            { "timezone.excity.Asia/Jakarta", "Xakarta" },
            { "timezone.excity.Asia/Magadan", "Magad\u00e1n" },
            { "timezone.excity.Asia/Rangoon", "Rang\u00fan" },
            { "timezone.excity.Europe/Paris", "Par\u00eds" },
            { "timezone.excity.Europe/Sofia", "Sof\u00eda" },
            { "timezone.excity.Pacific/Fiji", "Fixi" },
            { "timezone.excity.Africa/Niamey", "Niam\u00e9i" },
            { "timezone.excity.America/Bahia", "Bah\u00eda" },
            { "timezone.excity.Asia/Calcutta", "Calcuta" },
            { "timezone.excity.Asia/Damascus", "Damascu" },
            { "timezone.excity.Asia/Dushanbe", "Duxanb\u00e9" },
            { "timezone.excity.Asia/Jayapura", "Xayapura" },
            { "timezone.excity.Asia/Katmandu", "Katmand\u00fa" },
            { "timezone.excity.Asia/Sakhalin", "Saxal\u00edn" },
            { "timezone.excity.Europe/Athens", "Atenes" },
            { "timezone.excity.Europe/Berlin", "Berl\u00edn" },
            { "timezone.excity.Europe/Dublin", "Dubl\u00edn" },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Europe/London", "Londres" },
            { "timezone.excity.Europe/Monaco", "M\u00f3nacu" },
            { "timezone.excity.Europe/Moscow", "Mosc\u00fa" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "timezone.excity.Europe/Warsaw", "Varsovia" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Arxel" },
            { "timezone.excity.Africa/Tripoli", "Tr\u00edpoli" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cayman", "Caim\u00e1n" },
            { "timezone.excity.America/Havana", "La Habana" },
            { "timezone.excity.America/Panama", "Panam\u00e1" },
            { "timezone.excity.Asia/Hong_Kong", "\u1e24ong Kong" },
            { "timezone.excity.Asia/Jerusalem", "Xerusal\u00e9n" },
            { "timezone.excity.Asia/Pyongyang", "Pyong Yang" },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Asia/Vientiane", "Vienti\u00e1n" },
            { "timezone.excity.Europe/Vatican", "El Vaticanu" },
            { "timezone.excity.Indian/Reunion", "Reuni\u00f3n" },
            { "timezone.excity.Pacific/Easter", "Pascua" },
            { "timezone.excity.Africa/Djibouti", "Xibuti" },
            { "timezone.excity.Africa/Khartoum", "\u1e24artum" },
            { "timezone.excity.Africa/Ndjamena", "Xamena" },
            { "timezone.excity.Africa/Sao_Tome", "Santu Tom\u00e9" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Grenada", "Granada" },
            { "timezone.excity.America/Jamaica", "Xamaica" },
            { "timezone.excity.America/Tortola", "T\u00f3rtola" },
            { "timezone.excity.Atlantic/Azores", "Les Azores" },
            { "timezone.excity.Atlantic/Canary", "Canaries" },
            { "timezone.excity.Atlantic/Faeroe", "Islles Feroe" },
            { "timezone.excity.Europe/Belgrade", "Belgr\u00e1u" },
            { "timezone.excity.Europe/Brussels", "Bruxeles" },
            { "timezone.excity.Europe/Helsinki", "\u1e24\u00e9lsinki" },
            { "timezone.excity.Africa/Mogadishu", "Mogadixu" },
            { "timezone.excity.America/Anguilla", "Anguila" },
            { "timezone.excity.America/New_York", "Nueva York" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ul\u00e1n B\u00e1tor" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "timezone.excity.Europe/Astrakhan", "Astrac\u00e1n" },
            { "timezone.excity.Europe/Bucharest", "Bucarest" },
            { "timezone.excity.Europe/Gibraltar", "Xibraltar" },
            { "timezone.excity.Europe/Ljubljana", "Liubliana" },
            { "timezone.excity.Europe/Stockholm", "Estocolmu" },
            { "timezone.excity.Europe/Volgograd", "Volgogr\u00e1u" },
            { "timezone.excity.Indian/Mauritius", "Mauriciu" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Africa/Nouakchott", "Nuakxot" },
            { "timezone.excity.Europe/Copenhagen", "Copenhague" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburgu" },
            { "timezone.excity.Europe/San_Marino", "San Mar\u00edn" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "timezone.excity.Africa/Addis_Ababa", "Ad\u00eds Abeba" },
            { "timezone.excity.Africa/Ouagadougou", "Uagadug\u00fa" },
            { "timezone.excity.America/Guadeloupe", "Guadalupe" },
            { "timezone.excity.America/Martinique", "La Martinica" },
            { "timezone.excity.Asia/Yekaterinburg", "Yekaterimburgu" },
            { "timezone.excity.Atlantic/Reykjavik", "Reikiavik" },
            { "timezone.excity.Atlantic/St_Helena", "Santa Lena" },
            { "timezone.excity.Australia/Adelaide", "Adelaida" },
            { "timezone.excity.Europe/Isle_of_Man", "Islla de Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningr\u00e1u" },
            { "timezone.excity.Africa/Johannesburg", "Johannesburgu" },
            { "timezone.excity.America/Mexico_City", "Ciud\u00e1 de M\u00e9xicu" },
            { "timezone.excity.America/Puerto_Rico", "Puertu Ricu" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cabu Verde" },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.America/Port_of_Spain", "Puertu Espa\u00f1a" },
            { "timezone.excity.America/Santo_Domingo", "Santu Domingu" },
            { "timezone.excity.America/Bahia_Banderas", "Bah\u00eda Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Puertu Pr\u00edncipe" },
            { "timezone.excity.Atlantic/South_Georgia", "Xeorxa del Sur" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota del Norte" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota del Norte" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Nueva Salem, Dakota del Norte" },
        };
        return data;
    }
}
