/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.rename;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.php.internal.ui.util.PHPElementImageDescriptor;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ASTNodeImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final Point SMALL_SIZE = new Point(16, 16);
    public static final Point BIG_SIZE = new Point(22, 16);
    private ImageDescriptorRegistry fRegistry = null;

    public Image getImageLabel(Object element, int flags) {
        return this.getImageLabel(this.computeDescriptor(element, flags));
    }

    private Image getImageLabel(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getRegistry().get(descriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = PHPUiPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    private ImageDescriptor computeDescriptor(Object element, int flags) {
        if (element instanceof ASTNode) {
            return this.getPHPImageDescriptor((ASTNode)element, flags);
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            if ("as".equals(file.getFileExtension())) {
                return this.getCUResourceImageDescriptor(file, flags);
            }
            return this.getWorkbenchImageDescriptor((IAdaptable)file, flags);
        }
        if (element instanceof IAdaptable) {
            return this.getWorkbenchImageDescriptor((IAdaptable)element, flags);
        }
        return null;
    }

    private static boolean showOverlayIcons(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    public ImageDescriptor getCUResourceImageDescriptor(IFile file, int flags) {
        Point size = ASTNodeImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new PHPElementImageDescriptor(PHPPluginImages.DESC_OBJS_CUNIT_RESOURCE, 0, size);
    }

    public ImageDescriptor getPHPImageDescriptor(ASTNode node, int flags) {
        int adornmentFlags = this.computePHPAdornmentFlags(node, flags);
        Point size = ASTNodeImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new PHPElementImageDescriptor(this.getBaseImageDescriptor(node, flags), adornmentFlags, size);
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable, int flags) {
        IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)adaptable.getAdapter(IWorkbenchAdapter.class);
        if (wbAdapter == null) {
            return null;
        }
        ImageDescriptor descriptor = wbAdapter.getImageDescriptor((Object)adaptable);
        if (descriptor == null) {
            return null;
        }
        Point size = ASTNodeImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new PHPElementImageDescriptor(descriptor, 0, size);
    }

    public ImageDescriptor getBaseImageDescriptor(ASTNode element, int renderFlags) {
        switch (element.getType()) {
            case 29: {
                return PHPPluginImages.DESC_MISC_PUBLIC;
            }
            case 42: {
                MethodDeclaration member = (MethodDeclaration)element;
                return ASTNodeImageProvider.getMethodImageDescriptor(member.getModifier());
            }
            case 25: {
                FieldsDeclaration var = (FieldsDeclaration)element;
                return ASTNodeImageProvider.getFieldImageDescriptor(var.getModifier());
            }
            case 51: {
                return PHPPluginImages.DESC_CONSTANT;
            }
            case 12: {
                return PHPPluginImages.DESC_OBJS_CLASSALT;
            }
            case 40: {
                return PHPPluginImages.DESC_OBJS_INTERFACE;
            }
            case 46: {
                return PHPPluginImages.DESC_OBJS_CUNIT;
            }
        }
        return PHPPluginImages.DESC_OBJS_UNKNOWN;
    }

    protected ImageDescriptor getPHPFolderIcon(Object element, int renderFlags) {
        IContainer folder = (IContainer)element;
        boolean containsPHPElements = false;
        try {
            containsPHPElements = folder.members().length > 0;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (!containsPHPElements) {
            return PHPPluginImages.DESC_OBJS_PHPFOLDER_ROOT;
        }
        return PHPPluginImages.DESC_OBJS_PHPFOLDER_ROOT;
    }

    public void dispose() {
    }

    private int computePHPAdornmentFlags(ASTNode node, int renderFlags) {
        int type = node.getType();
        int flags = 0;
        if (ASTNodeImageProvider.showOverlayIcons(renderFlags)) {
            int modifiers = -1;
            switch (type) {
                case 40: {
                    break;
                }
                case 12: {
                    ClassDeclaration typeDeclaration = (ClassDeclaration)node;
                    modifiers = typeDeclaration.getModifier();
                    break;
                }
                case 42: {
                    MethodDeclaration methodDeclaration = (MethodDeclaration)node;
                    modifiers = methodDeclaration.getModifier();
                    break;
                }
                case 25: {
                    FieldsDeclaration fieldsDeclaration = (FieldsDeclaration)node;
                    modifiers = fieldsDeclaration.getModifier();
                    break;
                }
                case 51: {
                    flags |= 2;
                }
            }
            if (modifiers != -1) {
                flags = this.computeAdornments(modifiers, flags);
            }
        }
        return flags;
    }

    private int computeAdornments(int modifiers, int flags) {
        if (PHPFlags.isAbstract((int)modifiers)) {
            flags |= 4;
        }
        if (PHPFlags.isFinal((int)modifiers)) {
            flags |= 8;
        }
        if (PHPFlags.isStatic((int)modifiers)) {
            flags |= 1;
        }
        return flags;
    }

    public static ImageDescriptor getMethodImageDescriptor(int flags) {
        if (PHPFlags.isProtected((int)flags)) {
            return PHPPluginImages.DESC_MISC_PROTECTED;
        }
        if (PHPFlags.isPrivate((int)flags)) {
            return PHPPluginImages.DESC_MISC_PRIVATE;
        }
        return PHPPluginImages.DESC_MISC_PUBLIC;
    }

    public static ImageDescriptor getFieldImageDescriptor(int flags) {
        if (PHPFlags.isProtected((int)flags)) {
            return PHPPluginImages.DESC_FIELD_PROTECTED;
        }
        if (PHPFlags.isPrivate((int)flags)) {
            return PHPPluginImages.DESC_FIELD_PRIVATE;
        }
        return PHPPluginImages.DESC_FIELD_PUBLIC;
    }

    public static Image getDecoratedImage(ImageDescriptor baseImage, int adornments, Point size) {
        return PHPUiPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new PHPElementImageDescriptor(baseImage, adornments, size));
    }

    public static ImageDescriptor getClassImageDescriptor(TypeDeclaration typeDeclaration) {
        if (typeDeclaration.getType() == 40) {
            return PHPPluginImages.DESC_OBJS_INTERFACE;
        }
        return DLTKPluginImages.DESC_OBJS_CLASS;
    }
}

