/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal;

import java.util.function.Consumer;
import org.eclipse.draw2d.internal.AutoscalingAccess;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;

public class InternalDraw2dUtils {
    private static final String DRAW2D_ENABLE_AUTOSCALE = "draw2d.enableAutoscale";
    private static final String DRAW2D_SCALEDGRAPHICS_BY_DEFAULT = "draw2d.useScaledGraphicsByDefault";
    private static final boolean enableAutoScale = "win32".equals(SWT.getPlatform()) && Boolean.parseBoolean(System.getProperty("draw2d.enableAutoscale", Boolean.TRUE.toString())) && SWT.getVersion() >= 4971;
    private static final boolean useScaledGraphicsByDefault = Boolean.parseBoolean(System.getProperty("draw2d.useScaledGraphicsByDefault", Boolean.FALSE.toString()));

    public static boolean isAutoScaleEnabled() {
        return enableAutoScale;
    }

    public static boolean useScaledGraphicsByDefault() {
        return useScaledGraphicsByDefault;
    }

    public static void configureForAutoscalingMode(Control control, Consumer<Double> zoomConsumer) {
        if (control == null || !InternalDraw2dUtils.isAutoScaleEnabled()) {
            return;
        }
        AutoscalingAccess.setAutoscaleDisabled(control);
        control.addListener(55, e -> zoomConsumer.accept((double)e.detail / 100.0));
        zoomConsumer.accept(Double.valueOf(InternalDraw2dUtils.calculateScale(control)));
    }

    public static void setPropagateAutoScaleDisabled(Control control) {
        if (control == null || !InternalDraw2dUtils.isAutoScaleEnabled()) {
            return;
        }
        AutoscalingAccess.disablePropagateAutoscale(control);
    }

    public static float calculateScale(Control control) {
        int shellZoom = AutoscalingAccess.getShellZoom(control);
        return (float)shellZoom / 100.0f;
    }
}

